/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.Collection;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveRemoveByIdOperation;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.data.couchbase.core.mapping.event.ReactiveAfterDeleteEvent;
import org.springframework.data.couchbase.core.mapping.event.ReactiveBeforeDeleteEvent;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveRemoveByIdOperationSupport
implements ReactiveRemoveByIdOperation {
    private final ReactiveCouchbaseTemplate template;

    public ReactiveRemoveByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public ReactiveRemoveByIdOperation.ReactiveRemoveById removeById() {
        return new ReactiveRemoveByIdSupport(this.template, null, null, null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE, null);
    }

    static class ReactiveRemoveByIdSupport
    implements ReactiveRemoveByIdOperation.ReactiveRemoveById {
        private final ReactiveCouchbaseTemplate template;
        private final String scope;
        private final String collection;
        private final RemoveOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Long cas;

        ReactiveRemoveByIdSupport(ReactiveCouchbaseTemplate template, String scope, String collection, RemoveOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Long cas) {
            this.template = template;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.cas = cas;
        }

        @Override
        public Mono<RemoveResult> one(String id) {
            PseudoArgs<RemoveOptions> pArgs = new PseudoArgs<RemoveOptions>(this.template, this.scope, this.collection, this.options != null ? this.options : RemoveOptions.removeOptions());
            return Mono.just((Object)id).map(r -> {
                this.template.support().maybeEmitEvent(new ReactiveBeforeDeleteEvent<String>((String)r));
                return r;
            }).flatMap(docId -> this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection()).reactive().remove(id, this.buildRemoveOptions((RemoveOptions)pArgs.getOptions())).map(r -> {
                this.template.support().maybeEmitEvent(new ReactiveAfterDeleteEvent<MutationResult>((MutationResult)r));
                return RemoveResult.from(docId, r);
            })).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<RemoveResult> all(Collection<String> ids) {
            return Flux.fromIterable(ids).flatMap(this::one);
        }

        private RemoveOptions buildRemoveOptions(RemoveOptions options) {
            RemoveOptions removeOptions = options = options != null ? options : RemoveOptions.removeOptions();
            if (this.persistTo != PersistTo.NONE || this.replicateTo != ReplicateTo.NONE) {
                options.durability(this.persistTo, this.replicateTo);
            } else if (this.durabilityLevel != DurabilityLevel.NONE) {
                options.durability(this.durabilityLevel);
            }
            if (this.cas != null) {
                options.cas(this.cas.longValue());
            }
            return options;
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdInCollection withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ReactiveRemoveByIdSupport(this.template, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.cas);
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdInCollection withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ReactiveRemoveByIdSupport(this.template, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdWithDurability inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveRemoveByIdSupport(this.template, this.scope, collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdInCollection inScope(String scope) {
            Assert.hasText((String)scope, (String)"Scope must not be null nor empty.");
            return new ReactiveRemoveByIdSupport(this.template, scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ReactiveRemoveByIdOperation.TerminatingRemoveById withOptions(RemoveOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveRemoveByIdSupport(this.template, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdWithDurability withCas(Long cas) {
            return new ReactiveRemoveByIdSupport(this.template, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, cas);
        }
    }
}

