/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping.event;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.auditing.ReactiveIsNewAwareAuditingHandler;
import org.springframework.data.couchbase.core.mapping.event.CouchbaseMappingEvent;
import org.springframework.data.couchbase.core.mapping.event.ReactiveAfterDeleteEvent;
import org.springframework.data.couchbase.core.mapping.event.ReactiveAfterSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.ReactiveBeforeConvertEvent;
import org.springframework.data.couchbase.core.mapping.event.ReactiveBeforeDeleteEvent;
import org.springframework.data.couchbase.core.mapping.event.ReactiveBeforeSaveEvent;
import org.springframework.util.Assert;

public class ReactiveAuditingEventListener
implements ApplicationListener<CouchbaseMappingEvent<Object>> {
    private final ObjectFactory<ReactiveIsNewAwareAuditingHandler> auditingHandlerFactory;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveAuditingEventListener.class);

    public ReactiveAuditingEventListener() {
        this.auditingHandlerFactory = null;
    }

    public ReactiveAuditingEventListener(ObjectFactory<ReactiveIsNewAwareAuditingHandler> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    public void onApplicationEvent(CouchbaseMappingEvent<Object> event) {
        if (event instanceof ReactiveBeforeConvertEvent) {
            Optional.ofNullable(event.getSource()).ifPresent(it -> ((ReactiveIsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject()).markAudited(it));
        }
        if (event instanceof ReactiveBeforeSaveEvent) {
            // empty if block
        }
        if (event instanceof ReactiveAfterSaveEvent) {
            // empty if block
        }
        if (event instanceof ReactiveBeforeDeleteEvent) {
            // empty if block
        }
        if (event instanceof ReactiveAfterDeleteEvent) {
            // empty if block
        }
        if (((Object)event).getClass().getSimpleName().startsWith("Reactive") && LOG.isDebugEnabled()) {
            LOG.debug(((Object)event).getClass().getSimpleName() + " " + event.getSource());
        }
    }
}

