/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.ReactiveFindByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.AbstractCouchbaseQueryBase;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseQueryExecution;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ResultProcessingConverter;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractReactiveCouchbaseQuery
extends AbstractCouchbaseQueryBase<ReactiveCouchbaseOperations>
implements RepositoryQuery {
    private final ReactiveFindByQueryOperation.ReactiveFindByQuery<?> findOperationWithProjection;

    public AbstractReactiveCouchbaseQuery(ReactiveCouchbaseQueryMethod method, ReactiveCouchbaseOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, operations, expressionParser, evaluationContextProvider);
        Assert.notNull((Object)((Object)method), (String)"CouchbaseQueryMethod must not be null!");
        Assert.notNull((Object)operations, (String)"ReactiveCouchbaseOperations must not be null!");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"QueryMethodEvaluationContextProvider must not be null!");
        EntityMetadata metadata = method.getEntityInformation();
        Class type = metadata.getJavaType();
        this.findOperationWithProjection = operations.findByQuery(type);
    }

    @Override
    protected Object doExecute(CouchbaseQueryMethod method, ResultProcessor processor, ParametersParameterAccessor accessor, @Nullable Class<?> typeToRead) {
        Query query = this.createQuery(accessor);
        query = this.applyAnnotatedConsistencyIfPresent(query);
        ReactiveFindByQueryOperation.ReactiveFindByQuery<?> find = typeToRead == null ? this.findOperationWithProjection : this.findOperationWithProjection;
        String collection = null;
        ReactiveCouchbaseQueryExecution execution = this.getExecution((ParameterAccessor)accessor, new ResultProcessingConverter(processor, this.getOperations(), this.getInstantiators()), find);
        return execution.execute(query, processor.getReturnedType().getDomainType(), collection);
    }

    private ReactiveCouchbaseQueryExecution getExecution(ParameterAccessor accessor, Converter<Object, Object> resultProcessing, ReactiveFindByQueryOperation.FindByQueryWithQuery<?> operation) {
        return new ReactiveCouchbaseQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(accessor, operation), resultProcessing);
    }

    private ReactiveCouchbaseQueryExecution getExecutionToWrap(ParameterAccessor accessor, ReactiveFindByQueryOperation.FindByQueryWithQuery<?> operation) {
        if (this.isDeleteQuery()) {
            return new ReactiveCouchbaseQueryExecution.DeleteExecution((ReactiveCouchbaseOperations)this.getOperations(), this.getQueryMethod());
        }
        if (this.isTailable(this.getQueryMethod())) {
            return (q, t, c) -> operation.matching(q.with(accessor.getPageable())).all();
        }
        if (this.getQueryMethod().isCollectionQuery()) {
            return (q, t, c) -> operation.matching(q.with(accessor.getPageable())).all();
        }
        if (this.isCountQuery()) {
            return (q, t, c) -> operation.matching(q).count();
        }
        if (this.isExistsQuery()) {
            return (q, t, c) -> operation.matching(q).exists();
        }
        return (q, t, c) -> {
            Object find = operation.matching(q);
            return this.isLimiting() ? find.first() : find.one();
        };
    }

    Query applyQueryMetaAttributesWhenPresent(Query query) {
        if (this.getQueryMethod().hasQueryMetaAttributes()) {
            query.setMeta(this.getQueryMethod().getQueryMetaAttributes());
        }
        return query;
    }
}

