/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.couchbase.core.AbstractTemplateSupport;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.ReactiveAfterConvertCallback;
import org.springframework.data.couchbase.core.mapping.event.ReactiveBeforeConvertCallback;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import org.springframework.data.mapping.callback.ReactiveEntityCallbacks;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

class ReactiveCouchbaseTemplateSupport
extends AbstractTemplateSupport
implements ApplicationContextAware,
ReactiveTemplateSupport {
    private final ReactiveCouchbaseTemplate template;
    private ReactiveEntityCallbacks reactiveEntityCallbacks;

    public ReactiveCouchbaseTemplateSupport(ReactiveCouchbaseTemplate template, CouchbaseConverter converter, TranslationService translationService) {
        super(template, converter, translationService);
        this.template = template;
    }

    @Override
    public Mono<CouchbaseDocument> encodeEntity(Object entityToEncode) {
        return Mono.just((Object)entityToEncode).doOnNext(entity -> this.maybeEmitEvent(new BeforeConvertEvent<Object>(entity))).flatMap(entity -> this.maybeCallBeforeConvert(entity, "")).map(maybeNewEntity -> {
            CouchbaseDocument converted = new CouchbaseDocument();
            this.converter.write(maybeNewEntity, converted);
            return converted;
        }).flatMap(converted -> this.maybeCallAfterConvert((Object)entityToEncode, (CouchbaseDocument)converted, "").thenReturn(converted)).doOnNext(converted -> this.maybeEmitEvent(new BeforeSaveEvent<Object>(entityToEncode, (CouchbaseDocument)converted)));
    }

    @Override
    ReactiveCouchbaseTemplate getReactiveTemplate() {
        return this.template;
    }

    @Override
    public <T> Mono<T> decodeEntity(Object id, String source, Long cas, Class<T> entityClass, String scope, String collection, Object txResultHolder, CouchbaseResourceHolder holder) {
        return Mono.fromSupplier(() -> this.decodeEntityBase(id, source, cas, entityClass, scope, collection, txResultHolder, holder));
    }

    @Override
    public <T> Mono<T> applyResult(T entity, CouchbaseDocument converted, Object id, Long cas, Object txResultHolder, CouchbaseResourceHolder holder) {
        return Mono.fromSupplier(() -> this.applyResultBase(entity, converted, id, cas, txResultHolder, holder));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (this.reactiveEntityCallbacks == null) {
            this.setReactiveEntityCallbacks(ReactiveEntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setReactiveEntityCallbacks(ReactiveEntityCallbacks reactiveEntityCallbacks) {
        Assert.notNull((Object)reactiveEntityCallbacks, (String)"EntityCallbacks must not be null!");
        this.reactiveEntityCallbacks = reactiveEntityCallbacks;
    }

    protected <T> Mono<T> maybeCallBeforeConvert(T object, String collection) {
        if (this.reactiveEntityCallbacks != null) {
            return this.reactiveEntityCallbacks.callback(ReactiveBeforeConvertCallback.class, object, new Object[]{collection});
        }
        LOG.info("maybeCallBeforeConvert called, but ReactiveCouchbaseTemplate not initialized with applicationContext");
        return Mono.just(object);
    }

    protected <T> Mono<T> maybeCallAfterConvert(T object, CouchbaseDocument document, String collection) {
        if (null != this.reactiveEntityCallbacks) {
            return this.reactiveEntityCallbacks.callback(ReactiveAfterConvertCallback.class, object, new Object[]{document, collection});
        }
        LOG.info("maybeCallAfterConvert called, but ReactiveCouchbaseTemplate not initialized with applicationContext");
        return Mono.just(object);
    }
}

