/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping.event;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.couchbase.core.mapping.event.AfterSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.CouchbaseMappingEvent;

public class AbstractCouchbaseEventListener<E>
implements ApplicationListener<CouchbaseMappingEvent<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCouchbaseEventListener.class);
    private final Class<?> domainClass;

    public AbstractCouchbaseEventListener() {
        Class typeArgument = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractCouchbaseEventListener.class);
        this.domainClass = typeArgument == null ? Object.class : typeArgument;
    }

    public void onApplicationEvent(CouchbaseMappingEvent<?> event) {
        Object source = event.getSource();
        if (source != null && !this.domainClass.isAssignableFrom(source.getClass())) {
            return;
        }
        if (event instanceof BeforeDeleteEvent) {
            this.onBeforeDelete(event.getSource(), event.getDocument());
        } else if (event instanceof AfterDeleteEvent) {
            this.onAfterDelete(event.getSource(), event.getDocument());
        } else if (event instanceof BeforeConvertEvent) {
            this.onBeforeConvert(source);
        } else if (event instanceof BeforeSaveEvent) {
            this.onBeforeSave(source, event.getDocument());
        } else if (event instanceof AfterSaveEvent) {
            this.onAfterSave(source, event.getDocument());
        }
    }

    public void onBeforeConvert(E source) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("onBeforeConvert({})", source);
        }
    }

    public void onBeforeSave(E source, CouchbaseDocument doc) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("onBeforeSave({}, {})", source, (Object)doc);
        }
    }

    public void onAfterSave(E source, CouchbaseDocument doc) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("onAfterSave({}, {})", source, (Object)doc);
        }
    }

    public void onAfterDelete(Object source, CouchbaseDocument doc) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("onAfterConvert({})", (Object)doc);
        }
    }

    public void onBeforeDelete(Object source, CouchbaseDocument doc) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("onAfterConvert({})", (Object)doc);
        }
    }
}

