/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.GeoBoundingBoxFilterBuilder;
import org.elasticsearch.index.query.GeoDistanceFilterBuilder;
import org.elasticsearch.index.query.NotFilterBuilder;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.springframework.data.elasticsearch.core.geo.GeoBox;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.util.Assert;

class CriteriaFilterProcessor {
    CriteriaFilterProcessor() {
    }

    FilterBuilder createFilterFromCriteria(Criteria criteria) {
        LinkedList<Object> fbList = new LinkedList<Object>();
        Object filter = null;
        ListIterator<Criteria> chainIterator = criteria.getCriteriaChain().listIterator();
        while (chainIterator.hasNext()) {
            OrFilterBuilder fb = null;
            Criteria chainedCriteria = chainIterator.next();
            if (chainedCriteria.isOr()) {
                fb = FilterBuilders.orFilter((FilterBuilder[])this.createFilterFragmentForCriteria(chainedCriteria).toArray(new FilterBuilder[0]));
                fbList.add(fb);
                continue;
            }
            if (chainedCriteria.isNegating()) {
                List<FilterBuilder> negationFilters = this.buildNegationFilter(criteria.getField().getName(), criteria.getFilterCriteriaEntries().iterator());
                if (negationFilters.isEmpty()) continue;
                fbList.addAll(negationFilters);
                continue;
            }
            fbList.addAll(this.createFilterFragmentForCriteria(chainedCriteria));
        }
        if (!fbList.isEmpty()) {
            filter = fbList.size() == 1 ? (FilterBuilder)fbList.get(0) : FilterBuilders.andFilter((FilterBuilder[])fbList.toArray(new FilterBuilder[0]));
        }
        return filter;
    }

    private List<FilterBuilder> createFilterFragmentForCriteria(Criteria chainedCriteria) {
        Iterator<Criteria.CriteriaEntry> it = chainedCriteria.getFilterCriteriaEntries().iterator();
        LinkedList<FilterBuilder> filterList = new LinkedList<FilterBuilder>();
        String fieldName = chainedCriteria.getField().getName();
        Assert.notNull((Object)fieldName, (String)"Unknown field");
        FilterBuilder filter = null;
        while (it.hasNext()) {
            Criteria.CriteriaEntry entry = it.next();
            filter = this.processCriteriaEntry(entry.getKey(), entry.getValue(), fieldName);
            filterList.add(filter);
        }
        return filterList;
    }

    private FilterBuilder processCriteriaEntry(Criteria.OperationKey key, Object value, String fieldName) {
        if (value == null) {
            return null;
        }
        GeoDistanceFilterBuilder filter = null;
        switch (key) {
            case WITHIN: {
                filter = FilterBuilders.geoDistanceFilter((String)fieldName);
                Assert.isTrue((boolean)(value instanceof Object[]), (String)"Value of a geo distance filter should be an array of two values.");
                Object[] valArray = (Object[])value;
                Assert.noNullElements((Object[])valArray, (String)"Geo distance filter takes 2 not null elements array as parameter.");
                Assert.isTrue((valArray.length == 2 ? 1 : 0) != 0, (String)"Geo distance filter takes a 2-elements array as parameter.");
                Assert.isTrue((valArray[0] instanceof GeoPoint || valArray[0] instanceof String ? 1 : 0) != 0, (String)"First element of a geo distance filter must be a GeoLocation or String");
                Assert.isTrue((boolean)(valArray[1] instanceof String), (String)"Second element of a geo distance filter must be a String");
                String dist = (String)valArray[1];
                if (valArray[0] instanceof GeoPoint) {
                    GeoPoint loc = (GeoPoint)valArray[0];
                    filter.lat(loc.getLat()).lon(loc.getLon()).distance(dist);
                    break;
                }
                String loc = (String)valArray[0];
                if (loc.contains(",")) {
                    String[] c = loc.split(",");
                    filter.lat(Double.parseDouble(c[0])).lon(Double.parseDouble(c[1])).distance(dist);
                    break;
                }
                filter.geohash(loc).distance(dist);
                break;
            }
            case BBOX: {
                filter = FilterBuilders.geoBoundingBoxFilter((String)fieldName);
                Assert.isTrue((boolean)(value instanceof Object[]), (String)"Value of a boundedBy filter should be an array of one or two values.");
                Object[] valArray = (Object[])value;
                Assert.noNullElements((Object[])valArray, (String)"Geo boundedBy filter takes a not null element array as parameter.");
                if (valArray.length == 1) {
                    this.oneParameterBBox((GeoBoundingBoxFilterBuilder)filter, valArray[0]);
                    break;
                }
                if (valArray.length == 2) {
                    this.twoParameterBBox((GeoBoundingBoxFilterBuilder)filter, valArray);
                    break;
                }
                Assert.isTrue((boolean)false, (String)"Geo distance filter takes a 1-elements array(GeoBox) or 2-elements array(GeoPoints or Strings(format lat,lon or geohash)).");
                break;
            }
        }
        return filter;
    }

    private void oneParameterBBox(GeoBoundingBoxFilterBuilder filter, Object value) {
        Assert.isTrue((boolean)(value instanceof GeoBox), (String)"single-element of boundedBy filter must be type of GeoBox");
        GeoBox geoBBox = (GeoBox)value;
        filter.topLeft(geoBBox.getTopLeft().getLat(), geoBBox.getTopLeft().getLon());
        filter.bottomRight(geoBBox.getBottomRight().getLat(), geoBBox.getBottomRight().getLon());
    }

    private static boolean isType(Object[] array, Class clazz) {
        for (Object o : array) {
            if (clazz.isInstance(o)) continue;
            return false;
        }
        return true;
    }

    private void twoParameterBBox(GeoBoundingBoxFilterBuilder filter, Object[] values) {
        Assert.isTrue((CriteriaFilterProcessor.isType(values, GeoPoint.class) || CriteriaFilterProcessor.isType(values, String.class) ? 1 : 0) != 0, (String)" both elements of boundedBy filter must be type of GeoPoint or String(format lat,lon or geohash)");
        if (values[0] instanceof GeoPoint) {
            GeoPoint topLeft = (GeoPoint)values[0];
            GeoPoint bottomRight = (GeoPoint)values[1];
            filter.topLeft(topLeft.getLat(), topLeft.getLon());
            filter.bottomRight(bottomRight.getLat(), bottomRight.getLon());
        } else {
            String topLeft = (String)values[0];
            String bottomRight = (String)values[1];
            filter.topLeft(topLeft);
            filter.bottomRight(bottomRight);
        }
    }

    private List<FilterBuilder> buildNegationFilter(String fieldName, Iterator<Criteria.CriteriaEntry> it) {
        LinkedList<FilterBuilder> notFilterList = new LinkedList<FilterBuilder>();
        while (it.hasNext()) {
            Criteria.CriteriaEntry criteriaEntry = it.next();
            NotFilterBuilder notFilter = FilterBuilders.notFilter((FilterBuilder)this.processCriteriaEntry(criteriaEntry.getKey(), criteriaEntry.getValue(), fieldName));
            notFilterList.add((FilterBuilder)notFilter);
        }
        return notFilterList;
    }
}

