/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.facet.request;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.facet.FacetBuilders;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.TermsFacetBuilder;
import org.springframework.data.elasticsearch.core.facet.AbstractFacetRequest;
import org.springframework.data.elasticsearch.core.facet.request.TermFacetOrder;
import org.springframework.util.Assert;

public class TermFacetRequest
extends AbstractFacetRequest {
    private String[] fields;
    private Object[] excludeTerms;
    private int size = 10;
    private TermFacetOrder order = TermFacetOrder.descCount;
    private boolean allTerms = false;
    private String regex = null;
    private int regexFlag = 0;

    public TermFacetRequest(String name) {
        super(name);
    }

    public void setFields(String ... fields) {
        this.fields = fields;
    }

    public void setSize(int size) {
        Assert.isTrue((size >= 0 ? 1 : 0) != 0, (String)"Size should be bigger then zero !!!");
        this.size = size;
    }

    public void setOrder(TermFacetOrder order) {
        this.order = order;
    }

    public void setExcludeTerms(Object ... excludeTerms) {
        this.excludeTerms = excludeTerms;
    }

    public void setAllTerms(boolean allTerms) {
        this.allTerms = allTerms;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setRegex(String regex, int regexFlag) {
        this.regex = regex;
        this.regexFlag = regexFlag;
    }

    @Override
    public FacetBuilder getFacet() {
        Assert.notEmpty((Object[])this.fields, (String)"Please select at last one field !!!");
        TermsFacetBuilder builder = FacetBuilders.termsFacet((String)this.getName()).fields(this.fields).size(this.size);
        switch (this.order) {
            case descTerm: {
                builder.order(TermsFacet.ComparatorType.REVERSE_TERM);
                break;
            }
            case ascTerm: {
                builder.order(TermsFacet.ComparatorType.TERM);
                break;
            }
            case ascCount: {
                builder.order(TermsFacet.ComparatorType.REVERSE_COUNT);
                break;
            }
            default: {
                builder.order(TermsFacet.ComparatorType.COUNT);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])this.excludeTerms)) {
            builder.exclude(this.excludeTerms);
        }
        if (this.allTerms) {
            builder.allTerms(this.allTerms);
        }
        if (StringUtils.isNotBlank((String)this.regex)) {
            builder.regex(this.regex, this.regexFlag);
        }
        return builder;
    }
}

