/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.io.Serializable;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformationCreator;
import org.springframework.data.elasticsearch.repository.support.MappingElasticsearchEntityInformation;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

public class ElasticsearchEntityInformationCreatorImpl
implements ElasticsearchEntityInformationCreator {
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    public ElasticsearchEntityInformationCreatorImpl(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.mappingContext = mappingContext;
    }

    @Override
    public <T, ID extends Serializable> ElasticsearchEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        Assert.notNull((Object)persistentEntity, (String)String.format("Unable to obtain mapping metadata for %s!", domainClass));
        Assert.notNull((Object)persistentEntity.getIdProperty(), (String)String.format("No id property found for %s!", domainClass));
        return new MappingElasticsearchEntityInformation(persistentEntity);
    }
}

