/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.aggregation.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.FacetedPageImpl;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;

public class AggregatedPageImpl<T>
extends FacetedPageImpl<T>
implements AggregatedPage<T> {
    private Aggregations aggregations;
    private Map<String, Aggregation> mapOfAggregations = new HashMap<String, Aggregation>();
    private String scrollId;

    public AggregatedPageImpl(List<T> content) {
        super(content);
    }

    public AggregatedPageImpl(List<T> content, String scrollId) {
        super(content);
        this.scrollId = scrollId;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total) {
        super(content, pageable, total);
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, String scrollId) {
        super(content, pageable, total);
        this.scrollId = scrollId;
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, Aggregations aggregations) {
        super(content, pageable, total);
        this.aggregations = aggregations;
        if (aggregations != null) {
            for (Aggregation aggregation : aggregations) {
                this.mapOfAggregations.put(aggregation.getName(), aggregation);
            }
        }
    }

    public AggregatedPageImpl(List<T> content, Pageable pageable, long total, Aggregations aggregations, String scrollId) {
        super(content, pageable, total);
        this.aggregations = aggregations;
        this.scrollId = scrollId;
        if (aggregations != null) {
            for (Aggregation aggregation : aggregations) {
                this.mapOfAggregations.put(aggregation.getName(), aggregation);
            }
        }
    }

    @Override
    public boolean hasAggregations() {
        return this.aggregations != null && this.mapOfAggregations.size() > 0;
    }

    @Override
    public Aggregations getAggregations() {
        return this.aggregations;
    }

    @Override
    public Aggregation getAggregation(String name) {
        return this.aggregations == null ? null : this.aggregations.get(name);
    }

    @Override
    public String getScrollId() {
        return this.scrollId;
    }
}

