/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.ClientLogger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public final class RestClients {
    private static final String LOG_ID_ATTRIBUTE = RestClients.class.getName() + ".LOG_ID";

    private RestClients() {
    }

    public static ElasticsearchRestClient create(ClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration, (String)"ClientConfiguration must not be null!");
        HttpHost[] httpHosts = (HttpHost[])RestClients.formattedHosts(clientConfiguration.getEndpoints(), clientConfiguration.useSsl()).stream().map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        HttpHeaders headers = clientConfiguration.getDefaultHeaders();
        if (!headers.isEmpty()) {
            Header[] httpHeaders = (Header[])headers.toSingleValueMap().entrySet().stream().map(it -> new BasicHeader((String)it.getKey(), (String)it.getValue())).toArray(Header[]::new);
            builder.setDefaultHeaders(httpHeaders);
        }
        builder.setHttpClientConfigCallback(clientBuilder -> {
            Optional<SSLContext> sslContext = clientConfiguration.getSslContext();
            Optional<HostnameVerifier> hostNameVerifier = clientConfiguration.getHostNameVerifier();
            sslContext.ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLContext(arg_0));
            hostNameVerifier.ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLHostnameVerifier(arg_0));
            if (ClientLogger.isEnabled()) {
                HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
                clientBuilder.addInterceptorLast((HttpRequestInterceptor)interceptor);
                clientBuilder.addInterceptorLast((HttpResponseInterceptor)interceptor);
            }
            Duration connectTimeout = clientConfiguration.getConnectTimeout();
            Duration timeout = clientConfiguration.getSocketTimeout();
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            if (!connectTimeout.isNegative()) {
                requestConfigBuilder.setConnectTimeout(Math.toIntExact(connectTimeout.toMillis()));
                requestConfigBuilder.setConnectionRequestTimeout(Math.toIntExact(connectTimeout.toMillis()));
            }
            if (!timeout.isNegative()) {
                requestConfigBuilder.setSocketTimeout(Math.toIntExact(timeout.toMillis()));
            }
            clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            return clientBuilder;
        });
        RestHighLevelClient client = new RestHighLevelClient(builder);
        return () -> client;
    }

    private static List<String> formattedHosts(List<InetSocketAddress> hosts, boolean useSsl) {
        return hosts.stream().map(it -> (useSsl ? "https" : "http") + "://" + it).collect(Collectors.toList());
    }

    private static class HttpLoggingInterceptor
    implements HttpResponseInterceptor,
    HttpRequestInterceptor {
        private HttpLoggingInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws IOException {
            String logId = (String)context.getAttribute(LOG_ID_ATTRIBUTE);
            if (logId == null) {
                logId = ClientLogger.newLogId();
                context.setAttribute(LOG_ID_ATTRIBUTE, (Object)logId);
            }
            if (request instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request).getEntity() != null) {
                HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)request;
                HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                entity.writeTo((OutputStream)buffer);
                if (!entity.isRepeatable()) {
                    entityRequest.setEntity((HttpEntity)new ByteArrayEntity(buffer.toByteArray()));
                }
                ClientLogger.logRequest(logId, request.getRequestLine().getMethod(), request.getRequestLine().getUri(), "", () -> new String(buffer.toByteArray()));
            } else {
                ClientLogger.logRequest(logId, request.getRequestLine().getMethod(), request.getRequestLine().getUri(), "");
            }
        }

        public void process(HttpResponse response, HttpContext context) {
            String logId = (String)context.getAttribute(LOG_ID_ATTRIBUTE);
            ClientLogger.logRawResponse(logId, HttpStatus.resolve((int)response.getStatusLine().getStatusCode()));
        }
    }

    @FunctionalInterface
    public static interface ElasticsearchRestClient
    extends Closeable {
        public RestHighLevelClient rest();

        default public RestClient lowLevelRest() {
            return this.rest().getLowLevelClient();
        }

        @Override
        default public void close() throws IOException {
            this.rest().close();
        }
    }
}

