/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.ResultsMapper;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.util.Assert;

public abstract class AbstractResultMapper
implements ResultsMapper {
    private final EntityMapper entityMapper;
    private final ProjectionFactory projectionFactory;

    public AbstractResultMapper(EntityMapper entityMapper) {
        this(entityMapper, (ProjectionFactory)new SpelAwareProxyProjectionFactory());
    }

    public AbstractResultMapper(EntityMapper entityMapper, ProjectionFactory projectionFactory) {
        Assert.notNull((Object)entityMapper, (String)"EntityMapper must not be null!");
        Assert.notNull((Object)projectionFactory, (String)"ProjectionFactory must not be null!");
        this.entityMapper = entityMapper;
        this.projectionFactory = projectionFactory;
    }

    @Override
    public EntityMapper getEntityMapper() {
        return this.entityMapper;
    }

    @Override
    public ProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }
}

