/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WrapperQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.CriteriaQueryProcessor;
import org.springframework.data.elasticsearch.core.DefaultResultMapper;
import org.springframework.data.elasticsearch.core.ElasticsearchExceptionTranslator;
import org.springframework.data.elasticsearch.core.EntityOperations;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ResultsMapper;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveElasticsearchTemplate
implements ReactiveElasticsearchOperations {
    private static final Logger QUERY_LOGGER = LoggerFactory.getLogger((String)"org.springframework.data.elasticsearch.core.QUERY");
    private final ReactiveElasticsearchClient client;
    private final ElasticsearchConverter converter;
    @NonNull
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;
    private final ResultsMapper resultMapper;
    private final ElasticsearchExceptionTranslator exceptionTranslator;
    private final EntityOperations operations;
    @Nullable
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;
    @Nullable
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosedIgnoreThrottled();

    public ReactiveElasticsearchTemplate(ReactiveElasticsearchClient client) {
        this(client, new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()));
    }

    public ReactiveElasticsearchTemplate(ReactiveElasticsearchClient client, ElasticsearchConverter converter) {
        this(client, converter, new DefaultResultMapper(converter.getMappingContext()));
    }

    public ReactiveElasticsearchTemplate(ReactiveElasticsearchClient client, ElasticsearchConverter converter, ResultsMapper resultsMapper) {
        this.client = client;
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.resultMapper = resultsMapper;
        this.exceptionTranslator = new ElasticsearchExceptionTranslator();
        this.operations = new EntityOperations(this.mappingContext);
    }

    @Override
    public <T> Publisher<T> execute(ReactiveElasticsearchOperations.ClientCallback<Publisher<T>> callback) {
        return Flux.defer(() -> callback.doWithClient(this.getClient())).onErrorMap(this::translateException);
    }

    @Override
    public <T> Mono<T> save(T entity, @Nullable String index, @Nullable String type) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        EntityOperations.AdaptibleEntity adaptableEntity = this.operations.forEntity(entity, this.converter.getConversionService());
        return this.doIndex(entity, adaptableEntity, index, type).map(it -> adaptableEntity.populateIdIfNecessary(it.getId()));
    }

    private Mono<IndexResponse> doIndex(Object value, EntityOperations.AdaptibleEntity<?> entity, @Nullable String index, @Nullable String type) {
        return Mono.defer(() -> {
            Object parentId;
            Number version;
            Object id = entity.getId();
            EntityOperations.IndexCoordinates indexCoordinates = this.operations.determineIndex(entity, index, type);
            IndexRequest request = id != null ? new IndexRequest(indexCoordinates.getIndexName(), indexCoordinates.getTypeName(), this.converter.convertId(id)) : new IndexRequest(indexCoordinates.getIndexName(), indexCoordinates.getTypeName());
            try {
                request.source(this.resultMapper.getEntityMapper().mapToString(value), Requests.INDEX_CONTENT_TYPE);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (entity.isVersionedEntity() && (version = entity.getVersion()) != null) {
                request.version(version.longValue());
                request.versionType(VersionType.EXTERNAL);
            }
            if (entity.hasParent() && (parentId = entity.getParentId()) != null) {
                request.parent(this.converter.convertId(parentId));
            }
            request = this.prepareIndexRequest(value, request);
            return this.doIndex(request);
        });
    }

    @Override
    public <T> Mono<T> findById(String id, Class<T> entityType, @Nullable String index, @Nullable String type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        return this.doFindById(id, this.getPersistentEntity(entityType), index, type).map(it -> this.resultMapper.mapGetResult((GetResult)it, entityType));
    }

    private Mono<GetResult> doFindById(String id, ElasticsearchPersistentEntity<?> entity, @Nullable String index, @Nullable String type) {
        return Mono.defer(() -> {
            EntityOperations.IndexCoordinates indexCoordinates = this.operations.determineIndex(entity, index, type);
            return this.doFindById(new GetRequest(indexCoordinates.getIndexName(), indexCoordinates.getTypeName(), id));
        });
    }

    @Override
    public Mono<Boolean> exists(String id, Class<?> entityType, String index, String type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        return this.doExists(id, this.getPersistentEntity(entityType), index, type);
    }

    private Mono<Boolean> doExists(String id, ElasticsearchPersistentEntity<?> entity, @Nullable String index, @Nullable String type) {
        return Mono.defer(() -> {
            EntityOperations.IndexCoordinates indexCoordinates = this.operations.determineIndex(entity, index, type);
            return this.doExists(new GetRequest(indexCoordinates.getIndexName(), indexCoordinates.getTypeName(), id));
        });
    }

    @Override
    public <T> Flux<T> find(Query query, Class<?> entityType, @Nullable String index, @Nullable String type, Class<T> resultType) {
        return this.doFind(query, this.getPersistentEntity(entityType), index, type).map(it -> this.resultMapper.mapSearchHit((SearchHit)it, resultType));
    }

    private Flux<SearchHit> doFind(Query query, ElasticsearchPersistentEntity<?> entity, @Nullable String index, @Nullable String type) {
        return Flux.defer(() -> {
            SearchRequest request = this.prepareSearchRequest(this.buildSearchRequest(query, entity, index, type));
            if (query.getPageable().isPaged()) {
                return this.doFind(request);
            }
            return this.doScroll(request);
        });
    }

    @Override
    public Mono<Long> count(Query query, Class<?> entityType, String index, String type) {
        return this.doCount(query, this.getPersistentEntity(entityType), index, type);
    }

    private Mono<Long> doCount(Query query, ElasticsearchPersistentEntity<?> entity, @Nullable String index, @Nullable String type) {
        return Mono.defer(() -> {
            CountRequest countRequest = this.buildCountRequest(query, entity, index, type);
            CountRequest request = this.prepareCountRequest(countRequest);
            return this.doCount(request);
        });
    }

    private CountRequest buildCountRequest(Query query, ElasticsearchPersistentEntity<?> entity, @Nullable String index, @Nullable String type) {
        EntityOperations.IndexCoordinates indexCoordinates = this.operations.determineIndex(entity, index, type);
        CountRequest request = new CountRequest(ReactiveElasticsearchTemplate.indices(query, indexCoordinates::getIndexName));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(this.mappedQuery(query, entity));
        searchSourceBuilder.trackScores(query.getTrackScores());
        QueryBuilder postFilterQuery = this.mappedFilterQuery(query, entity);
        if (postFilterQuery != null) {
            searchSourceBuilder.postFilter(postFilterQuery);
        }
        if (query.getSourceFilter() != null) {
            searchSourceBuilder.fetchSource(query.getSourceFilter().getIncludes(), query.getSourceFilter().getExcludes());
        }
        if (query instanceof SearchQuery && ((SearchQuery)query).getCollapseBuilder() != null) {
            searchSourceBuilder.collapse(((SearchQuery)query).getCollapseBuilder());
        }
        ReactiveElasticsearchTemplate.sort(query, entity).forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).sort(arg_0));
        if (query.getMinScore() > 0.0f) {
            searchSourceBuilder.minScore(query.getMinScore());
        }
        if (query.getIndicesOptions() != null) {
            request.indicesOptions(query.getIndicesOptions());
        }
        if (query.getPreference() != null) {
            request.preference(query.getPreference());
        }
        request.source(searchSourceBuilder);
        return request;
    }

    private SearchRequest buildSearchRequest(Query query, ElasticsearchPersistentEntity<?> entity, @Nullable String index, @Nullable String type) {
        Pageable pageable;
        EntityOperations.IndexCoordinates indexCoordinates = this.operations.determineIndex(entity, index, type);
        SearchRequest request = new SearchRequest(ReactiveElasticsearchTemplate.indices(query, indexCoordinates::getIndexName));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(this.mappedQuery(query, entity));
        searchSourceBuilder.version(Boolean.valueOf(entity.hasVersionProperty()));
        searchSourceBuilder.trackScores(query.getTrackScores());
        QueryBuilder postFilterQuery = this.mappedFilterQuery(query, entity);
        if (postFilterQuery != null) {
            searchSourceBuilder.postFilter(postFilterQuery);
        }
        if (query.getSourceFilter() != null) {
            searchSourceBuilder.fetchSource(query.getSourceFilter().getIncludes(), query.getSourceFilter().getExcludes());
        }
        if (query instanceof SearchQuery && ((SearchQuery)query).getCollapseBuilder() != null) {
            searchSourceBuilder.collapse(((SearchQuery)query).getCollapseBuilder());
        }
        ReactiveElasticsearchTemplate.sort(query, entity).forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).sort(arg_0));
        if (query.getMinScore() > 0.0f) {
            searchSourceBuilder.minScore(query.getMinScore());
        }
        if (query.getIndicesOptions() != null) {
            request.indicesOptions(query.getIndicesOptions());
        }
        if (query.getPreference() != null) {
            request.preference(query.getPreference());
        }
        if (query.getSearchType() != null) {
            request.searchType(query.getSearchType());
        }
        if ((pageable = query.getPageable()).isPaged()) {
            long offset = pageable.getOffset();
            if (offset > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(String.format("Offset must not be more than %s", Integer.MAX_VALUE));
            }
            searchSourceBuilder.from((int)offset);
            searchSourceBuilder.size(pageable.getPageSize());
            request.source(searchSourceBuilder);
        } else {
            searchSourceBuilder.from(0);
            searchSourceBuilder.size(AbstractElasticsearchTemplate.INDEX_MAX_RESULT_WINDOW.intValue());
            request.source(searchSourceBuilder);
        }
        return request;
    }

    @Override
    public Mono<String> delete(Object entity, @Nullable String index, @Nullable String type) {
        EntityOperations.Entity<Object> elasticsearchEntity = this.operations.forEntity(entity);
        return Mono.defer(() -> this.doDeleteById(entity, this.converter.convertId(elasticsearchEntity.getId()), elasticsearchEntity.getPersistentEntity(), index, type));
    }

    @Override
    public Mono<String> deleteById(String id, Class<?> entityType, @Nullable String index, @Nullable String type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        return this.doDeleteById(null, id, this.getPersistentEntity(entityType), index, type);
    }

    private Mono<String> doDeleteById(@Nullable Object source, String id, ElasticsearchPersistentEntity<?> entity, @Nullable String index, @Nullable String type) {
        return Mono.defer(() -> {
            EntityOperations.IndexCoordinates indexCoordinates = this.operations.determineIndex(entity, index, type);
            return this.doDelete(this.prepareDeleteRequest(source, new DeleteRequest(indexCoordinates.getIndexName(), indexCoordinates.getTypeName(), id)));
        });
    }

    @Override
    public Mono<Long> deleteBy(Query query, Class<?> entityType, String index, String type) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        return this.doDeleteBy(query, this.getPersistentEntity(entityType), index, type).map(BulkByScrollResponse::getDeleted).publishNext();
    }

    private Flux<BulkByScrollResponse> doDeleteBy(Query query, ElasticsearchPersistentEntity<?> entity, @Nullable String index, @Nullable String type) {
        return Flux.defer(() -> {
            EntityOperations.IndexCoordinates indexCoordinates = this.operations.determineIndex(entity, index, type);
            DeleteByQueryRequest request = new DeleteByQueryRequest(ReactiveElasticsearchTemplate.indices(query, indexCoordinates::getIndexName));
            request.types(ReactiveElasticsearchTemplate.indexTypes(query, indexCoordinates::getTypeName));
            request.setQuery(this.mappedQuery(query, entity));
            return this.doDeleteBy(this.prepareDeleteByRequest(request));
        });
    }

    public void setRefreshPolicy(@Nullable WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
    }

    public void setIndicesOptions(@Nullable IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
    }

    @Override
    public ElasticsearchConverter getElasticsearchConverter() {
        return this.converter;
    }

    protected ReactiveElasticsearchClient getClient() {
        return this.client;
    }

    protected <R extends WriteRequest<R>> R prepareWriteRequest(R request) {
        if (this.refreshPolicy == null) {
            return request;
        }
        return (R)request.setRefreshPolicy(this.refreshPolicy);
    }

    protected IndexRequest prepareIndexRequest(Object source, IndexRequest request) {
        return this.prepareWriteRequest(request);
    }

    protected CountRequest prepareCountRequest(CountRequest request) {
        if (this.indicesOptions == null) {
            return request;
        }
        return request.indicesOptions(this.indicesOptions);
    }

    protected SearchRequest prepareSearchRequest(SearchRequest request) {
        if (this.indicesOptions == null) {
            return request;
        }
        return request.indicesOptions(this.indicesOptions);
    }

    protected DeleteRequest prepareDeleteRequest(@Nullable Object source, DeleteRequest request) {
        return this.prepareWriteRequest(request);
    }

    protected DeleteByQueryRequest prepareDeleteByRequest(DeleteByQueryRequest request) {
        if (this.refreshPolicy != null && !WriteRequest.RefreshPolicy.NONE.equals((Object)this.refreshPolicy)) {
            request = (DeleteByQueryRequest)request.setRefresh(true);
        }
        if (this.indicesOptions != null) {
            request = request.setIndicesOptions(this.indicesOptions);
        }
        return request;
    }

    protected Mono<IndexResponse> doIndex(IndexRequest request) {
        return Mono.from(this.execute(client -> client.index(request)));
    }

    protected Mono<GetResult> doFindById(GetRequest request) {
        return Mono.from(this.execute(client -> client.get(request))).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected Mono<Boolean> doExists(GetRequest request) {
        return Mono.from(this.execute(client -> client.exists(request))).onErrorReturn(NoSuchIndexException.class, (Object)false);
    }

    protected Flux<SearchHit> doFind(SearchRequest request) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug("Executing doFind: {}", (Object)request);
        }
        return Flux.from(this.execute(client -> client.search(request))).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected Mono<Long> doCount(CountRequest request) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug("Executing doCount: {}", (Object)request);
        }
        return Mono.from(this.execute(client -> client.count(request))).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected Flux<SearchHit> doScroll(SearchRequest request) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug("Executing doScroll: {}", (Object)request);
        }
        return Flux.from(this.execute(client -> client.scroll(request))).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected Mono<String> doDelete(DeleteRequest request) {
        return Mono.from(this.execute(client -> client.delete(request))).flatMap(it -> {
            if (HttpStatus.valueOf((int)it.status().getStatus()).equals((Object)HttpStatus.NOT_FOUND)) {
                return Mono.empty();
            }
            return Mono.just((Object)it.getId());
        }).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected Mono<BulkByScrollResponse> doDeleteBy(DeleteByQueryRequest request) {
        return Mono.from(this.execute(client -> client.deleteBy(request))).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    private static String[] indices(Query query, Supplier<String> index) {
        if (query.getIndices().isEmpty()) {
            return new String[]{index.get()};
        }
        return query.getIndices().toArray(new String[0]);
    }

    private static String[] indexTypes(Query query, Supplier<String> indexType) {
        if (query.getTypes().isEmpty()) {
            return new String[]{indexType.get()};
        }
        return query.getTypes().toArray(new String[0]);
    }

    private static List<FieldSortBuilder> sort(Query query, ElasticsearchPersistentEntity<?> entity) {
        if (query.getSort() == null || query.getSort().isUnsorted()) {
            return Collections.emptyList();
        }
        ArrayList<FieldSortBuilder> mappedSort = new ArrayList<FieldSortBuilder>();
        for (Sort.Order order : query.getSort()) {
            ElasticsearchPersistentProperty property = (ElasticsearchPersistentProperty)entity.getPersistentProperty(order.getProperty());
            String fieldName = property != null ? property.getFieldName() : order.getProperty();
            FieldSortBuilder sort = (FieldSortBuilder)SortBuilders.fieldSort((String)fieldName).order(order.getDirection().isDescending() ? SortOrder.DESC : SortOrder.ASC);
            if (order.getNullHandling() == Sort.NullHandling.NULLS_FIRST) {
                sort.missing((Object)"_first");
            } else if (order.getNullHandling() == Sort.NullHandling.NULLS_LAST) {
                sort.missing((Object)"_last");
            }
            mappedSort.add(sort);
        }
        return mappedSort;
    }

    private QueryBuilder mappedQuery(Query query, ElasticsearchPersistentEntity<?> entity) {
        QueryBuilder elasticsearchQuery = null;
        if (query instanceof CriteriaQuery) {
            elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(((CriteriaQuery)query).getCriteria());
        } else if (query instanceof StringQuery) {
            elasticsearchQuery = new WrapperQueryBuilder(((StringQuery)query).getSource());
        } else if (query instanceof NativeSearchQuery) {
            elasticsearchQuery = ((NativeSearchQuery)query).getQuery();
        } else {
            throw new IllegalArgumentException(String.format("Unknown query type '%s'.", query.getClass()));
        }
        return elasticsearchQuery != null ? elasticsearchQuery : QueryBuilders.matchAllQuery();
    }

    @Nullable
    private QueryBuilder mappedFilterQuery(Query query, ElasticsearchPersistentEntity<?> entity) {
        if (query instanceof SearchQuery) {
            return ((SearchQuery)query).getFilter();
        }
        return null;
    }

    @Nullable
    private ElasticsearchPersistentEntity<?> getPersistentEntity(@Nullable Class<?> type) {
        return type != null ? (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(type) : null;
    }

    private Throwable translateException(Throwable throwable) {
        RuntimeException exception = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable.getMessage(), throwable);
        DataAccessException potentiallyTranslatedException = this.exceptionTranslator.translateExceptionIfPossible(exception);
        return potentiallyTranslatedException != null ? potentiallyTranslatedException : throwable;
    }
}

