/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.data.elasticsearch.core.ScrolledPage;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;

abstract class StreamQueries {
    static <T> CloseableIterator<T> streamResults(final ScrolledPage<T> page, final Function<String, ScrolledPage<T>> continueScrollFunction, final Consumer<String> clearScrollConsumer) {
        Assert.notNull(page, (String)"page must not be null.");
        Assert.notNull((Object)page.getScrollId(), (String)"scrollId must not be null.");
        Assert.notNull(continueScrollFunction, (String)"continueScrollFunction must not be null.");
        Assert.notNull(clearScrollConsumer, (String)"clearScrollConsumer must not be null.");
        return new CloseableIterator<T>(){
            private volatile Iterator<T> scrollHits;
            private volatile String scrollId;
            private volatile boolean continueScroll;
            {
                this.scrollHits = page.iterator();
                this.scrollId = page.getScrollId();
                this.continueScroll = this.scrollHits.hasNext();
            }

            public void close() {
                try {
                    clearScrollConsumer.accept(this.scrollId);
                }
                finally {
                    this.scrollHits = null;
                    this.scrollId = null;
                }
            }

            public boolean hasNext() {
                if (!this.continueScroll) {
                    return false;
                }
                if (!this.scrollHits.hasNext()) {
                    ScrolledPage nextPage = (ScrolledPage)continueScrollFunction.apply(this.scrollId);
                    this.scrollHits = nextPage.iterator();
                    this.scrollId = nextPage.getScrollId();
                    this.continueScroll = this.scrollHits.hasNext();
                }
                return this.scrollHits.hasNext();
            }

            public T next() {
                if (this.hasNext()) {
                    return this.scrollHits.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private StreamQueries() {
    }
}

