/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortMode;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.core.CriteriaFilterProcessor;
import org.springframework.data.elasticsearch.core.CriteriaQueryProcessor;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilter;
import org.springframework.data.elasticsearch.core.query.GeoDistanceOrder;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.ScriptField;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class RequestFactory {
    static final Integer INDEX_MAX_RESULT_WINDOW = 10000;
    private final ElasticsearchConverter elasticsearchConverter;

    public RequestFactory(ElasticsearchConverter elasticsearchConverter) {
        this.elasticsearchConverter = elasticsearchConverter;
    }

    public IndicesAliasesRequest.AliasActions aliasAction(AliasQuery query, IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().alias(query.getAliasName()).index(index.getIndexName());
        if (query.getFilterBuilder() != null) {
            aliasAction.filter(query.getFilterBuilder());
        } else if (query.getFilter() != null) {
            aliasAction.filter(query.getFilter());
        }
        if (!StringUtils.isEmpty((Object)query.getRouting())) {
            aliasAction.routing(query.getRouting());
        }
        if (!StringUtils.isEmpty((Object)query.getSearchRouting())) {
            aliasAction.searchRouting(query.getSearchRouting());
        }
        if (!StringUtils.isEmpty((Object)query.getIndexRouting())) {
            aliasAction.indexRouting(query.getIndexRouting());
        }
        return aliasAction;
    }

    public BulkRequest bulkRequest(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        BulkRequest bulkRequest = new BulkRequest();
        if (bulkOptions.getTimeout() != null) {
            bulkRequest.timeout(bulkOptions.getTimeout());
        }
        if (bulkOptions.getRefreshPolicy() != null) {
            bulkRequest.setRefreshPolicy(bulkOptions.getRefreshPolicy());
        }
        if (bulkOptions.getWaitForActiveShards() != null) {
            bulkRequest.waitForActiveShards(bulkOptions.getWaitForActiveShards());
        }
        if (bulkOptions.getPipeline() != null) {
            bulkRequest.pipeline(bulkOptions.getPipeline());
        }
        if (bulkOptions.getRoutingId() != null) {
            bulkRequest.routing(bulkOptions.getRoutingId());
        }
        queries.forEach(query -> {
            if (query instanceof IndexQuery) {
                bulkRequest.add(this.indexRequest((IndexQuery)query, index));
            } else if (query instanceof UpdateQuery) {
                bulkRequest.add(this.updateRequest((UpdateQuery)query, index));
            }
        });
        return bulkRequest;
    }

    public BulkRequestBuilder bulkRequestBuilder(Client client, List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        BulkRequestBuilder bulkRequestBuilder = client.prepareBulk();
        if (bulkOptions.getTimeout() != null) {
            bulkRequestBuilder.setTimeout(bulkOptions.getTimeout());
        }
        if (bulkOptions.getRefreshPolicy() != null) {
            bulkRequestBuilder.setRefreshPolicy(bulkOptions.getRefreshPolicy());
        }
        if (bulkOptions.getWaitForActiveShards() != null) {
            bulkRequestBuilder.setWaitForActiveShards(bulkOptions.getWaitForActiveShards());
        }
        if (bulkOptions.getPipeline() != null) {
            bulkRequestBuilder.pipeline(bulkOptions.getPipeline());
        }
        if (bulkOptions.getRoutingId() != null) {
            bulkRequestBuilder.routing(bulkOptions.getRoutingId());
        }
        queries.forEach(query -> {
            if (query instanceof IndexQuery) {
                bulkRequestBuilder.add(this.indexRequestBuilder(client, (IndexQuery)query, index));
            } else if (query instanceof UpdateQuery) {
                bulkRequestBuilder.add(this.updateRequestBuilderFor(client, (UpdateQuery)query, index));
            }
        });
        return bulkRequestBuilder;
    }

    public CreateIndexRequest createIndexRequest(String indexName, @Nullable Document settings) {
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        if (settings != null) {
            request.settings((Map)settings);
        }
        return request;
    }

    public CreateIndexRequestBuilder createIndexRequestBuilder(Client client, String indexName, @Nullable Document settings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = client.admin().indices().prepareCreate(indexName);
        if (settings != null) {
            createIndexRequestBuilder.setSettings((Map)settings);
        }
        return createIndexRequestBuilder;
    }

    @Deprecated
    public DeleteByQueryRequest deleteByQueryRequest(DeleteQuery deleteQuery, IndexCoordinates index) {
        DeleteByQueryRequest deleteByQueryRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(index.getIndexNames()).setQuery(deleteQuery.getQuery()).setAbortOnVersionConflict(false)).setRefresh(true);
        if (deleteQuery.getPageSize() != null) {
            deleteByQueryRequest.setBatchSize(deleteQuery.getPageSize().intValue());
        }
        if (deleteQuery.getScrollTimeInMillis() != null) {
            deleteByQueryRequest.setScroll(TimeValue.timeValueMillis((long)deleteQuery.getScrollTimeInMillis()));
        }
        return deleteByQueryRequest;
    }

    public DeleteByQueryRequest deleteByQueryRequest(Query query, Class<?> clazz, IndexCoordinates index) {
        SearchRequest searchRequest = this.searchRequest(query, clazz, index);
        DeleteByQueryRequest deleteByQueryRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(index.getIndexNames()).setQuery(searchRequest.source().query()).setAbortOnVersionConflict(false)).setRefresh(true);
        if (query.isLimiting()) {
            deleteByQueryRequest.setBatchSize(query.getMaxResults().intValue());
        }
        if (query.hasScrollTime()) {
            deleteByQueryRequest.setScroll(TimeValue.timeValueMillis((long)query.getScrollTime().toMillis()));
        }
        return deleteByQueryRequest;
    }

    @Deprecated
    public DeleteByQueryRequestBuilder deleteByQueryRequestBuilder(Client client, DeleteQuery deleteQuery, IndexCoordinates index) {
        DeleteByQueryRequestBuilder requestBuilder = (DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((ElasticsearchClient)client, (ActionType)DeleteByQueryAction.INSTANCE).source(index.getIndexNames())).filter(deleteQuery.getQuery())).abortOnVersionConflict(false).refresh(true);
        SearchRequestBuilder source = requestBuilder.source();
        if (deleteQuery.getScrollTimeInMillis() != null) {
            source.setScroll(TimeValue.timeValueMillis((long)deleteQuery.getScrollTimeInMillis()));
        }
        return requestBuilder;
    }

    public DeleteByQueryRequestBuilder deleteByQueryRequestBuilder(Client client, Query query, Class<?> clazz, IndexCoordinates index) {
        SearchRequest searchRequest = this.searchRequest(query, clazz, index);
        DeleteByQueryRequestBuilder requestBuilder = (DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((ElasticsearchClient)client, (ActionType)DeleteByQueryAction.INSTANCE).source(index.getIndexNames())).filter(searchRequest.source().query())).abortOnVersionConflict(false).refresh(true);
        SearchRequestBuilder source = requestBuilder.source();
        if (query.isLimiting()) {
            source.setSize(query.getMaxResults().intValue());
        }
        if (query.hasScrollTime()) {
            source.setScroll(TimeValue.timeValueMillis((long)query.getScrollTime().toMillis()));
        }
        return requestBuilder;
    }

    public GetRequest getRequest(String id, IndexCoordinates index) {
        return new GetRequest(index.getIndexName(), id);
    }

    public GetRequestBuilder getRequestBuilder(Client client, String id, IndexCoordinates index) {
        return client.prepareGet(index.getIndexName(), null, id);
    }

    @Nullable
    public HighlightBuilder highlightBuilder(Query query) {
        NativeSearchQuery searchQuery;
        HighlightBuilder highlightBuilder = query.getHighlightQuery().map(HighlightQuery::getHighlightBuilder).orElse(null);
        if (highlightBuilder == null && query instanceof NativeSearchQuery && ((searchQuery = (NativeSearchQuery)query).getHighlightFields() != null || searchQuery.getHighlightBuilder() != null)) {
            highlightBuilder = searchQuery.getHighlightBuilder();
            if (highlightBuilder == null) {
                highlightBuilder = new HighlightBuilder();
            }
            if (searchQuery.getHighlightFields() != null) {
                for (HighlightBuilder.Field highlightField : searchQuery.getHighlightFields()) {
                    highlightBuilder.field(highlightField);
                }
            }
        }
        return highlightBuilder;
    }

    public IndexRequest indexRequest(IndexQuery query, IndexCoordinates index) {
        IndexRequest indexRequest;
        String indexName = index.getIndexName();
        if (query.getObject() != null) {
            String id = StringUtils.isEmpty((Object)query.getId()) ? this.getPersistentEntityId(query.getObject()) : query.getId();
            indexRequest = id != null ? new IndexRequest(indexName).id(id) : new IndexRequest(indexName);
            indexRequest.source(this.elasticsearchConverter.mapObject(query.getObject()).toJson(), Requests.INDEX_CONTENT_TYPE);
        } else if (query.getSource() != null) {
            indexRequest = new IndexRequest(indexName).id(query.getId()).source(query.getSource(), Requests.INDEX_CONTENT_TYPE);
        } else {
            throw new ElasticsearchException("object or source is null, failed to index the document [id: " + query.getId() + ']');
        }
        if (query.getVersion() != null) {
            indexRequest.version(query.getVersion().longValue());
            VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(query.getObject().getClass());
            indexRequest.versionType(versionType);
        }
        if (query.getSeqNo() != null) {
            indexRequest.setIfSeqNo(query.getSeqNo().longValue());
        }
        if (query.getPrimaryTerm() != null) {
            indexRequest.setIfPrimaryTerm(query.getPrimaryTerm().longValue());
        }
        return indexRequest;
    }

    public IndexRequestBuilder indexRequestBuilder(Client client, IndexQuery query, IndexCoordinates index) {
        IndexRequestBuilder indexRequestBuilder;
        String indexName = index.getIndexName();
        String type = "_doc";
        if (query.getObject() != null) {
            String id = StringUtils.isEmpty((Object)query.getId()) ? this.getPersistentEntityId(query.getObject()) : query.getId();
            indexRequestBuilder = id != null ? client.prepareIndex(indexName, type, id) : client.prepareIndex(indexName, type);
            indexRequestBuilder.setSource(this.elasticsearchConverter.mapObject(query.getObject()).toJson(), Requests.INDEX_CONTENT_TYPE);
        } else if (query.getSource() != null) {
            indexRequestBuilder = client.prepareIndex(indexName, type, query.getId()).setSource(query.getSource(), Requests.INDEX_CONTENT_TYPE);
        } else {
            throw new ElasticsearchException("object or source is null, failed to index the document [id: " + query.getId() + ']');
        }
        if (query.getVersion() != null) {
            indexRequestBuilder.setVersion(query.getVersion().longValue());
            VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(query.getObject().getClass());
            indexRequestBuilder.setVersionType(versionType);
        }
        if (query.getSeqNo() != null) {
            indexRequestBuilder.setIfSeqNo(query.getSeqNo().longValue());
        }
        if (query.getPrimaryTerm() != null) {
            indexRequestBuilder.setIfPrimaryTerm(query.getPrimaryTerm().longValue());
        }
        return indexRequestBuilder;
    }

    public MoreLikeThisQueryBuilder moreLikeThisQueryBuilder(MoreLikeThisQuery query, IndexCoordinates index) {
        MoreLikeThisQueryBuilder.Item item = new MoreLikeThisQueryBuilder.Item(index.getIndexName(), query.getId());
        String[] fields = null;
        if (query.getFields() != null) {
            fields = query.getFields().toArray(new String[0]);
        }
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = QueryBuilders.moreLikeThisQuery((String[])fields, null, (MoreLikeThisQueryBuilder.Item[])new MoreLikeThisQueryBuilder.Item[]{item});
        if (query.getMinTermFreq() != null) {
            moreLikeThisQueryBuilder.minTermFreq(query.getMinTermFreq().intValue());
        }
        if (query.getMaxQueryTerms() != null) {
            moreLikeThisQueryBuilder.maxQueryTerms(query.getMaxQueryTerms().intValue());
        }
        if (!CollectionUtils.isEmpty(query.getStopWords())) {
            moreLikeThisQueryBuilder.stopWords(query.getStopWords());
        }
        if (query.getMinDocFreq() != null) {
            moreLikeThisQueryBuilder.minDocFreq(query.getMinDocFreq().intValue());
        }
        if (query.getMaxDocFreq() != null) {
            moreLikeThisQueryBuilder.maxDocFreq(query.getMaxDocFreq().intValue());
        }
        if (query.getMinWordLen() != null) {
            moreLikeThisQueryBuilder.minWordLength(query.getMinWordLen().intValue());
        }
        if (query.getMaxWordLen() != null) {
            moreLikeThisQueryBuilder.maxWordLength(query.getMaxWordLen().intValue());
        }
        if (query.getBoostTerms() != null) {
            moreLikeThisQueryBuilder.boostTerms(query.getBoostTerms().floatValue());
        }
        return moreLikeThisQueryBuilder;
    }

    public SearchRequest searchRequest(Query query, @Nullable Class<?> clazz, IndexCoordinates index) {
        SearchRequest searchRequest = this.prepareSearchRequest(query, clazz, index);
        QueryBuilder elasticsearchQuery = this.getQuery(query);
        QueryBuilder elasticsearchFilter = this.getFilter(query);
        if (elasticsearchQuery != null) {
            searchRequest.source().query(elasticsearchQuery);
        } else {
            searchRequest.source().query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (elasticsearchFilter != null) {
            searchRequest.source().postFilter(elasticsearchFilter);
        }
        return searchRequest;
    }

    public SearchRequestBuilder searchRequestBuilder(Client client, Query query, @Nullable Class<?> clazz, IndexCoordinates index) {
        SearchRequestBuilder searchRequestBuilder = this.prepareSearchRequestBuilder(query, client, clazz, index);
        QueryBuilder elasticsearchQuery = this.getQuery(query);
        QueryBuilder elasticsearchFilter = this.getFilter(query);
        if (elasticsearchQuery != null) {
            searchRequestBuilder.setQuery(elasticsearchQuery);
        } else {
            searchRequestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (elasticsearchFilter != null) {
            searchRequestBuilder.setPostFilter(elasticsearchFilter);
        }
        return searchRequestBuilder;
    }

    public UpdateRequest updateRequest(UpdateQuery query, IndexCoordinates index) {
        UpdateRequest updateRequest = new UpdateRequest(index.getIndexName(), query.getId());
        if (query.getScript() != null) {
            Map<String, Object> params = query.getParams();
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            Script script = new Script(ScriptType.INLINE, query.getLang(), query.getScript(), params);
            updateRequest.script(script);
        }
        if (query.getDocument() != null) {
            updateRequest.doc((Map)query.getDocument());
        }
        if (query.getUpsert() != null) {
            updateRequest.upsert((Map)query.getUpsert());
        }
        if (query.getRouting() != null) {
            updateRequest.routing(query.getRouting());
        }
        if (query.getScriptedUpsert() != null) {
            updateRequest.scriptedUpsert(query.getScriptedUpsert().booleanValue());
        }
        if (query.getDocAsUpsert() != null) {
            updateRequest.docAsUpsert(query.getDocAsUpsert().booleanValue());
        }
        if (query.getFetchSource() != null) {
            updateRequest.fetchSource(query.getFetchSource().booleanValue());
        }
        if (query.getFetchSourceIncludes() != null || query.getFetchSourceExcludes() != null) {
            List<Object> includes = query.getFetchSourceIncludes() != null ? query.getFetchSourceIncludes() : Collections.emptyList();
            List<Object> excludes = query.getFetchSourceExcludes() != null ? query.getFetchSourceExcludes() : Collections.emptyList();
            updateRequest.fetchSource(includes.toArray(new String[0]), excludes.toArray(new String[0]));
        }
        if (query.getIfSeqNo() != null) {
            updateRequest.setIfSeqNo((long)query.getIfSeqNo().intValue());
        }
        if (query.getIfPrimaryTerm() != null) {
            updateRequest.setIfPrimaryTerm((long)query.getIfPrimaryTerm().intValue());
        }
        if (query.getRefresh() != null) {
            updateRequest.setRefreshPolicy(query.getRefresh().name().toLowerCase());
        }
        if (query.getRetryOnConflict() != null) {
            updateRequest.retryOnConflict(query.getRetryOnConflict().intValue());
        }
        if (query.getTimeout() != null) {
            updateRequest.timeout(query.getTimeout());
        }
        if (query.getWaitForActiveShards() != null) {
            updateRequest.waitForActiveShards(ActiveShardCount.parseString((String)query.getWaitForActiveShards()));
        }
        return updateRequest;
    }

    public UpdateRequestBuilder updateRequestBuilderFor(Client client, UpdateQuery query, IndexCoordinates index) {
        UpdateRequestBuilder updateRequestBuilder = client.prepareUpdate(index.getIndexName(), "_doc", query.getId());
        if (query.getScript() != null) {
            Map<String, Object> params = query.getParams();
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            Script script = new Script(ScriptType.INLINE, query.getLang(), query.getScript(), params);
            updateRequestBuilder.setScript(script);
        }
        if (query.getDocument() != null) {
            updateRequestBuilder.setDoc((Map)query.getDocument());
        }
        if (query.getUpsert() != null) {
            updateRequestBuilder.setUpsert((Map)query.getUpsert());
        }
        if (query.getRouting() != null) {
            updateRequestBuilder.setRouting(query.getRouting());
        }
        if (query.getScriptedUpsert() != null) {
            updateRequestBuilder.setScriptedUpsert(query.getScriptedUpsert().booleanValue());
        }
        if (query.getDocAsUpsert() != null) {
            updateRequestBuilder.setDocAsUpsert(query.getDocAsUpsert().booleanValue());
        }
        if (query.getFetchSource() != null) {
            updateRequestBuilder.setFetchSource(query.getFetchSource().booleanValue());
        }
        if (query.getFetchSourceIncludes() != null || query.getFetchSourceExcludes() != null) {
            List<Object> includes = query.getFetchSourceIncludes() != null ? query.getFetchSourceIncludes() : Collections.emptyList();
            List<Object> excludes = query.getFetchSourceExcludes() != null ? query.getFetchSourceExcludes() : Collections.emptyList();
            updateRequestBuilder.setFetchSource(includes.toArray(new String[0]), excludes.toArray(new String[0]));
        }
        if (query.getIfSeqNo() != null) {
            updateRequestBuilder.setIfSeqNo((long)query.getIfSeqNo().intValue());
        }
        if (query.getIfPrimaryTerm() != null) {
            updateRequestBuilder.setIfPrimaryTerm((long)query.getIfPrimaryTerm().intValue());
        }
        if (query.getRefresh() != null) {
            updateRequestBuilder.setRefreshPolicy(query.getRefresh().name().toLowerCase());
        }
        if (query.getRetryOnConflict() != null) {
            updateRequestBuilder.setRetryOnConflict(query.getRetryOnConflict().intValue());
        }
        if (query.getTimeout() != null) {
            updateRequestBuilder.setTimeout(query.getTimeout());
        }
        if (query.getWaitForActiveShards() != null) {
            updateRequestBuilder.setWaitForActiveShards(ActiveShardCount.parseString((String)query.getWaitForActiveShards()));
        }
        return updateRequestBuilder;
    }

    private SearchRequest prepareSearchRequest(Query query, @Nullable Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)index.getIndexNames(), (String)"No index defined for Query");
        Assert.notEmpty((Object[])index.getIndexNames(), (String)"No index defined for Query");
        SearchRequest request = new SearchRequest(index.getIndexNames());
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.version(Boolean.valueOf(true));
        sourceBuilder.trackScores(query.getTrackScores());
        if (this.hasSeqNoPrimaryTermProperty(clazz)) {
            sourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true));
        }
        if (query.getSourceFilter() != null) {
            SourceFilter sourceFilter = query.getSourceFilter();
            sourceBuilder.fetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        if (query.getPageable().isPaged()) {
            sourceBuilder.from((int)query.getPageable().getOffset());
            sourceBuilder.size(query.getPageable().getPageSize());
        } else {
            sourceBuilder.from(0);
            sourceBuilder.size(INDEX_MAX_RESULT_WINDOW.intValue());
        }
        if (!query.getFields().isEmpty()) {
            sourceBuilder.fetchSource(query.getFields().toArray(new String[0]), null);
        }
        if (query.getIndicesOptions() != null) {
            request.indicesOptions(query.getIndicesOptions());
        }
        if (query.isLimiting()) {
            sourceBuilder.size(query.getMaxResults().intValue());
        }
        if (query.getMinScore() > 0.0f) {
            sourceBuilder.minScore(query.getMinScore());
        }
        if (query.getPreference() != null) {
            request.preference(query.getPreference());
        }
        if (query.getSearchType() != null) {
            request.searchType(query.getSearchType());
        }
        this.prepareSort(query, sourceBuilder, this.getPersistentEntity(clazz));
        HighlightBuilder highlightBuilder = this.highlightBuilder(query);
        if (highlightBuilder != null) {
            sourceBuilder.highlighter(highlightBuilder);
        }
        if (query instanceof NativeSearchQuery) {
            this.prepareNativeSearch((NativeSearchQuery)query, sourceBuilder);
        }
        if (query.getTrackTotalHits()) {
            sourceBuilder.trackTotalHits(query.getTrackTotalHits());
        }
        if (StringUtils.hasLength((String)query.getRoute())) {
            request.routing(query.getRoute());
        }
        request.source(sourceBuilder);
        return request;
    }

    private boolean hasSeqNoPrimaryTermProperty(@Nullable Class<?> entityClass) {
        if (entityClass == null) {
            return false;
        }
        if (!this.elasticsearchConverter.getMappingContext().hasPersistentEntityFor(entityClass)) {
            return false;
        }
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(entityClass);
        return entity.hasSeqNoPrimaryTermProperty();
    }

    public PutMappingRequest putMappingRequest(IndexCoordinates index, Document mapping) {
        PutMappingRequest request = new PutMappingRequest(new String[]{index.getIndexName()});
        request.source((Map)mapping);
        return request;
    }

    public PutMappingRequestBuilder putMappingRequestBuilder(Client client, IndexCoordinates index, Document mapping) {
        PutMappingRequestBuilder requestBuilder = client.admin().indices().preparePutMapping(new String[]{index.getIndexName()}).setType("_doc");
        requestBuilder.setSource((Map)mapping);
        return requestBuilder;
    }

    public MultiGetRequest multiGetRequest(Query query, IndexCoordinates index) {
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        this.getMultiRequestItems(query, index).forEach(arg_0 -> ((MultiGetRequest)multiGetRequest).add(arg_0));
        return multiGetRequest;
    }

    public MultiGetRequestBuilder multiGetRequestBuilder(Client client, Query searchQuery, IndexCoordinates index) {
        MultiGetRequestBuilder multiGetRequestBuilder = client.prepareMultiGet();
        this.getMultiRequestItems(searchQuery, index).forEach(arg_0 -> ((MultiGetRequestBuilder)multiGetRequestBuilder).add(arg_0));
        return multiGetRequestBuilder;
    }

    private List<MultiGetRequest.Item> getMultiRequestItems(Query searchQuery, IndexCoordinates index) {
        ArrayList<MultiGetRequest.Item> items = new ArrayList<MultiGetRequest.Item>();
        if (!CollectionUtils.isEmpty(searchQuery.getFields())) {
            searchQuery.addSourceFilter(new FetchSourceFilter(this.toArray(searchQuery.getFields()), null));
        }
        for (String id : searchQuery.getIds()) {
            MultiGetRequest.Item item = new MultiGetRequest.Item(index.getIndexName(), id);
            if (searchQuery.getRoute() != null) {
                item = item.routing(searchQuery.getRoute());
            }
            items.add(item);
        }
        return items;
    }

    private void prepareNativeSearch(NativeSearchQuery query, SearchSourceBuilder sourceBuilder) {
        if (!query.getScriptFields().isEmpty()) {
            for (ScriptField scriptedField : query.getScriptFields()) {
                sourceBuilder.scriptField(scriptedField.fieldName(), scriptedField.script());
            }
        }
        if (query.getCollapseBuilder() != null) {
            sourceBuilder.collapse(query.getCollapseBuilder());
        }
        if (!CollectionUtils.isEmpty(query.getIndicesBoost())) {
            for (IndexBoost indexBoost : query.getIndicesBoost()) {
                sourceBuilder.indexBoost(indexBoost.getIndexName(), indexBoost.getBoost());
            }
        }
        if (!CollectionUtils.isEmpty(query.getAggregations())) {
            for (AbstractAggregationBuilder aggregationBuilder : query.getAggregations()) {
                sourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
            }
        }
    }

    private void prepareNativeSearch(SearchRequestBuilder searchRequestBuilder, NativeSearchQuery nativeSearchQuery) {
        if (!CollectionUtils.isEmpty(nativeSearchQuery.getScriptFields())) {
            for (ScriptField scriptedField : nativeSearchQuery.getScriptFields()) {
                searchRequestBuilder.addScriptField(scriptedField.fieldName(), scriptedField.script());
            }
        }
        if (nativeSearchQuery.getCollapseBuilder() != null) {
            searchRequestBuilder.setCollapse(nativeSearchQuery.getCollapseBuilder());
        }
        if (!CollectionUtils.isEmpty(nativeSearchQuery.getIndicesBoost())) {
            for (IndexBoost indexBoost : nativeSearchQuery.getIndicesBoost()) {
                searchRequestBuilder.addIndexBoost(indexBoost.getIndexName(), indexBoost.getBoost());
            }
        }
        if (!CollectionUtils.isEmpty(nativeSearchQuery.getAggregations())) {
            for (AbstractAggregationBuilder aggregationBuilder : nativeSearchQuery.getAggregations()) {
                searchRequestBuilder.addAggregation((AggregationBuilder)aggregationBuilder);
            }
        }
    }

    private SearchRequestBuilder prepareSearchRequestBuilder(Query query, Client client, @Nullable Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)index.getIndexNames(), (String)"No index defined for Query");
        Assert.notEmpty((Object[])index.getIndexNames(), (String)"No index defined for Query");
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(index.getIndexNames()).setSearchType(query.getSearchType()).setVersion(true).setTrackScores(query.getTrackScores());
        if (this.hasSeqNoPrimaryTermProperty(clazz)) {
            searchRequestBuilder.seqNoAndPrimaryTerm(true);
        }
        if (query.getSourceFilter() != null) {
            SourceFilter sourceFilter = query.getSourceFilter();
            searchRequestBuilder.setFetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        if (query.getPageable().isPaged()) {
            searchRequestBuilder.setFrom((int)query.getPageable().getOffset());
            searchRequestBuilder.setSize(query.getPageable().getPageSize());
        } else {
            searchRequestBuilder.setFrom(0);
            searchRequestBuilder.setSize(INDEX_MAX_RESULT_WINDOW.intValue());
        }
        if (!query.getFields().isEmpty()) {
            searchRequestBuilder.setFetchSource(query.getFields().toArray(new String[0]), null);
        }
        if (query.getIndicesOptions() != null) {
            searchRequestBuilder.setIndicesOptions(query.getIndicesOptions());
        }
        if (query.isLimiting()) {
            searchRequestBuilder.setSize(query.getMaxResults().intValue());
        }
        if (query.getMinScore() > 0.0f) {
            searchRequestBuilder.setMinScore(query.getMinScore());
        }
        if (query.getPreference() != null) {
            searchRequestBuilder.setPreference(query.getPreference());
        }
        this.prepareSort(query, searchRequestBuilder, this.getPersistentEntity(clazz));
        HighlightBuilder highlightBuilder = this.highlightBuilder(query);
        if (highlightBuilder != null) {
            searchRequestBuilder.highlighter(highlightBuilder);
        }
        if (query instanceof NativeSearchQuery) {
            this.prepareNativeSearch(searchRequestBuilder, (NativeSearchQuery)query);
        }
        if (query.getTrackTotalHits()) {
            searchRequestBuilder.setTrackTotalHits(query.getTrackTotalHits());
        }
        if (StringUtils.hasLength((String)query.getRoute())) {
            searchRequestBuilder.setRouting(query.getRoute());
        }
        return searchRequestBuilder;
    }

    private void prepareSort(Query query, SearchSourceBuilder sourceBuilder, @Nullable ElasticsearchPersistentEntity<?> entity) {
        NativeSearchQuery nativeSearchQuery;
        List<SortBuilder> sorts;
        if (query.getSort() != null) {
            query.getSort().forEach(order -> sourceBuilder.sort(this.getSortBuilder((Sort.Order)order, entity)));
        }
        if (query instanceof NativeSearchQuery && (sorts = (nativeSearchQuery = (NativeSearchQuery)query).getElasticsearchSorts()) != null) {
            sorts.forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).sort(arg_0));
        }
    }

    private void prepareSort(Query query, SearchRequestBuilder searchRequestBuilder, @Nullable ElasticsearchPersistentEntity<?> entity) {
        NativeSearchQuery nativeSearchQuery;
        List<SortBuilder> sorts;
        if (query.getSort() != null) {
            query.getSort().forEach(order -> searchRequestBuilder.addSort(this.getSortBuilder((Sort.Order)order, entity)));
        }
        if (query instanceof NativeSearchQuery && (sorts = (nativeSearchQuery = (NativeSearchQuery)query).getElasticsearchSorts()) != null) {
            sorts.forEach(arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).addSort(arg_0));
        }
    }

    private SortBuilder<?> getSortBuilder(Sort.Order order, @Nullable ElasticsearchPersistentEntity<?> entity) {
        String fieldName;
        SortOrder sortOrder;
        SortOrder sortOrder2 = sortOrder = order.getDirection().isDescending() ? SortOrder.DESC : SortOrder.ASC;
        if ("_score".equals(order.getProperty())) {
            return SortBuilders.scoreSort().order(sortOrder);
        }
        ElasticsearchPersistentProperty property = entity != null ? (ElasticsearchPersistentProperty)entity.getPersistentProperty(order.getProperty()) : null;
        String string = fieldName = property != null ? property.getFieldName() : order.getProperty();
        if (order instanceof GeoDistanceOrder) {
            GeoDistanceOrder geoDistanceOrder = (GeoDistanceOrder)order;
            GeoDistanceSortBuilder sort = SortBuilders.geoDistanceSort((String)fieldName, (double)geoDistanceOrder.getGeoPoint().getLat(), (double)geoDistanceOrder.getGeoPoint().getLon());
            sort.geoDistance(GeoDistance.fromString((String)geoDistanceOrder.getDistanceType().name()));
            sort.ignoreUnmapped(geoDistanceOrder.getIgnoreUnmapped().booleanValue());
            sort.sortMode(SortMode.fromString((String)geoDistanceOrder.getMode().name()));
            sort.unit(DistanceUnit.fromString((String)geoDistanceOrder.getUnit()));
            return sort;
        }
        FieldSortBuilder sort = (FieldSortBuilder)SortBuilders.fieldSort((String)fieldName).order(sortOrder);
        if (order.getNullHandling() == Sort.NullHandling.NULLS_FIRST) {
            sort.missing((Object)"_first");
        } else if (order.getNullHandling() == Sort.NullHandling.NULLS_LAST) {
            sort.missing((Object)"_last");
        }
        return sort;
    }

    private QueryBuilder getQuery(Query query) {
        QueryBuilder elasticsearchQuery;
        if (query instanceof NativeSearchQuery) {
            NativeSearchQuery searchQuery = (NativeSearchQuery)query;
            elasticsearchQuery = searchQuery.getQuery();
        } else if (query instanceof CriteriaQuery) {
            CriteriaQuery criteriaQuery = (CriteriaQuery)query;
            elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        } else if (query instanceof StringQuery) {
            StringQuery stringQuery = (StringQuery)query;
            elasticsearchQuery = QueryBuilders.wrapperQuery((String)stringQuery.getSource());
        } else {
            throw new IllegalArgumentException("unhandled Query implementation " + query.getClass().getName());
        }
        return elasticsearchQuery;
    }

    public IndicesAliasesRequest indicesAddAliasesRequest(AliasQuery query, IndexCoordinates index) {
        IndicesAliasesRequest.AliasActions aliasAction = this.aliasAction(query, index);
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        request.addAliasAction(aliasAction);
        return request;
    }

    public IndicesAliasesRequest indicesRemoveAliasesRequest(AliasQuery query, IndexCoordinates index) {
        IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.remove().index(index.getIndexName()).alias(query.getAliasName());
        return Requests.indexAliasesRequest().addAliasAction(aliasAction);
    }

    private QueryBuilder getFilter(Query query) {
        QueryBuilder elasticsearchFilter;
        if (query instanceof NativeSearchQuery) {
            NativeSearchQuery searchQuery = (NativeSearchQuery)query;
            elasticsearchFilter = searchQuery.getFilter();
        } else if (query instanceof CriteriaQuery) {
            CriteriaQuery criteriaQuery = (CriteriaQuery)query;
            elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        } else if (query instanceof StringQuery) {
            elasticsearchFilter = null;
        } else {
            throw new IllegalArgumentException("unhandled Query implementation " + query.getClass().getName());
        }
        return elasticsearchFilter;
    }

    @Nullable
    private ElasticsearchPersistentEntity<?> getPersistentEntity(@Nullable Class<?> clazz) {
        return clazz != null ? (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(clazz) : null;
    }

    @Nullable
    private String getPersistentEntityId(Object entity) {
        Object identifier = ((ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(entity.getClass())).getIdentifierAccessor(entity).getIdentifier();
        if (identifier != null) {
            return identifier.toString();
        }
        return null;
    }

    private VersionType retrieveVersionTypeFromPersistentEntity(Class<?> clazz) {
        if (clazz != null) {
            return ((ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz)).getVersionType();
        }
        return VersionType.EXTERNAL;
    }

    private String[] toArray(List<String> values) {
        String[] valuesAsArray = new String[values.size()];
        return values.toArray(valuesAsArray);
    }
}

