/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.stream.Stream;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.repository.core.support.DefaultRepositoryMetadata;

public class ElasticsearchRepositoryMetadata
extends DefaultRepositoryMetadata {
    public ElasticsearchRepositoryMetadata(Class<?> repositoryInterface) {
        super(repositoryInterface);
    }

    public Class<?> getReturnedDomainClass(Method method) {
        Class returnedDomainClass = super.getReturnedDomainClass(method);
        if (SearchHit.class.isAssignableFrom(returnedDomainClass)) {
            try {
                ParameterizedType collectionTypeArgument;
                ParameterizedType methodGenericReturnType = (ParameterizedType)method.getGenericReturnType();
                if (this.isAllowedGenericType(methodGenericReturnType) && SearchHit.class.isAssignableFrom((Class)(collectionTypeArgument = (ParameterizedType)methodGenericReturnType.getActualTypeArguments()[0]).getRawType())) {
                    returnedDomainClass = (Class)collectionTypeArgument.getActualTypeArguments()[0];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return returnedDomainClass;
    }

    protected boolean isAllowedGenericType(ParameterizedType methodGenericReturnType) {
        return Collection.class.isAssignableFrom((Class)methodGenericReturnType.getRawType()) || Stream.class.isAssignableFrom((Class)methodGenericReturnType.getRawType());
    }
}

