/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;

public class GeoDistanceOrder
extends Sort.Order {
    private static final DistanceType DEFAULT_DISTANCE_TYPE = DistanceType.arc;
    private static final Mode DEFAULT_MODE = Mode.min;
    private static final String DEFAULT_UNIT = "m";
    private static final Boolean DEFAULT_IGNORE_UNMAPPED = false;
    private final GeoPoint geoPoint;
    private final DistanceType distanceType;
    private final Mode mode;
    private final String unit;
    private final Boolean ignoreUnmapped;

    public GeoDistanceOrder(String property, GeoPoint geoPoint) {
        this(property, geoPoint, Sort.Direction.ASC, DEFAULT_DISTANCE_TYPE, DEFAULT_MODE, DEFAULT_UNIT, DEFAULT_IGNORE_UNMAPPED);
    }

    private GeoDistanceOrder(String property, GeoPoint geoPoint, Sort.Direction direction, DistanceType distanceType, Mode mode, String unit, Boolean ignoreUnmapped) {
        super(direction, property);
        this.geoPoint = geoPoint;
        this.distanceType = distanceType;
        this.mode = mode;
        this.unit = unit;
        this.ignoreUnmapped = ignoreUnmapped;
    }

    public GeoPoint getGeoPoint() {
        return this.geoPoint;
    }

    public DistanceType getDistanceType() {
        return this.distanceType;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getUnit() {
        return this.unit;
    }

    public Boolean getIgnoreUnmapped() {
        return this.ignoreUnmapped;
    }

    public GeoDistanceOrder withProperty(String property) {
        return new GeoDistanceOrder(property, this.getGeoPoint(), this.getDirection(), this.getDistanceType(), this.getMode(), this.getUnit(), this.getIgnoreUnmapped());
    }

    public GeoDistanceOrder with(Sort.Direction direction) {
        return new GeoDistanceOrder(this.getProperty(), this.getGeoPoint(), direction, this.getDistanceType(), this.getMode(), this.getUnit(), this.getIgnoreUnmapped());
    }

    public GeoDistanceOrder with(Sort.NullHandling nullHandling) {
        throw new UnsupportedOperationException("null handling is not supported for _geo_distance sorts");
    }

    public GeoDistanceOrder with(DistanceType distanceType) {
        return new GeoDistanceOrder(this.getProperty(), this.getGeoPoint(), this.getDirection(), distanceType, this.getMode(), this.getUnit(), this.getIgnoreUnmapped());
    }

    public GeoDistanceOrder with(Mode mode) {
        return new GeoDistanceOrder(this.getProperty(), this.getGeoPoint(), this.getDirection(), this.getDistanceType(), mode, this.getUnit(), this.getIgnoreUnmapped());
    }

    public GeoDistanceOrder withUnit(String unit) {
        return new GeoDistanceOrder(this.getProperty(), this.getGeoPoint(), this.getDirection(), this.getDistanceType(), this.getMode(), unit, this.getIgnoreUnmapped());
    }

    public GeoDistanceOrder withIgnoreUnmapped(Boolean ignoreUnmapped) {
        return new GeoDistanceOrder(this.getProperty(), this.getGeoPoint(), this.getDirection(), this.getDistanceType(), this.getMode(), this.getUnit(), ignoreUnmapped);
    }

    public String toString() {
        return "GeoDistanceOrder{geoPoint=" + this.geoPoint + ", distanceType=" + (Object)((Object)this.distanceType) + ", mode=" + (Object)((Object)this.mode) + ", unit='" + this.unit + '\'' + ", ignoreUnmapped=" + this.ignoreUnmapped + "} " + super.toString();
    }

    public static enum Mode {
        min,
        max,
        median,
        avg;

    }

    public static enum DistanceType {
        arc,
        plane;

    }
}

