/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class AbstractQuery
implements Query {
    protected Pageable pageable = DEFAULT_PAGE;
    @Nullable
    protected Sort sort;
    protected List<String> fields = new ArrayList<String>();
    @Nullable
    protected SourceFilter sourceFilter;
    protected float minScore;
    @Nullable
    protected Collection<String> ids;
    @Nullable
    protected String route;
    protected SearchType searchType = SearchType.DFS_QUERY_THEN_FETCH;
    @Nullable
    protected IndicesOptions indicesOptions;
    protected boolean trackScores;
    @Nullable
    protected String preference;
    @Nullable
    protected Integer maxResults;
    @Nullable
    protected HighlightQuery highlightQuery;
    @Nullable
    private Boolean trackTotalHits;
    @Nullable
    private Integer trackTotalHitsUpTo;
    @Nullable
    private Duration scrollTime;

    AbstractQuery() {
    }

    @Override
    @Nullable
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    public final <T extends Query> T setPageable(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        this.pageable = pageable;
        return this.addSort(pageable.getSort());
    }

    @Override
    public void addFields(String ... fields) {
        Collections.addAll(this.fields, fields);
    }

    @Override
    public List<String> getFields() {
        return this.fields;
    }

    @Override
    public void addSourceFilter(SourceFilter sourceFilter) {
        this.sourceFilter = sourceFilter;
    }

    @Override
    @Nullable
    public SourceFilter getSourceFilter() {
        return this.sourceFilter;
    }

    @Override
    public final <T extends Query> T addSort(Sort sort) {
        if (sort == null) {
            return (T)this;
        }
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return (T)this;
    }

    @Override
    public float getMinScore() {
        return this.minScore;
    }

    public void setMinScore(float minScore) {
        this.minScore = minScore;
    }

    @Override
    @Nullable
    public Collection<String> getIds() {
        return this.ids;
    }

    public void setIds(Collection<String> ids) {
        this.ids = ids;
    }

    @Override
    @Nullable
    public String getRoute() {
        return this.route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
    }

    @Override
    public SearchType getSearchType() {
        return this.searchType;
    }

    @Override
    @Nullable
    public IndicesOptions getIndicesOptions() {
        return this.indicesOptions;
    }

    public void setIndicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
    }

    @Override
    public boolean getTrackScores() {
        return this.trackScores;
    }

    public void setTrackScores(boolean trackScores) {
        this.trackScores = trackScores;
    }

    @Override
    @Nullable
    public String getPreference() {
        return this.preference;
    }

    @Override
    public void setPreference(String preference) {
        this.preference = preference;
    }

    @Override
    public boolean isLimiting() {
        return this.maxResults != null;
    }

    @Override
    @Nullable
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    @Override
    public void setHighlightQuery(HighlightQuery highlightQuery) {
        this.highlightQuery = highlightQuery;
    }

    @Override
    public Optional<HighlightQuery> getHighlightQuery() {
        return Optional.ofNullable(this.highlightQuery);
    }

    @Override
    public void setTrackTotalHits(@Nullable Boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
    }

    @Override
    @Nullable
    public Boolean getTrackTotalHits() {
        return this.trackTotalHits;
    }

    @Override
    public void setTrackTotalHitsUpTo(@Nullable Integer trackTotalHitsUpTo) {
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
    }

    @Override
    @Nullable
    public Integer getTrackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    @Override
    @Nullable
    public Duration getScrollTime() {
        return this.scrollTime;
    }

    @Override
    public void setScrollTime(@Nullable Duration scrollTime) {
        this.scrollTime = scrollTime;
    }
}

