/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.lang.Nullable;

public interface Query {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final Pageable DEFAULT_PAGE = PageRequest.of((int)0, (int)10);

    public static Query findAll() {
        return new StringQuery(QueryBuilders.matchAllQuery().toString());
    }

    public <T extends Query> T setPageable(Pageable var1);

    public Pageable getPageable();

    public <T extends Query> T addSort(Sort var1);

    @Nullable
    public Sort getSort();

    public void addFields(String ... var1);

    public List<String> getFields();

    public void addSourceFilter(SourceFilter var1);

    @Nullable
    public SourceFilter getSourceFilter();

    public float getMinScore();

    public boolean getTrackScores();

    @Nullable
    public Collection<String> getIds();

    @Nullable
    public String getRoute();

    public SearchType getSearchType();

    @Nullable
    public IndicesOptions getIndicesOptions();

    @Nullable
    public String getPreference();

    public void setPreference(String var1);

    default public boolean isLimiting() {
        return false;
    }

    @Nullable
    default public Integer getMaxResults() {
        return null;
    }

    public void setHighlightQuery(HighlightQuery var1);

    default public Optional<HighlightQuery> getHighlightQuery() {
        return Optional.empty();
    }

    public void setTrackTotalHits(@Nullable Boolean var1);

    @Nullable
    public Boolean getTrackTotalHits();

    public void setTrackTotalHitsUpTo(@Nullable Integer var1);

    @Nullable
    public Integer getTrackTotalHitsUpTo();

    @Nullable
    public Duration getScrollTime();

    public void setScrollTime(@Nullable Duration var1);

    default public boolean hasScrollTime() {
        return this.getScrollTime() != null;
    }
}

