/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.springframework.data.elasticsearch.core.document.DocumentAdapters;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SearchDocumentResponse {
    private final long totalHits;
    private final String totalHitsRelation;
    private final float maxScore;
    private final String scrollId;
    private final List<SearchDocument> searchDocuments;
    private final Aggregations aggregations;

    private SearchDocumentResponse(long totalHits, String totalHitsRelation, float maxScore, String scrollId, List<SearchDocument> searchDocuments, Aggregations aggregations) {
        this.totalHits = totalHits;
        this.totalHitsRelation = totalHitsRelation;
        this.maxScore = maxScore;
        this.scrollId = scrollId;
        this.searchDocuments = searchDocuments;
        this.aggregations = aggregations;
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public String getTotalHitsRelation() {
        return this.totalHitsRelation;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public List<SearchDocument> getSearchDocuments() {
        return this.searchDocuments;
    }

    public Aggregations getAggregations() {
        return this.aggregations;
    }

    public static SearchDocumentResponse from(SearchResponse searchResponse) {
        Assert.notNull((Object)searchResponse, (String)"searchResponse must not be null");
        Aggregations aggregations = searchResponse.getAggregations();
        String scrollId = searchResponse.getScrollId();
        SearchHits searchHits = searchResponse.getHits();
        SearchDocumentResponse searchDocumentResponse = SearchDocumentResponse.from(searchHits, scrollId, aggregations);
        return searchDocumentResponse;
    }

    public static SearchDocumentResponse from(SearchHits searchHits, @Nullable String scrollId, @Nullable Aggregations aggregations) {
        String totalHitsRelation;
        long totalHits;
        TotalHits responseTotalHits = searchHits.getTotalHits();
        if (responseTotalHits != null) {
            totalHits = responseTotalHits.value;
            totalHitsRelation = responseTotalHits.relation.name();
        } else {
            totalHits = searchHits.getHits().length;
            totalHitsRelation = "OFF";
        }
        float maxScore = searchHits.getMaxScore();
        ArrayList<SearchDocument> searchDocuments = new ArrayList<SearchDocument>();
        for (SearchHit searchHit : searchHits) {
            if (searchHit == null) continue;
            searchDocuments.add(DocumentAdapters.from(searchHit));
        }
        return new SearchDocumentResponse(totalHits, totalHitsRelation, maxScore, scrollId, searchDocuments, aggregations);
    }
}

