/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequestBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.rescore.QueryRescoreMode;
import org.elasticsearch.search.rescore.QueryRescorerBuilder;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortMode;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.CriteriaFilterProcessor;
import org.springframework.data.elasticsearch.core.CriteriaQueryProcessor;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.ScriptType;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasAction;
import org.springframework.data.elasticsearch.core.index.AliasActionParameters;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilter;
import org.springframework.data.elasticsearch.core.query.GeoDistanceOrder;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.ScriptField;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class RequestFactory {
    static final Integer INDEX_MAX_RESULT_WINDOW = 10000;
    private final ElasticsearchConverter elasticsearchConverter;

    public RequestFactory(ElasticsearchConverter elasticsearchConverter) {
        this.elasticsearchConverter = elasticsearchConverter;
    }

    @Deprecated
    public IndicesAliasesRequest.AliasActions aliasAction(AliasQuery query, IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        String[] indexNames = index.getIndexNames();
        IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().alias(query.getAliasName()).indices(indexNames);
        if (query.getFilterBuilder() != null) {
            aliasAction.filter(query.getFilterBuilder());
        } else if (query.getFilter() != null) {
            aliasAction.filter(query.getFilter());
        }
        if (!StringUtils.isEmpty((Object)query.getRouting())) {
            aliasAction.routing(query.getRouting());
        }
        if (!StringUtils.isEmpty((Object)query.getSearchRouting())) {
            aliasAction.searchRouting(query.getSearchRouting());
        }
        if (!StringUtils.isEmpty((Object)query.getIndexRouting())) {
            aliasAction.indexRouting(query.getIndexRouting());
        }
        return aliasAction;
    }

    public GetAliasesRequest getAliasesRequest(IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return new GetAliasesRequest().indices(indexNames);
    }

    public GetAliasesRequest getAliasesRequest(@Nullable String[] aliasNames, @Nullable String[] indexNames) {
        GetAliasesRequest getAliasesRequest = new GetAliasesRequest(aliasNames);
        if (indexNames != null) {
            getAliasesRequest.indices(indexNames);
        }
        return getAliasesRequest;
    }

    @Deprecated
    public IndicesAliasesRequest indicesAddAliasesRequest(AliasQuery query, IndexCoordinates index) {
        IndicesAliasesRequest.AliasActions aliasAction = this.aliasAction(query, index);
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        request.addAliasAction(aliasAction);
        return request;
    }

    public IndicesAliasesRequest indicesAliasesRequest(AliasActions aliasActions) {
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        aliasActions.getActions().forEach(aliasAction -> {
            IndicesAliasesRequest.AliasActions aliasActionsES = null;
            if (aliasAction instanceof AliasAction.Add) {
                AliasAction.Add add = (AliasAction.Add)aliasAction;
                IndicesAliasesRequest.AliasActions addES = IndicesAliasesRequest.AliasActions.add();
                AliasActionParameters parameters = add.getParameters();
                addES.indices(parameters.getIndices());
                addES.aliases(parameters.getAliases());
                addES.routing(parameters.getRouting());
                addES.indexRouting(parameters.getIndexRouting());
                addES.searchRouting(parameters.getSearchRouting());
                addES.isHidden(parameters.getHidden());
                addES.writeIndex(parameters.getWriteIndex());
                Query filterQuery = parameters.getFilterQuery();
                if (filterQuery != null) {
                    this.elasticsearchConverter.updateQuery(filterQuery, parameters.getFilterQueryClass());
                    QueryBuilder queryBuilder = this.getFilter(filterQuery);
                    if (queryBuilder == null) {
                        queryBuilder = this.getQuery(filterQuery);
                    }
                    addES.filter(queryBuilder);
                }
                aliasActionsES = addES;
            } else if (aliasAction instanceof AliasAction.Remove) {
                AliasAction.Remove remove = (AliasAction.Remove)aliasAction;
                IndicesAliasesRequest.AliasActions removeES = IndicesAliasesRequest.AliasActions.remove();
                AliasActionParameters parameters = remove.getParameters();
                removeES.indices(parameters.getIndices());
                removeES.aliases(parameters.getAliases());
                aliasActionsES = removeES;
            } else if (aliasAction instanceof AliasAction.RemoveIndex) {
                AliasAction.RemoveIndex removeIndex = (AliasAction.RemoveIndex)aliasAction;
                IndicesAliasesRequest.AliasActions removeIndexES = IndicesAliasesRequest.AliasActions.removeIndex();
                AliasActionParameters parameters = removeIndex.getParameters();
                removeIndexES.indices(new String[]{parameters.getIndices()[0]});
                aliasActionsES = removeIndexES;
            }
            if (aliasActionsES != null) {
                request.addAliasAction(aliasActionsES);
            }
        });
        return request;
    }

    public IndicesAliasesRequestBuilder indicesAliasesRequestBuilder(Client client, AliasActions aliasActions) {
        IndicesAliasesRequestBuilder requestBuilder = client.admin().indices().prepareAliases();
        this.indicesAliasesRequest(aliasActions).getAliasActions().forEach(arg_0 -> ((IndicesAliasesRequestBuilder)requestBuilder).addAliasAction(arg_0));
        return requestBuilder;
    }

    @Deprecated
    public IndicesAliasesRequest indicesRemoveAliasesRequest(AliasQuery query, IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.remove().indices(indexNames).alias(query.getAliasName());
        return Requests.indexAliasesRequest().addAliasAction(aliasAction);
    }

    @Deprecated
    IndicesAliasesRequestBuilder indicesRemoveAliasesRequestBuilder(Client client, AliasQuery query, IndexCoordinates index) {
        String indexName = index.getIndexName();
        return client.admin().indices().prepareAliases().removeAlias(indexName, query.getAliasName());
    }

    public BulkRequest bulkRequest(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        BulkRequest bulkRequest = new BulkRequest();
        if (bulkOptions.getTimeout() != null) {
            bulkRequest.timeout(bulkOptions.getTimeout());
        }
        if (bulkOptions.getRefreshPolicy() != null) {
            bulkRequest.setRefreshPolicy(bulkOptions.getRefreshPolicy());
        }
        if (bulkOptions.getWaitForActiveShards() != null) {
            bulkRequest.waitForActiveShards(bulkOptions.getWaitForActiveShards());
        }
        if (bulkOptions.getPipeline() != null) {
            bulkRequest.pipeline(bulkOptions.getPipeline());
        }
        if (bulkOptions.getRoutingId() != null) {
            bulkRequest.routing(bulkOptions.getRoutingId());
        }
        queries.forEach(query -> {
            if (query instanceof IndexQuery) {
                bulkRequest.add(this.indexRequest((IndexQuery)query, index));
            } else if (query instanceof UpdateQuery) {
                bulkRequest.add(this.updateRequest((UpdateQuery)query, index));
            }
        });
        return bulkRequest;
    }

    public BulkRequestBuilder bulkRequestBuilder(Client client, List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        BulkRequestBuilder bulkRequestBuilder = client.prepareBulk();
        if (bulkOptions.getTimeout() != null) {
            bulkRequestBuilder.setTimeout(bulkOptions.getTimeout());
        }
        if (bulkOptions.getRefreshPolicy() != null) {
            bulkRequestBuilder.setRefreshPolicy(bulkOptions.getRefreshPolicy());
        }
        if (bulkOptions.getWaitForActiveShards() != null) {
            bulkRequestBuilder.setWaitForActiveShards(bulkOptions.getWaitForActiveShards());
        }
        if (bulkOptions.getPipeline() != null) {
            bulkRequestBuilder.pipeline(bulkOptions.getPipeline());
        }
        if (bulkOptions.getRoutingId() != null) {
            bulkRequestBuilder.routing(bulkOptions.getRoutingId());
        }
        queries.forEach(query -> {
            if (query instanceof IndexQuery) {
                bulkRequestBuilder.add(this.indexRequestBuilder(client, (IndexQuery)query, index));
            } else if (query instanceof UpdateQuery) {
                bulkRequestBuilder.add(this.updateRequestBuilderFor(client, (UpdateQuery)query, index));
            }
        });
        return bulkRequestBuilder;
    }

    public CreateIndexRequest createIndexRequest(IndexCoordinates index, Map<String, Object> settings, @Nullable Document mapping) {
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.notNull(settings, (String)"settings must not be null");
        CreateIndexRequest request = new CreateIndexRequest(index.getIndexName());
        if (!settings.isEmpty()) {
            request.settings(settings);
        }
        if (mapping != null && !mapping.isEmpty()) {
            request.mapping((Map)mapping);
        }
        return request;
    }

    public CreateIndexRequestBuilder createIndexRequestBuilder(Client client, IndexCoordinates index, Map<String, Object> settings, @Nullable Document mapping) {
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.notNull(settings, (String)"settings must not be null");
        String indexName = index.getIndexName();
        CreateIndexRequestBuilder createIndexRequestBuilder = client.admin().indices().prepareCreate(indexName);
        if (!settings.isEmpty()) {
            createIndexRequestBuilder.setSettings(settings);
        }
        if (mapping != null && !mapping.isEmpty()) {
            createIndexRequestBuilder.addMapping("_doc", (Map)mapping);
        }
        return createIndexRequestBuilder;
    }

    public GetIndexRequest getIndexRequest(IndexCoordinates index) {
        return new GetIndexRequest(index.getIndexNames());
    }

    public IndicesExistsRequest indicesExistsRequest(IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return new IndicesExistsRequest(indexNames);
    }

    public DeleteIndexRequest deleteIndexRequest(IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return new DeleteIndexRequest(indexNames);
    }

    public RefreshRequest refreshRequest(IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return new RefreshRequest(indexNames);
    }

    public GetSettingsRequest getSettingsRequest(IndexCoordinates index, boolean includeDefaults) {
        String[] indexNames = index.getIndexNames();
        return new GetSettingsRequest().indices(indexNames).includeDefaults(includeDefaults);
    }

    public PutMappingRequest putMappingRequest(IndexCoordinates index, Document mapping) {
        PutMappingRequest request = new PutMappingRequest(index.getIndexNames());
        request.source((Map)mapping);
        return request;
    }

    public PutMappingRequestBuilder putMappingRequestBuilder(Client client, IndexCoordinates index, Document mapping) {
        String[] indexNames = index.getIndexNames();
        PutMappingRequestBuilder requestBuilder = client.admin().indices().preparePutMapping(indexNames).setType("_doc");
        requestBuilder.setSource((Map)mapping);
        return requestBuilder;
    }

    public GetSettingsRequest getSettingsRequest(String indexName, boolean includeDefaults) {
        return new GetSettingsRequest().indices(new String[]{indexName}).includeDefaults(includeDefaults);
    }

    public GetMappingsRequest getMappingsRequest(IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return new GetMappingsRequest().indices(indexNames);
    }

    public org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest getMappingsRequest(Client client, IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return (org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest)new org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest().indices(indexNames);
    }

    public PutIndexTemplateRequest putIndexTemplateRequest(PutTemplateRequest putTemplateRequest) {
        PutIndexTemplateRequest request = new PutIndexTemplateRequest(putTemplateRequest.getName()).patterns(Arrays.asList(putTemplateRequest.getIndexPatterns()));
        if (putTemplateRequest.getSettings() != null) {
            request.settings((Map)putTemplateRequest.getSettings());
        }
        if (putTemplateRequest.getMappings() != null) {
            request.mapping((Map)putTemplateRequest.getMappings());
        }
        request.order(putTemplateRequest.getOrder()).version(putTemplateRequest.getVersion());
        AliasActions aliasActions = putTemplateRequest.getAliasActions();
        if (aliasActions != null) {
            aliasActions.getActions().forEach(aliasAction -> {
                AliasActionParameters parameters = aliasAction.getParameters();
                String[] parametersAliases = parameters.getAliases();
                if (parametersAliases != null) {
                    for (String aliasName : parametersAliases) {
                        Query filterQuery;
                        Alias alias = new Alias(aliasName);
                        if (parameters.getRouting() != null) {
                            alias.routing(parameters.getRouting());
                        }
                        if (parameters.getIndexRouting() != null) {
                            alias.indexRouting(parameters.getIndexRouting());
                        }
                        if (parameters.getSearchRouting() != null) {
                            alias.searchRouting(parameters.getSearchRouting());
                        }
                        if (parameters.getHidden() != null) {
                            alias.isHidden(parameters.getHidden());
                        }
                        if (parameters.getWriteIndex() != null) {
                            alias.writeIndex(parameters.getWriteIndex());
                        }
                        if ((filterQuery = parameters.getFilterQuery()) != null) {
                            this.elasticsearchConverter.updateQuery(filterQuery, parameters.getFilterQueryClass());
                            QueryBuilder queryBuilder = this.getFilter(filterQuery);
                            if (queryBuilder == null) {
                                queryBuilder = this.getQuery(filterQuery);
                            }
                            alias.filter(queryBuilder);
                        }
                        request.alias(alias);
                    }
                }
            });
        }
        return request;
    }

    public org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest putIndexTemplateRequest(Client client, PutTemplateRequest putTemplateRequest) {
        org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest request = new org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest(putTemplateRequest.getName()).patterns(Arrays.asList(putTemplateRequest.getIndexPatterns()));
        if (putTemplateRequest.getSettings() != null) {
            request.settings((Map)putTemplateRequest.getSettings());
        }
        if (putTemplateRequest.getMappings() != null) {
            request.mapping("_doc", (Map)putTemplateRequest.getMappings());
        }
        request.order(putTemplateRequest.getOrder()).version(putTemplateRequest.getVersion());
        AliasActions aliasActions = putTemplateRequest.getAliasActions();
        if (aliasActions != null) {
            aliasActions.getActions().forEach(aliasAction -> {
                AliasActionParameters parameters = aliasAction.getParameters();
                String[] parametersAliases = parameters.getAliases();
                if (parametersAliases != null) {
                    for (String aliasName : parametersAliases) {
                        Query filterQuery;
                        Alias alias = new Alias(aliasName);
                        if (parameters.getRouting() != null) {
                            alias.routing(parameters.getRouting());
                        }
                        if (parameters.getIndexRouting() != null) {
                            alias.indexRouting(parameters.getIndexRouting());
                        }
                        if (parameters.getSearchRouting() != null) {
                            alias.searchRouting(parameters.getSearchRouting());
                        }
                        if (parameters.getHidden() != null) {
                            alias.isHidden(parameters.getHidden());
                        }
                        if (parameters.getWriteIndex() != null) {
                            alias.writeIndex(parameters.getWriteIndex());
                        }
                        if ((filterQuery = parameters.getFilterQuery()) != null) {
                            this.elasticsearchConverter.updateQuery(filterQuery, parameters.getFilterQueryClass());
                            QueryBuilder queryBuilder = this.getFilter(filterQuery);
                            if (queryBuilder == null) {
                                queryBuilder = this.getQuery(filterQuery);
                            }
                            alias.filter(queryBuilder);
                        }
                        request.alias(alias);
                    }
                }
            });
        }
        return request;
    }

    public GetIndexTemplatesRequest getIndexTemplatesRequest(GetTemplateRequest getTemplateRequest) {
        return new GetIndexTemplatesRequest(new String[]{getTemplateRequest.getTemplateName()});
    }

    public org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest getIndexTemplatesRequest(Client client, GetTemplateRequest getTemplateRequest) {
        return new org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest(new String[]{getTemplateRequest.getTemplateName()});
    }

    public IndexTemplatesExistRequest indexTemplatesExistsRequest(ExistsTemplateRequest existsTemplateRequest) {
        return new IndexTemplatesExistRequest(new String[]{existsTemplateRequest.getTemplateName()});
    }

    public DeleteIndexTemplateRequest deleteIndexTemplateRequest(DeleteTemplateRequest deleteTemplateRequest) {
        return new DeleteIndexTemplateRequest(deleteTemplateRequest.getTemplateName());
    }

    public DeleteIndexTemplateRequest deleteIndexTemplateRequest(Client client, DeleteTemplateRequest deleteTemplateRequest) {
        return new DeleteIndexTemplateRequest(deleteTemplateRequest.getTemplateName());
    }

    public DeleteByQueryRequest deleteByQueryRequest(Query query, Class<?> clazz, IndexCoordinates index) {
        SearchRequest searchRequest = this.searchRequest(query, clazz, index);
        DeleteByQueryRequest deleteByQueryRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(index.getIndexNames()).setQuery(searchRequest.source().query()).setAbortOnVersionConflict(false)).setRefresh(true);
        if (query.isLimiting()) {
            deleteByQueryRequest.setBatchSize(query.getMaxResults().intValue());
        }
        if (query.hasScrollTime()) {
            deleteByQueryRequest.setScroll(TimeValue.timeValueMillis((long)query.getScrollTime().toMillis()));
        }
        if (query.getRoute() != null) {
            deleteByQueryRequest.setRouting(query.getRoute());
        }
        return deleteByQueryRequest;
    }

    public DeleteRequest deleteRequest(String id, @Nullable String routing, IndexCoordinates index) {
        String indexName = index.getIndexName();
        DeleteRequest deleteRequest = new DeleteRequest(indexName, id);
        if (routing != null) {
            deleteRequest.routing(routing);
        }
        return deleteRequest;
    }

    public DeleteRequestBuilder deleteRequestBuilder(Client client, String id, @Nullable String routing, IndexCoordinates index) {
        String indexName = index.getIndexName();
        DeleteRequestBuilder deleteRequestBuilder = client.prepareDelete();
        deleteRequestBuilder.setIndex(indexName);
        deleteRequestBuilder.setId(id);
        if (routing != null) {
            deleteRequestBuilder.setRouting(routing);
        }
        return deleteRequestBuilder;
    }

    public DeleteByQueryRequestBuilder deleteByQueryRequestBuilder(Client client, Query query, Class<?> clazz, IndexCoordinates index) {
        SearchRequest searchRequest = this.searchRequest(query, clazz, index);
        DeleteByQueryRequestBuilder requestBuilder = (DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((ElasticsearchClient)client, (ActionType)DeleteByQueryAction.INSTANCE).source(index.getIndexNames())).filter(searchRequest.source().query())).abortOnVersionConflict(false).refresh(true);
        SearchRequestBuilder source = requestBuilder.source();
        if (query.isLimiting()) {
            source.setSize(query.getMaxResults().intValue());
        }
        if (query.hasScrollTime()) {
            source.setScroll(TimeValue.timeValueMillis((long)query.getScrollTime().toMillis()));
        }
        if (query.getRoute() != null) {
            source.setRouting(query.getRoute());
        }
        return requestBuilder;
    }

    public GetRequest getRequest(String id, @Nullable String routing, IndexCoordinates index) {
        GetRequest getRequest = new GetRequest(index.getIndexName(), id);
        getRequest.routing(routing);
        return getRequest;
    }

    public GetRequestBuilder getRequestBuilder(Client client, String id, @Nullable String routing, IndexCoordinates index) {
        GetRequestBuilder getRequestBuilder = client.prepareGet(index.getIndexName(), null, id);
        getRequestBuilder.setRouting(routing);
        return getRequestBuilder;
    }

    public MultiGetRequest multiGetRequest(Query query, Class<?> clazz, IndexCoordinates index) {
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        this.getMultiRequestItems(query, clazz, index).forEach(arg_0 -> ((MultiGetRequest)multiGetRequest).add(arg_0));
        return multiGetRequest;
    }

    public MultiGetRequestBuilder multiGetRequestBuilder(Client client, Query searchQuery, Class<?> clazz, IndexCoordinates index) {
        MultiGetRequestBuilder multiGetRequestBuilder = client.prepareMultiGet();
        this.getMultiRequestItems(searchQuery, clazz, index).forEach(arg_0 -> ((MultiGetRequestBuilder)multiGetRequestBuilder).add(arg_0));
        return multiGetRequestBuilder;
    }

    private List<MultiGetRequest.Item> getMultiRequestItems(Query searchQuery, Class<?> clazz, IndexCoordinates index) {
        this.elasticsearchConverter.updateQuery(searchQuery, clazz);
        ArrayList<MultiGetRequest.Item> items = new ArrayList<MultiGetRequest.Item>();
        FetchSourceContext fetchSourceContext = this.getFetchSourceContext(searchQuery);
        if (!CollectionUtils.isEmpty(searchQuery.getIds())) {
            String indexName = index.getIndexName();
            for (String id : searchQuery.getIds()) {
                MultiGetRequest.Item item = new MultiGetRequest.Item(indexName, id);
                if (searchQuery.getRoute() != null) {
                    item = item.routing(searchQuery.getRoute());
                }
                if (fetchSourceContext != null) {
                    item.fetchSourceContext(fetchSourceContext);
                }
                items.add(item);
            }
        }
        return items;
    }

    public IndexRequest indexRequest(IndexQuery query, IndexCoordinates index) {
        IndexRequest indexRequest;
        String indexName = index.getIndexName();
        if (query.getObject() != null) {
            String id = StringUtils.isEmpty((Object)query.getId()) ? this.getPersistentEntityId(query.getObject()) : query.getId();
            indexRequest = id != null ? new IndexRequest(indexName).id(id) : new IndexRequest(indexName);
            indexRequest.source(this.elasticsearchConverter.mapObject(query.getObject()).toJson(), Requests.INDEX_CONTENT_TYPE);
        } else if (query.getSource() != null) {
            indexRequest = new IndexRequest(indexName).id(query.getId()).source(query.getSource(), Requests.INDEX_CONTENT_TYPE);
        } else {
            throw new InvalidDataAccessApiUsageException("object or source is null, failed to index the document [id: " + query.getId() + ']');
        }
        if (query.getVersion() != null) {
            indexRequest.version(query.getVersion().longValue());
            VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(query.getObject().getClass());
            indexRequest.versionType(versionType);
        }
        if (query.getSeqNo() != null) {
            indexRequest.setIfSeqNo(query.getSeqNo().longValue());
        }
        if (query.getPrimaryTerm() != null) {
            indexRequest.setIfPrimaryTerm(query.getPrimaryTerm().longValue());
        }
        if (query.getRouting() != null) {
            indexRequest.routing(query.getRouting());
        }
        if (query.getOpType() != null) {
            switch (query.getOpType()) {
                case INDEX: {
                    indexRequest.opType(DocWriteRequest.OpType.INDEX);
                    break;
                }
                case CREATE: {
                    indexRequest.opType(DocWriteRequest.OpType.CREATE);
                }
            }
        }
        return indexRequest;
    }

    public IndexRequestBuilder indexRequestBuilder(Client client, IndexQuery query, IndexCoordinates index) {
        IndexRequestBuilder indexRequestBuilder;
        String indexName = index.getIndexName();
        String type = "_doc";
        if (query.getObject() != null) {
            String id = StringUtils.isEmpty((Object)query.getId()) ? this.getPersistentEntityId(query.getObject()) : query.getId();
            indexRequestBuilder = id != null ? client.prepareIndex(indexName, type, id) : client.prepareIndex(indexName, type);
            indexRequestBuilder.setSource(this.elasticsearchConverter.mapObject(query.getObject()).toJson(), Requests.INDEX_CONTENT_TYPE);
        } else if (query.getSource() != null) {
            indexRequestBuilder = client.prepareIndex(indexName, type, query.getId()).setSource(query.getSource(), Requests.INDEX_CONTENT_TYPE);
        } else {
            throw new InvalidDataAccessApiUsageException("object or source is null, failed to index the document [id: " + query.getId() + ']');
        }
        if (query.getVersion() != null) {
            indexRequestBuilder.setVersion(query.getVersion().longValue());
            VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(query.getObject().getClass());
            indexRequestBuilder.setVersionType(versionType);
        }
        if (query.getSeqNo() != null) {
            indexRequestBuilder.setIfSeqNo(query.getSeqNo().longValue());
        }
        if (query.getPrimaryTerm() != null) {
            indexRequestBuilder.setIfPrimaryTerm(query.getPrimaryTerm().longValue());
        }
        if (query.getRouting() != null) {
            indexRequestBuilder.setRouting(query.getRouting());
        }
        return indexRequestBuilder;
    }

    @Nullable
    public HighlightBuilder highlightBuilder(Query query) {
        NativeSearchQuery searchQuery;
        HighlightBuilder highlightBuilder = query.getHighlightQuery().map(HighlightQuery::getHighlightBuilder).orElse(null);
        if (highlightBuilder == null && query instanceof NativeSearchQuery && ((searchQuery = (NativeSearchQuery)query).getHighlightFields() != null || searchQuery.getHighlightBuilder() != null)) {
            highlightBuilder = searchQuery.getHighlightBuilder();
            if (highlightBuilder == null) {
                highlightBuilder = new HighlightBuilder();
            }
            if (searchQuery.getHighlightFields() != null) {
                for (HighlightBuilder.Field highlightField : searchQuery.getHighlightFields()) {
                    highlightBuilder.field(highlightField);
                }
            }
        }
        return highlightBuilder;
    }

    public MoreLikeThisQueryBuilder moreLikeThisQueryBuilder(MoreLikeThisQuery query, IndexCoordinates index) {
        String indexName = index.getIndexName();
        MoreLikeThisQueryBuilder.Item item = new MoreLikeThisQueryBuilder.Item(indexName, query.getId());
        String[] fields = query.getFields().toArray(new String[0]);
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = QueryBuilders.moreLikeThisQuery((String[])fields, null, (MoreLikeThisQueryBuilder.Item[])new MoreLikeThisQueryBuilder.Item[]{item});
        if (query.getMinTermFreq() != null) {
            moreLikeThisQueryBuilder.minTermFreq(query.getMinTermFreq().intValue());
        }
        if (query.getMaxQueryTerms() != null) {
            moreLikeThisQueryBuilder.maxQueryTerms(query.getMaxQueryTerms().intValue());
        }
        if (!CollectionUtils.isEmpty(query.getStopWords())) {
            moreLikeThisQueryBuilder.stopWords(query.getStopWords());
        }
        if (query.getMinDocFreq() != null) {
            moreLikeThisQueryBuilder.minDocFreq(query.getMinDocFreq().intValue());
        }
        if (query.getMaxDocFreq() != null) {
            moreLikeThisQueryBuilder.maxDocFreq(query.getMaxDocFreq().intValue());
        }
        if (query.getMinWordLen() != null) {
            moreLikeThisQueryBuilder.minWordLength(query.getMinWordLen().intValue());
        }
        if (query.getMaxWordLen() != null) {
            moreLikeThisQueryBuilder.maxWordLength(query.getMaxWordLen().intValue());
        }
        if (query.getBoostTerms() != null) {
            moreLikeThisQueryBuilder.boostTerms(query.getBoostTerms().floatValue());
        }
        return moreLikeThisQueryBuilder;
    }

    public SearchRequest searchRequest(SuggestBuilder suggestion, IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        SearchRequest searchRequest = new SearchRequest(indexNames);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.suggest(suggestion);
        searchRequest.source(sourceBuilder);
        return searchRequest;
    }

    public SearchRequestBuilder searchRequestBuilder(Client client, SuggestBuilder suggestion, IndexCoordinates index) {
        String[] indexNames = index.getIndexNames();
        return client.prepareSearch(indexNames).suggest(suggestion);
    }

    public SearchRequest searchRequest(Query query, @Nullable Class<?> clazz, IndexCoordinates index) {
        this.elasticsearchConverter.updateQuery(query, clazz);
        SearchRequest searchRequest = this.prepareSearchRequest(query, clazz, index);
        QueryBuilder elasticsearchQuery = this.getQuery(query);
        QueryBuilder elasticsearchFilter = this.getFilter(query);
        searchRequest.source().query(elasticsearchQuery);
        if (elasticsearchFilter != null) {
            searchRequest.source().postFilter(elasticsearchFilter);
        }
        return searchRequest;
    }

    public SearchRequestBuilder searchRequestBuilder(Client client, Query query, @Nullable Class<?> clazz, IndexCoordinates index) {
        this.elasticsearchConverter.updateQuery(query, clazz);
        SearchRequestBuilder searchRequestBuilder = this.prepareSearchRequestBuilder(query, client, clazz, index);
        QueryBuilder elasticsearchQuery = this.getQuery(query);
        QueryBuilder elasticsearchFilter = this.getFilter(query);
        searchRequestBuilder.setQuery(elasticsearchQuery);
        if (elasticsearchFilter != null) {
            searchRequestBuilder.setPostFilter(elasticsearchFilter);
        }
        return searchRequestBuilder;
    }

    private SearchRequest prepareSearchRequest(Query query, @Nullable Class<?> clazz, IndexCoordinates indexCoordinates) {
        TimeValue timeout;
        Object[] indexNames = indexCoordinates.getIndexNames();
        Assert.notNull((Object)indexNames, (String)"No index defined for Query");
        Assert.notEmpty((Object[])indexNames, (String)"No index defined for Query");
        SearchRequest request = new SearchRequest((String[])indexNames);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.version(Boolean.valueOf(true));
        sourceBuilder.trackScores(query.getTrackScores());
        if (this.hasSeqNoPrimaryTermProperty(clazz)) {
            sourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true));
        }
        if (query.getSourceFilter() != null) {
            SourceFilter sourceFilter = query.getSourceFilter();
            sourceBuilder.fetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        if (query.getPageable().isPaged()) {
            sourceBuilder.from((int)query.getPageable().getOffset());
            sourceBuilder.size(query.getPageable().getPageSize());
        } else {
            sourceBuilder.from(0);
            sourceBuilder.size(INDEX_MAX_RESULT_WINDOW.intValue());
        }
        if (!query.getFields().isEmpty()) {
            sourceBuilder.fetchSource(query.getFields().toArray(new String[0]), null);
        }
        if (query.getIndicesOptions() != null) {
            request.indicesOptions(query.getIndicesOptions());
        }
        if (query.isLimiting()) {
            sourceBuilder.size(query.getMaxResults().intValue());
        }
        if (query.getMinScore() > 0.0f) {
            sourceBuilder.minScore(query.getMinScore());
        }
        if (query.getPreference() != null) {
            request.preference(query.getPreference());
        }
        request.searchType(query.getSearchType());
        this.prepareSort(query, sourceBuilder, this.getPersistentEntity(clazz));
        HighlightBuilder highlightBuilder = this.highlightBuilder(query);
        if (highlightBuilder != null) {
            sourceBuilder.highlighter(highlightBuilder);
        }
        if (query instanceof NativeSearchQuery) {
            this.prepareNativeSearch((NativeSearchQuery)query, sourceBuilder);
        }
        if (query.getTrackTotalHits() != null) {
            sourceBuilder.trackTotalHits(query.getTrackTotalHits().booleanValue());
        } else if (query.getTrackTotalHitsUpTo() != null) {
            sourceBuilder.trackTotalHitsUpTo(query.getTrackTotalHitsUpTo().intValue());
        }
        if (StringUtils.hasLength((String)query.getRoute())) {
            request.routing(query.getRoute());
        }
        if ((timeout = query.getTimeout()) != null) {
            sourceBuilder.timeout(timeout);
        }
        sourceBuilder.explain(Boolean.valueOf(query.getExplain()));
        if (query.getSearchAfter() != null) {
            sourceBuilder.searchAfter(query.getSearchAfter().toArray());
        }
        query.getRescorerQueries().forEach(rescorer -> sourceBuilder.addRescorer((RescorerBuilder)this.getQueryRescorerBuilder((RescorerQuery)rescorer)));
        request.source(sourceBuilder);
        return request;
    }

    private SearchRequestBuilder prepareSearchRequestBuilder(Query query, Client client, @Nullable Class<?> clazz, IndexCoordinates index) {
        TimeValue timeout;
        Object[] indexNames = index.getIndexNames();
        Assert.notNull((Object)indexNames, (String)"No index defined for Query");
        Assert.notEmpty((Object[])indexNames, (String)"No index defined for Query");
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch((String[])indexNames).setSearchType(query.getSearchType()).setVersion(true).setTrackScores(query.getTrackScores());
        if (this.hasSeqNoPrimaryTermProperty(clazz)) {
            searchRequestBuilder.seqNoAndPrimaryTerm(true);
        }
        if (query.getSourceFilter() != null) {
            SourceFilter sourceFilter = query.getSourceFilter();
            searchRequestBuilder.setFetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        if (query.getPageable().isPaged()) {
            searchRequestBuilder.setFrom((int)query.getPageable().getOffset());
            searchRequestBuilder.setSize(query.getPageable().getPageSize());
        } else {
            searchRequestBuilder.setFrom(0);
            searchRequestBuilder.setSize(INDEX_MAX_RESULT_WINDOW.intValue());
        }
        if (!query.getFields().isEmpty()) {
            searchRequestBuilder.setFetchSource(query.getFields().toArray(new String[0]), null);
        }
        if (query.getIndicesOptions() != null) {
            searchRequestBuilder.setIndicesOptions(query.getIndicesOptions());
        }
        if (query.isLimiting()) {
            searchRequestBuilder.setSize(query.getMaxResults().intValue());
        }
        if (query.getMinScore() > 0.0f) {
            searchRequestBuilder.setMinScore(query.getMinScore());
        }
        if (query.getPreference() != null) {
            searchRequestBuilder.setPreference(query.getPreference());
        }
        this.prepareSort(query, searchRequestBuilder, this.getPersistentEntity(clazz));
        HighlightBuilder highlightBuilder = this.highlightBuilder(query);
        if (highlightBuilder != null) {
            searchRequestBuilder.highlighter(highlightBuilder);
        }
        if (query instanceof NativeSearchQuery) {
            this.prepareNativeSearch(searchRequestBuilder, (NativeSearchQuery)query);
        }
        if (query.getTrackTotalHits() != null) {
            searchRequestBuilder.setTrackTotalHits(query.getTrackTotalHits().booleanValue());
        } else if (query.getTrackTotalHitsUpTo() != null) {
            searchRequestBuilder.setTrackTotalHitsUpTo(query.getTrackTotalHitsUpTo().intValue());
        }
        if (StringUtils.hasLength((String)query.getRoute())) {
            searchRequestBuilder.setRouting(query.getRoute());
        }
        if ((timeout = query.getTimeout()) != null) {
            searchRequestBuilder.setTimeout(timeout);
        }
        searchRequestBuilder.setExplain(query.getExplain());
        if (query.getSearchAfter() != null) {
            searchRequestBuilder.searchAfter(query.getSearchAfter().toArray());
        }
        query.getRescorerQueries().forEach(rescorer -> searchRequestBuilder.addRescorer((RescorerBuilder)this.getQueryRescorerBuilder((RescorerQuery)rescorer)));
        return searchRequestBuilder;
    }

    private void prepareNativeSearch(NativeSearchQuery query, SearchSourceBuilder sourceBuilder) {
        if (!query.getScriptFields().isEmpty()) {
            for (ScriptField scriptField : query.getScriptFields()) {
                sourceBuilder.scriptField(scriptField.fieldName(), scriptField.script());
            }
        }
        if (query.getCollapseBuilder() != null) {
            sourceBuilder.collapse(query.getCollapseBuilder());
        }
        if (!CollectionUtils.isEmpty(query.getIndicesBoost())) {
            for (IndexBoost indexBoost : query.getIndicesBoost()) {
                sourceBuilder.indexBoost(indexBoost.getIndexName(), indexBoost.getBoost());
            }
        }
        if (!CollectionUtils.isEmpty(query.getAggregations())) {
            for (AbstractAggregationBuilder abstractAggregationBuilder : query.getAggregations()) {
                sourceBuilder.aggregation((AggregationBuilder)abstractAggregationBuilder);
            }
        }
    }

    private void prepareNativeSearch(SearchRequestBuilder searchRequestBuilder, NativeSearchQuery nativeSearchQuery) {
        if (!CollectionUtils.isEmpty(nativeSearchQuery.getScriptFields())) {
            for (ScriptField scriptField : nativeSearchQuery.getScriptFields()) {
                searchRequestBuilder.addScriptField(scriptField.fieldName(), scriptField.script());
            }
        }
        if (nativeSearchQuery.getCollapseBuilder() != null) {
            searchRequestBuilder.setCollapse(nativeSearchQuery.getCollapseBuilder());
        }
        if (!CollectionUtils.isEmpty(nativeSearchQuery.getIndicesBoost())) {
            for (IndexBoost indexBoost : nativeSearchQuery.getIndicesBoost()) {
                searchRequestBuilder.addIndexBoost(indexBoost.getIndexName(), indexBoost.getBoost());
            }
        }
        if (!CollectionUtils.isEmpty(nativeSearchQuery.getAggregations())) {
            for (AbstractAggregationBuilder abstractAggregationBuilder : nativeSearchQuery.getAggregations()) {
                searchRequestBuilder.addAggregation((AggregationBuilder)abstractAggregationBuilder);
            }
        }
    }

    private void prepareSort(Query query, SearchSourceBuilder sourceBuilder, @Nullable ElasticsearchPersistentEntity<?> entity) {
        NativeSearchQuery nativeSearchQuery;
        List<SortBuilder<?>> sorts;
        if (query.getSort() != null) {
            query.getSort().forEach(order -> sourceBuilder.sort(this.getSortBuilder((Sort.Order)order, entity)));
        }
        if (query instanceof NativeSearchQuery && (sorts = (nativeSearchQuery = (NativeSearchQuery)query).getElasticsearchSorts()) != null) {
            sorts.forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).sort(arg_0));
        }
    }

    private void prepareSort(Query query, SearchRequestBuilder searchRequestBuilder, @Nullable ElasticsearchPersistentEntity<?> entity) {
        NativeSearchQuery nativeSearchQuery;
        List<SortBuilder<?>> sorts;
        if (query.getSort() != null) {
            query.getSort().forEach(order -> searchRequestBuilder.addSort(this.getSortBuilder((Sort.Order)order, entity)));
        }
        if (query instanceof NativeSearchQuery && (sorts = (nativeSearchQuery = (NativeSearchQuery)query).getElasticsearchSorts()) != null) {
            sorts.forEach(arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).addSort(arg_0));
        }
    }

    private SortBuilder<?> getSortBuilder(Sort.Order order, @Nullable ElasticsearchPersistentEntity<?> entity) {
        String fieldName;
        SortOrder sortOrder;
        SortOrder sortOrder2 = sortOrder = order.getDirection().isDescending() ? SortOrder.DESC : SortOrder.ASC;
        if ("_score".equals(order.getProperty())) {
            return SortBuilders.scoreSort().order(sortOrder);
        }
        ElasticsearchPersistentProperty property = entity != null ? (ElasticsearchPersistentProperty)entity.getPersistentProperty(order.getProperty()) : null;
        String string = fieldName = property != null ? property.getFieldName() : order.getProperty();
        if (order instanceof GeoDistanceOrder) {
            GeoDistanceOrder geoDistanceOrder = (GeoDistanceOrder)order;
            GeoDistanceSortBuilder sort = SortBuilders.geoDistanceSort((String)fieldName, (double)geoDistanceOrder.getGeoPoint().getLat(), (double)geoDistanceOrder.getGeoPoint().getLon());
            sort.geoDistance(GeoDistance.fromString((String)geoDistanceOrder.getDistanceType().name()));
            sort.ignoreUnmapped(geoDistanceOrder.getIgnoreUnmapped().booleanValue());
            sort.sortMode(SortMode.fromString((String)geoDistanceOrder.getMode().name()));
            sort.unit(DistanceUnit.fromString((String)geoDistanceOrder.getUnit()));
            return sort;
        }
        FieldSortBuilder sort = (FieldSortBuilder)SortBuilders.fieldSort((String)fieldName).order(sortOrder);
        if (order.getNullHandling() == Sort.NullHandling.NULLS_FIRST) {
            sort.missing((Object)"_first");
        } else if (order.getNullHandling() == Sort.NullHandling.NULLS_LAST) {
            sort.missing((Object)"_last");
        }
        return sort;
    }

    private QueryRescorerBuilder getQueryRescorerBuilder(RescorerQuery rescorerQuery) {
        QueryBuilder queryBuilder = this.getQuery(rescorerQuery.getQuery());
        Assert.notNull((Object)"queryBuilder", (String)"Could not build query for rescorerQuery");
        QueryRescorerBuilder builder = new QueryRescorerBuilder(queryBuilder);
        if (rescorerQuery.getScoreMode() != RescorerQuery.ScoreMode.Default) {
            builder.setScoreMode(QueryRescoreMode.valueOf((String)rescorerQuery.getScoreMode().name()));
        }
        if (rescorerQuery.getQueryWeight() != null) {
            builder.setQueryWeight(rescorerQuery.getQueryWeight().floatValue());
        }
        if (rescorerQuery.getRescoreQueryWeight() != null) {
            builder.setRescoreQueryWeight(rescorerQuery.getRescoreQueryWeight().floatValue());
        }
        if (rescorerQuery.getWindowSize() != null) {
            builder.windowSize(rescorerQuery.getWindowSize().intValue());
        }
        return builder;
    }

    public UpdateRequest updateRequest(UpdateQuery query, IndexCoordinates index) {
        String indexName = index.getIndexName();
        UpdateRequest updateRequest = new UpdateRequest(indexName, query.getId());
        if (query.getScript() != null) {
            Map<String, Object> params = query.getParams();
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            Script script = new Script(this.getScriptType(query.getScriptType()), query.getLang(), query.getScript(), params);
            updateRequest.script(script);
        }
        if (query.getDocument() != null) {
            updateRequest.doc((Map)query.getDocument());
        }
        if (query.getUpsert() != null) {
            updateRequest.upsert((Map)query.getUpsert());
        }
        if (query.getRouting() != null) {
            updateRequest.routing(query.getRouting());
        }
        if (query.getScriptedUpsert() != null) {
            updateRequest.scriptedUpsert(query.getScriptedUpsert().booleanValue());
        }
        if (query.getDocAsUpsert() != null) {
            updateRequest.docAsUpsert(query.getDocAsUpsert().booleanValue());
        }
        if (query.getFetchSource() != null) {
            updateRequest.fetchSource(query.getFetchSource().booleanValue());
        }
        if (query.getFetchSourceIncludes() != null || query.getFetchSourceExcludes() != null) {
            List<Object> includes = query.getFetchSourceIncludes() != null ? query.getFetchSourceIncludes() : Collections.emptyList();
            List<Object> excludes = query.getFetchSourceExcludes() != null ? query.getFetchSourceExcludes() : Collections.emptyList();
            updateRequest.fetchSource(includes.toArray(new String[0]), excludes.toArray(new String[0]));
        }
        if (query.getIfSeqNo() != null) {
            updateRequest.setIfSeqNo((long)query.getIfSeqNo().intValue());
        }
        if (query.getIfPrimaryTerm() != null) {
            updateRequest.setIfPrimaryTerm((long)query.getIfPrimaryTerm().intValue());
        }
        if (query.getRefreshPolicy() != null) {
            updateRequest.setRefreshPolicy(RequestFactory.toElasticsearchRefreshPolicy(query.getRefreshPolicy()));
        }
        if (query.getRetryOnConflict() != null) {
            updateRequest.retryOnConflict(query.getRetryOnConflict().intValue());
        }
        if (query.getTimeout() != null) {
            updateRequest.timeout(query.getTimeout());
        }
        if (query.getWaitForActiveShards() != null) {
            updateRequest.waitForActiveShards(ActiveShardCount.parseString((String)query.getWaitForActiveShards()));
        }
        return updateRequest;
    }

    public UpdateRequestBuilder updateRequestBuilderFor(Client client, UpdateQuery query, IndexCoordinates index) {
        String indexName = index.getIndexName();
        UpdateRequestBuilder updateRequestBuilder = client.prepareUpdate(indexName, "_doc", query.getId());
        if (query.getScript() != null) {
            Map<String, Object> params = query.getParams();
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            Script script = new Script(this.getScriptType(query.getScriptType()), query.getLang(), query.getScript(), params);
            updateRequestBuilder.setScript(script);
        }
        if (query.getDocument() != null) {
            updateRequestBuilder.setDoc((Map)query.getDocument());
        }
        if (query.getUpsert() != null) {
            updateRequestBuilder.setUpsert((Map)query.getUpsert());
        }
        if (query.getRouting() != null) {
            updateRequestBuilder.setRouting(query.getRouting());
        }
        if (query.getScriptedUpsert() != null) {
            updateRequestBuilder.setScriptedUpsert(query.getScriptedUpsert().booleanValue());
        }
        if (query.getDocAsUpsert() != null) {
            updateRequestBuilder.setDocAsUpsert(query.getDocAsUpsert().booleanValue());
        }
        if (query.getFetchSource() != null) {
            updateRequestBuilder.setFetchSource(query.getFetchSource().booleanValue());
        }
        if (query.getFetchSourceIncludes() != null || query.getFetchSourceExcludes() != null) {
            List<Object> includes = query.getFetchSourceIncludes() != null ? query.getFetchSourceIncludes() : Collections.emptyList();
            List<Object> excludes = query.getFetchSourceExcludes() != null ? query.getFetchSourceExcludes() : Collections.emptyList();
            updateRequestBuilder.setFetchSource(includes.toArray(new String[0]), excludes.toArray(new String[0]));
        }
        if (query.getIfSeqNo() != null) {
            updateRequestBuilder.setIfSeqNo((long)query.getIfSeqNo().intValue());
        }
        if (query.getIfPrimaryTerm() != null) {
            updateRequestBuilder.setIfPrimaryTerm((long)query.getIfPrimaryTerm().intValue());
        }
        if (query.getRefreshPolicy() != null) {
            updateRequestBuilder.setRefreshPolicy(RequestFactory.toElasticsearchRefreshPolicy(query.getRefreshPolicy()));
        }
        if (query.getRetryOnConflict() != null) {
            updateRequestBuilder.setRetryOnConflict(query.getRetryOnConflict().intValue());
        }
        if (query.getTimeout() != null) {
            updateRequestBuilder.setTimeout(query.getTimeout());
        }
        if (query.getWaitForActiveShards() != null) {
            updateRequestBuilder.setWaitForActiveShards(ActiveShardCount.parseString((String)query.getWaitForActiveShards()));
        }
        return updateRequestBuilder;
    }

    public UpdateByQueryRequest updateByQueryRequest(UpdateQuery query, IndexCoordinates index) {
        String indexName = index.getIndexName();
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexName});
        updateByQueryRequest.setScript(this.getScript(query));
        if (query.getAbortOnVersionConflict() != null) {
            updateByQueryRequest.setAbortOnVersionConflict(query.getAbortOnVersionConflict().booleanValue());
        }
        if (query.getBatchSize() != null) {
            updateByQueryRequest.setBatchSize(query.getBatchSize().intValue());
        }
        if (query.getQuery() != null) {
            Query queryQuery = query.getQuery();
            updateByQueryRequest.setQuery(this.getQuery(queryQuery));
            if (queryQuery.getIndicesOptions() != null) {
                updateByQueryRequest.setIndicesOptions(queryQuery.getIndicesOptions());
            }
            if (queryQuery.getScrollTime() != null) {
                updateByQueryRequest.setScroll(TimeValue.timeValueMillis((long)queryQuery.getScrollTime().toMillis()));
            }
        }
        if (query.getMaxDocs() != null) {
            updateByQueryRequest.setMaxDocs(query.getMaxDocs().intValue());
        }
        if (query.getMaxRetries() != null) {
            updateByQueryRequest.setMaxRetries(query.getMaxRetries().intValue());
        }
        if (query.getPipeline() != null) {
            updateByQueryRequest.setPipeline(query.getPipeline());
        }
        if (query.getRefreshPolicy() != null) {
            updateByQueryRequest.setRefresh(query.getRefreshPolicy() == RefreshPolicy.IMMEDIATE);
        }
        if (query.getRequestsPerSecond() != null) {
            updateByQueryRequest.setRequestsPerSecond(query.getRequestsPerSecond().floatValue());
        }
        if (query.getRouting() != null) {
            updateByQueryRequest.setRouting(query.getRouting());
        }
        if (query.getShouldStoreResult() != null) {
            updateByQueryRequest.setShouldStoreResult(query.getShouldStoreResult().booleanValue());
        }
        if (query.getSlices() != null) {
            updateByQueryRequest.setSlices(query.getSlices().intValue());
        }
        if (query.getTimeout() != null) {
            updateByQueryRequest.setTimeout(query.getTimeout());
        }
        if (query.getWaitForActiveShards() != null) {
            updateByQueryRequest.setWaitForActiveShards(ActiveShardCount.parseString((String)query.getWaitForActiveShards()));
        }
        return updateByQueryRequest;
    }

    public UpdateByQueryRequestBuilder updateByQueryRequestBuilder(Client client, UpdateQuery query, IndexCoordinates index) {
        String indexName = index.getIndexName();
        UpdateByQueryRequestBuilder updateByQueryRequestBuilder = new UpdateByQueryRequestBuilder((ElasticsearchClient)client, (ActionType)UpdateByQueryAction.INSTANCE);
        updateByQueryRequestBuilder.source(new String[]{indexName});
        updateByQueryRequestBuilder.script(this.getScript(query));
        if (query.getAbortOnVersionConflict() != null) {
            updateByQueryRequestBuilder.abortOnVersionConflict(query.getAbortOnVersionConflict().booleanValue());
        }
        if (query.getBatchSize() != null) {
            updateByQueryRequestBuilder.source().setSize(query.getBatchSize().intValue());
        }
        if (query.getQuery() != null) {
            Query queryQuery = query.getQuery();
            updateByQueryRequestBuilder.filter(this.getQuery(queryQuery));
            if (queryQuery.getIndicesOptions() != null) {
                updateByQueryRequestBuilder.source().setIndicesOptions(queryQuery.getIndicesOptions());
            }
            if (queryQuery.getScrollTime() != null) {
                updateByQueryRequestBuilder.source().setScroll(TimeValue.timeValueMillis((long)queryQuery.getScrollTime().toMillis()));
            }
        }
        if (query.getMaxDocs() != null) {
            updateByQueryRequestBuilder.maxDocs(query.getMaxDocs().intValue());
        }
        if (query.getMaxRetries() != null) {
            updateByQueryRequestBuilder.setMaxRetries(query.getMaxRetries().intValue());
        }
        if (query.getPipeline() != null) {
            updateByQueryRequestBuilder.setPipeline(query.getPipeline());
        }
        if (query.getRefreshPolicy() != null) {
            updateByQueryRequestBuilder.refresh(query.getRefreshPolicy() == RefreshPolicy.IMMEDIATE);
        }
        if (query.getRequestsPerSecond() != null) {
            updateByQueryRequestBuilder.setRequestsPerSecond(query.getRequestsPerSecond().floatValue());
        }
        if (query.getRouting() != null) {
            updateByQueryRequestBuilder.source().setRouting(query.getRouting());
        }
        if (query.getShouldStoreResult() != null) {
            updateByQueryRequestBuilder.setShouldStoreResult(query.getShouldStoreResult().booleanValue());
        }
        if (query.getSlices() != null) {
            updateByQueryRequestBuilder.setSlices(query.getSlices().intValue());
        }
        if (query.getTimeout() != null) {
            updateByQueryRequestBuilder.source().setTimeout(TimeValue.parseTimeValue((String)query.getTimeout(), (String)(this.getClass().getSimpleName() + ".timeout")));
        }
        return updateByQueryRequestBuilder;
    }

    @Nullable
    private QueryBuilder getQuery(Query query) {
        QueryBuilder elasticsearchQuery;
        if (query instanceof NativeSearchQuery) {
            NativeSearchQuery searchQuery = (NativeSearchQuery)query;
            elasticsearchQuery = searchQuery.getQuery();
        } else if (query instanceof CriteriaQuery) {
            CriteriaQuery criteriaQuery = (CriteriaQuery)query;
            elasticsearchQuery = new CriteriaQueryProcessor().createQuery(criteriaQuery.getCriteria());
        } else if (query instanceof StringQuery) {
            StringQuery stringQuery = (StringQuery)query;
            elasticsearchQuery = QueryBuilders.wrapperQuery((String)stringQuery.getSource());
        } else {
            throw new IllegalArgumentException("unhandled Query implementation " + query.getClass().getName());
        }
        return elasticsearchQuery;
    }

    @Nullable
    private QueryBuilder getFilter(Query query) {
        QueryBuilder elasticsearchFilter;
        if (query instanceof NativeSearchQuery) {
            NativeSearchQuery searchQuery = (NativeSearchQuery)query;
            elasticsearchFilter = searchQuery.getFilter();
        } else if (query instanceof CriteriaQuery) {
            CriteriaQuery criteriaQuery = (CriteriaQuery)query;
            elasticsearchFilter = new CriteriaFilterProcessor().createFilter(criteriaQuery.getCriteria());
        } else if (query instanceof StringQuery) {
            elasticsearchFilter = null;
        } else {
            throw new IllegalArgumentException("unhandled Query implementation " + query.getClass().getName());
        }
        return elasticsearchFilter;
    }

    public static WriteRequest.RefreshPolicy toElasticsearchRefreshPolicy(RefreshPolicy refreshPolicy) {
        switch (refreshPolicy) {
            case IMMEDIATE: {
                return WriteRequest.RefreshPolicy.IMMEDIATE;
            }
            case WAIT_UNTIL: {
                return WriteRequest.RefreshPolicy.WAIT_UNTIL;
            }
        }
        return WriteRequest.RefreshPolicy.NONE;
    }

    private FetchSourceContext getFetchSourceContext(Query searchQuery) {
        FetchSourceContext fetchSourceContext = null;
        SourceFilter sourceFilter = searchQuery.getSourceFilter();
        if (!CollectionUtils.isEmpty(searchQuery.getFields())) {
            if (sourceFilter == null) {
                sourceFilter = new FetchSourceFilter(this.toArray(searchQuery.getFields()), null);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                Collections.addAll(arrayList, sourceFilter.getIncludes());
                sourceFilter = new FetchSourceFilter(this.toArray(arrayList), null);
            }
            fetchSourceContext = new FetchSourceContext(true, sourceFilter.getIncludes(), sourceFilter.getExcludes());
        } else if (sourceFilter != null) {
            fetchSourceContext = new FetchSourceContext(true, sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        return fetchSourceContext;
    }

    @Nullable
    private ElasticsearchPersistentEntity<?> getPersistentEntity(@Nullable Class<?> clazz) {
        return clazz != null ? (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(clazz) : null;
    }

    @Nullable
    private String getPersistentEntityId(Object entity) {
        Object identifier;
        MappingContext mappingContext = this.elasticsearchConverter.getMappingContext();
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)mappingContext.getPersistentEntity(entity.getClass());
        if (persistentEntity != null && (identifier = persistentEntity.getIdentifierAccessor(entity).getIdentifier()) != null) {
            return identifier.toString();
        }
        return null;
    }

    private VersionType retrieveVersionTypeFromPersistentEntity(Class<?> clazz) {
        MappingContext mappingContext = this.elasticsearchConverter.getMappingContext();
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)mappingContext.getPersistentEntity(clazz);
        VersionType versionType = null;
        if (persistentEntity != null) {
            versionType = persistentEntity.getVersionType();
        }
        return versionType != null ? versionType : VersionType.EXTERNAL;
    }

    private String[] toArray(List<String> values) {
        String[] valuesAsArray = new String[values.size()];
        return values.toArray(valuesAsArray);
    }

    private boolean hasSeqNoPrimaryTermProperty(@Nullable Class<?> entityClass) {
        if (entityClass == null) {
            return false;
        }
        if (!this.elasticsearchConverter.getMappingContext().hasPersistentEntityFor(entityClass)) {
            return false;
        }
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(entityClass);
        return entity.hasSeqNoPrimaryTermProperty();
    }

    private org.elasticsearch.script.ScriptType getScriptType(@Nullable ScriptType scriptType) {
        if (scriptType == null || ScriptType.INLINE.equals((Object)scriptType)) {
            return org.elasticsearch.script.ScriptType.INLINE;
        }
        return org.elasticsearch.script.ScriptType.STORED;
    }

    @Nullable
    private Script getScript(UpdateQuery query) {
        if (ScriptType.STORED.equals((Object)query.getScriptType()) && query.getScriptName() != null) {
            Map params = Optional.ofNullable(query.getParams()).orElse(new HashMap());
            return new Script(this.getScriptType(ScriptType.STORED), null, query.getScriptName(), params);
        }
        if (ScriptType.INLINE.equals((Object)query.getScriptType()) && query.getScript() != null) {
            Map params = Optional.ofNullable(query.getParams()).orElse(new HashMap());
            return new Script(this.getScriptType(ScriptType.INLINE), query.getLang(), query.getScript(), params);
        }
        return null;
    }
}

