/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.lang.reflect.Field;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.ScriptedField;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchCustomConversions;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchTypeMapper;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentPropertyConverter;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilter;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SeqNoPrimaryTerm;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.format.datetime.DateFormatterRegistrar;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class MappingElasticsearchConverter
implements ElasticsearchConverter,
ApplicationContextAware,
InitializingBean {
    private static final String INCOMPATIBLE_TYPES = "Cannot convert %1$s of type %2$s into an instance of %3$s! Implement a custom Converter<%2$s, %3$s> and register it with the CustomConversions.";
    private static final String INVALID_TYPE_TO_READ = "Expected to read Document %s into type %s but didn't find a PersistentEntity for the latter!";
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingElasticsearchConverter.class);
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;
    private final GenericConversionService conversionService;
    private CustomConversions conversions = new ElasticsearchCustomConversions(Collections.emptyList());
    private final EntityInstantiators instantiators = new EntityInstantiators();
    private final ElasticsearchTypeMapper typeMapper;
    private final ConcurrentHashMap<String, Integer> propertyWarnings = new ConcurrentHashMap();
    private final SpELContext spELContext;

    public MappingElasticsearchConverter(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        this(mappingContext, null);
    }

    public MappingElasticsearchConverter(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, @Nullable GenericConversionService conversionService) {
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.mappingContext = mappingContext;
        this.conversionService = conversionService != null ? conversionService : new DefaultConversionService();
        this.typeMapper = ElasticsearchTypeMapper.create(mappingContext);
        this.spELContext = new SpELContext((PropertyAccessor)new MapAccessor());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.mappingContext instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.mappingContext).setApplicationContext(applicationContext);
        }
    }

    public MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversions(CustomConversions conversions) {
        Assert.notNull((Object)conversions, (String)"CustomConversions must not be null");
        this.conversions = conversions;
    }

    private CustomConversions getConversions() {
        return this.conversions;
    }

    public void afterPropertiesSet() {
        DateFormatterRegistrar.addDateConverters((ConverterRegistry)this.conversionService);
        this.getConversions().registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    public <R> R read(Class<R> type, Document source) {
        ClassTypeInformation typeHint = ClassTypeInformation.from((Class)ClassUtils.getUserClass(type));
        R r = this.read((TypeInformation<R>)typeHint, (Map<String, Object>)source);
        if (r == null) {
            throw new ConversionException("could not convert into object of class " + type);
        }
        return r;
    }

    protected <R> R readEntity(ElasticsearchPersistentEntity<?> entity, Map<String, Object> source) {
        ElasticsearchPersistentEntity<?> targetEntity = this.computeClosestEntity(entity, source);
        DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator(source, this.spELContext);
        MapValueAccessor accessor = new MapValueAccessor(source);
        PreferredConstructor persistenceConstructor = entity.getPersistenceConstructor();
        ParameterValueProvider<ElasticsearchPersistentProperty> propertyValueProvider = persistenceConstructor != null && persistenceConstructor.hasParameters() ? this.getParameterProvider(entity, accessor, (SpELExpressionEvaluator)evaluator) : NoOpParameterValueProvider.INSTANCE;
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(targetEntity);
        Object instance = instantiator.createInstance(targetEntity, propertyValueProvider);
        if (!targetEntity.requiresPropertyPopulation()) {
            return (R)instance;
        }
        ElasticsearchPropertyValueProvider valueProvider = new ElasticsearchPropertyValueProvider(accessor, (SpELExpressionEvaluator)evaluator);
        Object result = this.readProperties(targetEntity, instance, valueProvider);
        if (source instanceof Document) {
            Document document = (Document)source;
            if (document.hasId()) {
                ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)targetEntity.getIdProperty();
                ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(targetEntity.getPropertyAccessor(result), (ConversionService)this.conversionService);
                if (idProperty != null && idProperty.getType().isAssignableFrom(String.class)) {
                    propertyAccessor.setProperty((PersistentProperty)idProperty, (Object)document.getId());
                }
            }
            if (document.hasVersion()) {
                long version = document.getVersion();
                ElasticsearchPersistentProperty versionProperty = targetEntity.getVersionProperty();
                if (versionProperty != null && versionProperty.getType().isAssignableFrom(Long.class)) {
                    Assert.isTrue((version != -1L ? 1 : 0) != 0, (String)"Version in response is -1");
                    targetEntity.getPropertyAccessor(result).setProperty((PersistentProperty)versionProperty, (Object)version);
                }
            }
            if (targetEntity.hasSeqNoPrimaryTermProperty() && document.hasSeqNo() && document.hasPrimaryTerm() && this.isAssignedSeqNo(document.getSeqNo()) && this.isAssignedPrimaryTerm(document.getPrimaryTerm())) {
                SeqNoPrimaryTerm seqNoPrimaryTerm = new SeqNoPrimaryTerm(document.getSeqNo(), document.getPrimaryTerm());
                ElasticsearchPersistentProperty property = targetEntity.getRequiredSeqNoPrimaryTermProperty();
                targetEntity.getPropertyAccessor(result).setProperty((PersistentProperty)property, (Object)seqNoPrimaryTerm);
            }
        }
        if (source instanceof SearchDocument) {
            SearchDocument searchDocument = (SearchDocument)source;
            this.populateScriptFields(result, searchDocument);
        }
        return (R)result;
    }

    private ParameterValueProvider<ElasticsearchPersistentProperty> getParameterProvider(ElasticsearchPersistentEntity<?> entity, MapValueAccessor source, SpELExpressionEvaluator evaluator) {
        ElasticsearchPropertyValueProvider provider = new ElasticsearchPropertyValueProvider(source, evaluator);
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, null);
        return new ConverterAwareSpELExpressionParameterValueProvider(evaluator, (ConversionService)this.conversionService, (ParameterValueProvider<ElasticsearchPersistentProperty>)parameterProvider);
    }

    private boolean isAssignedSeqNo(long seqNo) {
        return seqNo >= 0L;
    }

    private boolean isAssignedPrimaryTerm(long primaryTerm) {
        return primaryTerm > 0L;
    }

    protected <R> R readProperties(ElasticsearchPersistentEntity<?> entity, R instance, ElasticsearchPropertyValueProvider valueProvider) {
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), (ConversionService)this.conversionService);
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            Object value;
            ElasticsearchPersistentProperty prop = (ElasticsearchPersistentProperty)iterator.next();
            if (entity.isConstructorArgument(prop) || !prop.isReadable() || (value = valueProvider.getPropertyValue(prop)) == null) continue;
            accessor.setProperty((PersistentProperty)prop, value);
        }
        return (R)accessor.getBean();
    }

    @Nullable
    protected <R> R readValue(@Nullable Object value, ElasticsearchPersistentProperty property, TypeInformation<?> type) {
        String propertyName;
        String key;
        int count;
        if (value == null) {
            return null;
        }
        Class rawType = type.getType();
        if (property.hasPropertyConverter()) {
            value = this.propertyConverterRead(property, value);
        } else if (TemporalAccessor.class.isAssignableFrom(property.getType()) && !this.getConversions().hasCustomReadTarget(value.getClass(), rawType) && (count = this.propertyWarnings.computeIfAbsent(key = (propertyName = property.getOwner().getType().getSimpleName() + '.' + property.getName()) + "-read", k -> 0).intValue()) < 5) {
            LOGGER.warn("Type {} of property {} is a TemporalAccessor class but has neither a @Field annotation defining the date type nor a registered converter for reading! It cannot be mapped from a complex object in Elasticsearch!", (Object)property.getType().getSimpleName(), (Object)propertyName);
            this.propertyWarnings.put(key, count + 1);
        }
        return (R)this.readValue(value, type);
    }

    @Nullable
    private <T> T readValue(Object value, TypeInformation<?> type) {
        Class rawType = type.getType();
        if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
            return (T)this.conversionService.convert(value, rawType);
        }
        if (value instanceof List) {
            return (T)this.readCollectionOrArray(type, (List)value);
        }
        if (value.getClass().isArray()) {
            return (T)this.readCollectionOrArray(type, Arrays.asList((Object[])value));
        }
        if (value instanceof Map) {
            return (T)this.read(type, (Map)value);
        }
        return (T)this.getPotentiallyConvertedSimpleRead(value, rawType);
    }

    @Nullable
    private <R> R read(TypeInformation<R> type, Map<String, Object> source) {
        Assert.notNull(source, (String)"Source must not be null!");
        TypeInformation typeToUse = this.typeMapper.readType(source, type);
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(source.getClass(), rawType)) {
            return (R)this.conversionService.convert(source, rawType);
        }
        if (Document.class.isAssignableFrom(rawType)) {
            return (R)source;
        }
        if (typeToUse.isMap()) {
            return this.readMap(typeToUse, source);
        }
        if (typeToUse.equals(ClassTypeInformation.OBJECT)) {
            return (R)source;
        }
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        if (entity == null) {
            throw new MappingException(String.format(INVALID_TYPE_TO_READ, source, typeToUse.getType()));
        }
        return this.readEntity(entity, source);
    }

    private Object propertyConverterRead(ElasticsearchPersistentProperty property, Object source) {
        ElasticsearchPersistentPropertyConverter propertyConverter = Objects.requireNonNull(property.getPropertyConverter());
        if (source instanceof String[]) {
            source = Arrays.asList((String[])source);
        }
        source = source instanceof List ? source.stream().map(it -> this.convertOnRead(propertyConverter, it)).collect(Collectors.toList()) : (source instanceof Set ? ((Set)source).stream().map(it -> this.convertOnRead(propertyConverter, it)).collect(Collectors.toSet()) : this.convertOnRead(propertyConverter, source));
        return source;
    }

    private Object convertOnRead(ElasticsearchPersistentPropertyConverter propertyConverter, Object source) {
        if (String.class.isAssignableFrom(source.getClass())) {
            source = propertyConverter.read((String)source);
        }
        return source;
    }

    @Nullable
    private Object readCollectionOrArray(TypeInformation<?> targetType, Collection<?> source) {
        Collection<Object> items;
        Assert.notNull(targetType, (String)"Target type must not be null!");
        Class collectionType = targetType.isSubTypeOf(Collection.class) ? targetType.getType() : List.class;
        ClassTypeInformation componentType = targetType.getComponentType() != null ? targetType.getComponentType() : ClassTypeInformation.OBJECT;
        Class rawComponentType = componentType.getType();
        Collection collection = items = targetType.getType().isArray() ? new ArrayList(source.size()) : CollectionFactory.createCollection((Class)collectionType, (Class)rawComponentType, (int)source.size());
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(items, targetType);
        }
        for (Object element : source) {
            if (element instanceof Map) {
                items.add(this.read((TypeInformation)componentType, (Map)element));
                continue;
            }
            if (!Object.class.equals((Object)rawComponentType) && element instanceof Collection && !rawComponentType.isArray() && !ClassUtils.isAssignable(Iterable.class, (Class)rawComponentType)) {
                throw new MappingException(String.format(INCOMPATIBLE_TYPES, element, element.getClass(), rawComponentType));
            }
            if (element instanceof List) {
                items.add(this.readCollectionOrArray((TypeInformation<?>)componentType, (Collection)element));
                continue;
            }
            items.add(this.getPotentiallyConvertedSimpleRead(element, rawComponentType));
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    private <R> R readMap(TypeInformation<?> type, Map<String, Object> source) {
        Assert.notNull(source, (String)"Document must not be null!");
        Class mapType = this.typeMapper.readType(source, type).getType();
        TypeInformation keyType = type.getComponentType();
        TypeInformation valueType = type.getMapValueType();
        Class rawKeyType = keyType != null ? keyType.getType() : null;
        Class rawValueType = valueType != null ? valueType.getType() : null;
        Map map = CollectionFactory.createMap((Class)mapType, (Class)rawKeyType, (int)source.keySet().size());
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            TypeInformation defaultedValueType;
            if (this.typeMapper.isTypeKey(entry.getKey())) continue;
            Object key = entry.getKey();
            if (rawKeyType != null && !rawKeyType.isAssignableFrom(key.getClass())) {
                key = this.conversionService.convert(key, rawKeyType);
            }
            Object value = entry.getValue();
            Object object = defaultedValueType = valueType != null ? valueType : ClassTypeInformation.OBJECT;
            if (value instanceof Map) {
                map.put(key, this.read(defaultedValueType, (Map)value));
                continue;
            }
            if (value instanceof List) {
                map.put(key, this.readCollectionOrArray((TypeInformation<?>)(valueType != null ? valueType : ClassTypeInformation.LIST), (List)value));
                continue;
            }
            map.put(key, this.getPotentiallyConvertedSimpleRead(value, rawValueType));
        }
        return (R)map;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleRead(@Nullable Object value, TypeInformation<?> targetType) {
        return this.getPotentiallyConvertedSimpleRead(value, targetType.getType());
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (target == null || value == null || ClassUtils.isAssignableValue(target, (Object)value)) {
            return value;
        }
        if (this.getConversions().hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.conversionService.convert(value, target);
    }

    private <T> void populateScriptFields(T result, SearchDocument searchDocument) {
        Map<String, List<Object>> fields = searchDocument.getFields();
        if (!fields.isEmpty()) {
            for (Field field : result.getClass().getDeclaredFields()) {
                String name;
                Object value;
                ScriptedField scriptedField = field.getAnnotation(ScriptedField.class);
                if (scriptedField == null || (value = searchDocument.getFieldValue(name = scriptedField.name().isEmpty() ? field.getName() : scriptedField.name())) == null) continue;
                field.setAccessible(true);
                try {
                    field.set(result, value);
                }
                catch (IllegalArgumentException e) {
                    throw new MappingException("failed to set scripted field: " + name + " with value: " + value, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new MappingException("failed to access scripted field: " + name, (Throwable)e);
                }
            }
        }
    }

    public void write(Object source, Document sink) {
        Assert.notNull((Object)source, (String)"source to map must not be null");
        if (source instanceof Map) {
            sink.putAll((Map)source);
            return;
        }
        Class entityType = ClassUtils.getUserClass(source.getClass());
        ClassTypeInformation typeInformation = ClassTypeInformation.from((Class)entityType);
        if (this.requiresTypeHint(entityType)) {
            this.typeMapper.writeType((TypeInformation)typeInformation, sink);
        }
        this.writeInternal(source, (Map<String, Object>)sink, (TypeInformation<?>)typeInformation);
    }

    protected void writeInternal(@Nullable Object source, Map<String, Object> sink, @Nullable TypeInformation<?> typeInformation) {
        if (null == source) {
            return;
        }
        Class<?> entityType = source.getClass();
        Optional customTarget = this.conversions.getCustomWriteTarget(entityType, Map.class);
        if (customTarget.isPresent()) {
            Map result = (Map)this.conversionService.convert(source, Map.class);
            if (result != null) {
                sink.putAll(result);
            }
            return;
        }
        if (Map.class.isAssignableFrom(entityType)) {
            this.writeMapInternal((Map)source, sink, (TypeInformation<?>)ClassTypeInformation.MAP);
            return;
        }
        if (Collection.class.isAssignableFrom(entityType)) {
            this.writeCollectionInternal((Collection)source, (TypeInformation<?>)ClassTypeInformation.LIST, (Collection)((Object)sink));
            return;
        }
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityType);
        this.addCustomTypeKeyIfNecessary(source, sink, typeInformation);
        this.writeInternal(source, sink, entity);
    }

    protected void writeInternal(@Nullable Object source, Map<String, Object> sink, @Nullable ElasticsearchPersistentEntity<?> entity) {
        if (source == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + source.getClass().getName());
        }
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        this.writeProperties(entity, accessor, new MapValueAccessor(sink));
    }

    protected void writeProperties(ElasticsearchPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, MapValueAccessor sink) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            ElasticsearchPersistentProperty property = (ElasticsearchPersistentProperty)iterator.next();
            if (!property.isWritable()) continue;
            Object value = accessor.getProperty((PersistentProperty)property);
            if (value == null) {
                if (!property.storeNullValue()) continue;
                sink.set(property, null);
                continue;
            }
            if (property.hasPropertyConverter()) {
                value = this.propertyConverterWrite(property, value);
                sink.set(property, value);
                continue;
            }
            if (TemporalAccessor.class.isAssignableFrom(property.getActualType()) && !this.getConversions().hasCustomWriteTarget(value.getClass())) {
                String propertyName = entity.getType().getSimpleName() + '.' + property.getName();
                String key = propertyName + "-write";
                int count = this.propertyWarnings.computeIfAbsent(key, k -> 0);
                if (count >= 5) continue;
                LOGGER.warn("Type {} of property {} is a TemporalAccessor class but has neither a @Field annotation defining the date type nor a registered converter for writing! It will be mapped to a complex object in Elasticsearch!", (Object)property.getType().getSimpleName(), (Object)propertyName);
                this.propertyWarnings.put(key, count + 1);
                continue;
            }
            if (!this.isSimpleType(value)) {
                this.writeProperty(property, value, sink);
                continue;
            }
            Object writeSimpleValue = this.getPotentiallyConvertedSimpleWrite(value, Object.class);
            if (writeSimpleValue == null) continue;
            sink.set(property, writeSimpleValue);
        }
    }

    private Object propertyConverterWrite(ElasticsearchPersistentProperty property, Object value) {
        ElasticsearchPersistentPropertyConverter propertyConverter = Objects.requireNonNull(property.getPropertyConverter());
        value = value instanceof List ? ((List)value).stream().map(propertyConverter::write).collect(Collectors.toList()) : (value instanceof Set ? ((Set)value).stream().map(propertyConverter::write).collect(Collectors.toSet()) : propertyConverter.write(value));
        return value;
    }

    protected void writeProperty(ElasticsearchPersistentProperty property, Object value, MapValueAccessor sink) {
        Optional customWriteTarget = this.getConversions().getCustomWriteTarget(value.getClass());
        if (customWriteTarget.isPresent()) {
            Class writeTarget = (Class)customWriteTarget.get();
            sink.set(property, this.conversionService.convert(value, writeTarget));
            return;
        }
        ClassTypeInformation valueType = ClassTypeInformation.from(value.getClass());
        TypeInformation type = property.getTypeInformation();
        if (valueType.isCollectionLike()) {
            List<Object> collectionInternal = this.createCollection(MappingElasticsearchConverter.asCollection(value), property);
            sink.set(property, collectionInternal);
            return;
        }
        if (valueType.isMap()) {
            Map<String, Object> mapDbObj = this.createMap((Map)value, property);
            sink.set(property, mapDbObj);
            return;
        }
        Optional basicTargetType = this.conversions.getCustomWriteTarget(value.getClass());
        if (basicTargetType.isPresent()) {
            sink.set(property, this.conversionService.convert(value, (Class)basicTargetType.get()));
            return;
        }
        ElasticsearchPersistentEntity entity = valueType.isSubTypeOf(property.getType()) ? (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(value.getClass()) : (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        Object existingValue = sink.get(property);
        Map<String, Object> document = existingValue instanceof Map ? (Map)existingValue : Document.create();
        this.addCustomTypeKeyIfNecessary(value, document, (TypeInformation<?>)ClassTypeInformation.from((Class)property.getRawType()));
        this.writeInternal(value, document, entity);
        sink.set(property, document);
    }

    protected List<Object> createCollection(Collection<?> collection, ElasticsearchPersistentProperty property) {
        return this.writeCollectionInternal(collection, property.getTypeInformation(), new ArrayList(collection.size()));
    }

    protected Map<String, Object> createMap(Map<?, ?> map, ElasticsearchPersistentProperty property) {
        Assert.notNull(map, (String)"Given map must not be null!");
        Assert.notNull((Object)property, (String)"PersistentProperty must not be null!");
        return this.writeMapInternal(map, new LinkedHashMap<String, Object>(map.size()), property.getTypeInformation());
    }

    protected Map<String, Object> writeMapInternal(Map<?, ?> source, Map<String, Object> sink, TypeInformation<?> propertyType) {
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.isSimpleType(key.getClass())) {
                String simpleKey = this.potentiallyConvertMapKey(key);
                if (value == null || this.isSimpleType(value)) {
                    sink.put(simpleKey, this.getPotentiallyConvertedSimpleWrite(value, Object.class));
                    continue;
                }
                if (value instanceof Collection || value.getClass().isArray()) {
                    sink.put(simpleKey, this.writeCollectionInternal(MappingElasticsearchConverter.asCollection(value), propertyType.getMapValueType(), new ArrayList()));
                    continue;
                }
                Document document = Document.create();
                ClassTypeInformation valueTypeInfo = propertyType.isMap() ? propertyType.getMapValueType() : ClassTypeInformation.OBJECT;
                this.writeInternal(value, (Map<String, Object>)document, (TypeInformation<?>)valueTypeInfo);
                sink.put(simpleKey, document);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return sink;
    }

    private List<Object> writeCollectionInternal(Collection<?> source, @Nullable TypeInformation<?> type, Collection<?> sink) {
        List<Object> collection;
        TypeInformation componentType = null;
        List<Object> list = collection = sink instanceof List ? (List<Object>)sink : new ArrayList(sink);
        if (type != null) {
            componentType = type.getComponentType();
        }
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                collection.add(this.getPotentiallyConvertedSimpleWrite(element, componentType != null ? componentType.getType() : Object.class));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                collection.add(this.writeCollectionInternal(MappingElasticsearchConverter.asCollection(element), componentType, new ArrayList()));
                continue;
            }
            Document document = Document.create();
            this.writeInternal(element, (Map<String, Object>)document, componentType);
            collection.add(document);
        }
        return collection;
    }

    private String potentiallyConvertMapKey(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        if (this.conversions.hasCustomWriteTarget(key.getClass(), String.class)) {
            Object potentiallyConvertedSimpleWrite = this.getPotentiallyConvertedSimpleWrite(key, Object.class);
            if (potentiallyConvertedSimpleWrite == null) {
                return key.toString();
            }
            return (String)potentiallyConvertedSimpleWrite;
        }
        return key.toString();
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(@Nullable Object value, @Nullable Class<?> typeHint) {
        if (value == null) {
            return null;
        }
        if (typeHint != null && Object.class != typeHint && this.conversionService.canConvert(value.getClass(), typeHint) && (value = this.conversionService.convert(value, typeHint)) == null) {
            return null;
        }
        Optional customTarget = this.conversions.getCustomWriteTarget(value.getClass());
        if (customTarget.isPresent()) {
            return this.conversionService.convert(value, (Class)customTarget.get());
        }
        if (ObjectUtils.isArray((Object)value)) {
            if (value instanceof byte[]) {
                return value;
            }
            return MappingElasticsearchConverter.asCollection(value);
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    @Nullable
    @Deprecated
    protected Object getWriteSimpleValue(Object value) {
        Optional customTarget = this.getConversions().getCustomWriteTarget(value.getClass());
        if (customTarget.isPresent()) {
            return this.conversionService.convert(value, (Class)customTarget.get());
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    @Deprecated
    protected Object getWriteComplexValue(ElasticsearchPersistentProperty property, TypeInformation<?> typeHint, Object value) {
        Document document = Document.create();
        this.writeInternal(value, (Map<String, Object>)document, property.getTypeInformation());
        return document;
    }

    protected void addCustomTypeKeyIfNecessary(Object source, Map<String, Object> sink, @Nullable TypeInformation<?> type) {
        boolean notTheSameClass;
        TypeInformation actualType;
        Class reference = type == null ? Object.class : ((actualType = type.getActualType()) == null ? Object.class : actualType.getType());
        Class valueType = ClassUtils.getUserClass(source.getClass());
        boolean bl = notTheSameClass = !valueType.equals(reference);
        if (notTheSameClass) {
            this.typeMapper.writeType(valueType, sink);
        }
    }

    public boolean requiresTypeHint(Class<?> type) {
        return !this.isSimpleType(type) && !ClassUtils.isAssignable(Collection.class, type) && !this.conversions.hasCustomWriteTarget(type, Document.class);
    }

    private ElasticsearchPersistentEntity<?> computeClosestEntity(ElasticsearchPersistentEntity<?> entity, Map<String, Object> source) {
        TypeInformation typeToUse = this.typeMapper.readType(source);
        if (typeToUse == null) {
            return entity;
        }
        if (!(entity.getTypeInformation().getType().isInterface() || entity.getTypeInformation().isCollectionLike() || entity.getTypeInformation().isMap() || ClassUtils.isAssignableValue((Class)entity.getType(), (Object)typeToUse.getType()))) {
            return entity;
        }
        return (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToUse);
    }

    private boolean isSimpleType(Object value) {
        return this.isSimpleType(value.getClass());
    }

    private boolean isSimpleType(Class<?> type) {
        return !Map.class.isAssignableFrom(type) && this.getConversions().isSimpleType(type);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    @Override
    public void updateQuery(Query query, @Nullable Class<?> domainClass) {
        Assert.notNull((Object)query, (String)"query must not be null");
        if (domainClass != null) {
            this.updateFieldsAndSourceFilter(query, domainClass);
            if (query instanceof CriteriaQuery) {
                this.updateCriteriaQuery((CriteriaQuery)query, domainClass);
            }
        }
    }

    private void updateFieldsAndSourceFilter(Query query, Class<?> domainClass) {
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        if (persistentEntity != null) {
            SourceFilter sourceFilter;
            List<String> fields = query.getFields();
            if (!fields.isEmpty()) {
                query.setFields(this.updateFieldNames(fields, persistentEntity));
            }
            if ((sourceFilter = query.getSourceFilter()) != null) {
                String[] includes = null;
                String[] excludes = null;
                if (sourceFilter.getIncludes() != null) {
                    includes = this.updateFieldNames(Arrays.asList(sourceFilter.getIncludes()), persistentEntity).toArray(new String[0]);
                }
                if (sourceFilter.getExcludes() != null) {
                    excludes = this.updateFieldNames(Arrays.asList(sourceFilter.getExcludes()), persistentEntity).toArray(new String[0]);
                }
                query.addSourceFilter(new FetchSourceFilter(includes, excludes));
            }
        }
    }

    private List<String> updateFieldNames(List<String> fields, ElasticsearchPersistentEntity<?> persistentEntity) {
        return fields.stream().map(fieldName -> {
            ElasticsearchPersistentProperty persistentProperty = (ElasticsearchPersistentProperty)persistentEntity.getPersistentProperty((String)fieldName);
            return persistentProperty != null ? persistentProperty.getFieldName() : fieldName;
        }).collect(Collectors.toList());
    }

    private void updateCriteriaQuery(CriteriaQuery criteriaQuery, Class<?> domainClass) {
        Assert.notNull((Object)criteriaQuery, (String)"criteriaQuery must not be null");
        Assert.notNull(domainClass, (String)"domainClass must not be null");
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        if (persistentEntity != null) {
            for (Criteria chainedCriteria : criteriaQuery.getCriteria().getCriteriaChain()) {
                this.updateCriteria(chainedCriteria, persistentEntity);
            }
            for (Criteria subCriteria : criteriaQuery.getCriteria().getSubCriteria()) {
                for (Criteria chainedCriteria : subCriteria.getCriteriaChain()) {
                    this.updateCriteria(chainedCriteria, persistentEntity);
                }
            }
        }
    }

    private void updateCriteria(Criteria criteria, ElasticsearchPersistentEntity<?> persistentEntity) {
        org.springframework.data.elasticsearch.core.query.Field field = criteria.getField();
        if (field == null) {
            return;
        }
        CharSequence[] fieldNames = field.getName().split("\\.");
        ElasticsearchPersistentEntity currentEntity = persistentEntity;
        ElasticsearchPersistentProperty persistentProperty = null;
        int propertyCount = 0;
        boolean isNested = false;
        for (int i = 0; i < fieldNames.length; ++i) {
            persistentProperty = (ElasticsearchPersistentProperty)currentEntity.getPersistentProperty(fieldNames[i]);
            if (persistentProperty != null) {
                ++propertyCount;
                fieldNames[i] = persistentProperty.getFieldName();
                org.springframework.data.elasticsearch.annotations.Field fieldAnnotation = (org.springframework.data.elasticsearch.annotations.Field)persistentProperty.findAnnotation(org.springframework.data.elasticsearch.annotations.Field.class);
                if (fieldAnnotation != null && fieldAnnotation.type() == FieldType.Nested) {
                    isNested = true;
                }
                try {
                    currentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(persistentProperty.getActualType());
                }
                catch (Exception e) {
                    currentEntity = null;
                }
            }
            if (currentEntity == null) break;
        }
        field.setName(String.join((CharSequence)".", fieldNames));
        if (propertyCount > 1 && isNested) {
            List<CharSequence> propertyNames = Arrays.asList(fieldNames);
            field.setPath(String.join((CharSequence)".", propertyNames.subList(0, propertyCount - 1)));
        }
        if (persistentProperty != null) {
            org.springframework.data.elasticsearch.annotations.Field fieldAnnotation;
            if (persistentProperty.hasPropertyConverter()) {
                ElasticsearchPersistentPropertyConverter propertyConverter = Objects.requireNonNull(persistentProperty.getPropertyConverter());
                criteria.getQueryCriteriaEntries().forEach(criteriaEntry -> {
                    Object value = criteriaEntry.getValue();
                    if (value.getClass().isArray()) {
                        Object[] objects = (Object[])value;
                        for (int i = 0; i < objects.length; ++i) {
                            objects[i] = propertyConverter.write(objects[i]);
                        }
                    } else {
                        criteriaEntry.setValue(propertyConverter.write(value));
                    }
                });
            }
            if ((fieldAnnotation = (org.springframework.data.elasticsearch.annotations.Field)persistentProperty.findAnnotation(org.springframework.data.elasticsearch.annotations.Field.class)) != null) {
                field.setFieldType(fieldAnnotation.type());
            }
        }
    }

    static enum NoOpParameterValueProvider implements ParameterValueProvider<ElasticsearchPersistentProperty>
    {
        INSTANCE;


        public <T> T getParameterValue(PreferredConstructor.Parameter<T, ElasticsearchPersistentProperty> parameter) {
            return null;
        }
    }

    private class ConverterAwareSpELExpressionParameterValueProvider
    extends SpELExpressionParameterValueProvider<ElasticsearchPersistentProperty> {
        public ConverterAwareSpELExpressionParameterValueProvider(SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<ElasticsearchPersistentProperty> delegate) {
            super(evaluator, conversionService, delegate);
        }

        protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, ElasticsearchPersistentProperty> parameter) {
            return (T)MappingElasticsearchConverter.this.readValue(object, parameter.getType());
        }
    }

    class ElasticsearchPropertyValueProvider
    implements PropertyValueProvider<ElasticsearchPersistentProperty> {
        final MapValueAccessor accessor;
        final SpELExpressionEvaluator evaluator;

        ElasticsearchPropertyValueProvider(MapValueAccessor accessor, SpELExpressionEvaluator evaluator) {
            this.accessor = accessor;
            this.evaluator = evaluator;
        }

        public <T> T getPropertyValue(ElasticsearchPersistentProperty property) {
            Object value;
            String expression = property.getSpelExpression();
            Object object = value = expression != null ? this.evaluator.evaluate(expression) : this.accessor.get(property);
            if (value == null) {
                return null;
            }
            return (T)MappingElasticsearchConverter.this.readValue(value, property, property.getTypeInformation());
        }
    }

    static class MapValueAccessor {
        final Map<String, Object> target;

        MapValueAccessor(Map<String, Object> target) {
            this.target = target;
        }

        @Nullable
        public Object get(ElasticsearchPersistentProperty property) {
            String fieldName = property.getFieldName();
            if (this.target instanceof Document) {
                Document document = (Document)this.target;
                if (property.isIdProperty() && document.hasId()) {
                    Object id = null;
                    if (!fieldName.contains(".")) {
                        id = this.target.get(fieldName);
                    }
                    return id != null ? id : document.getId();
                }
                if (property.isVersionProperty() && document.hasVersion()) {
                    return document.getVersion();
                }
            }
            if (!fieldName.contains(".")) {
                return this.target.get(fieldName);
            }
            Iterator<String> parts = Arrays.asList(fieldName.split("\\.")).iterator();
            Map<String, Object> source = this.target;
            Object result = null;
            while (parts.hasNext()) {
                result = source.get(parts.next());
                if (!parts.hasNext()) continue;
                source = this.getAsMap(result);
            }
            return result;
        }

        public void set(ElasticsearchPersistentProperty property, @Nullable Object value) {
            if (value != null) {
                if (property.isIdProperty()) {
                    ((Document)this.target).setId(value.toString());
                }
                if (property.isVersionProperty()) {
                    ((Document)this.target).setVersion((Long)value);
                }
            }
            this.target.put(property.getFieldName(), value);
        }

        private Map<String, Object> getAsMap(Object result) {
            if (result instanceof Map) {
                return (Map)result;
            }
            throw new IllegalArgumentException(String.format("%s is not a Map.", result));
        }
    }
}

