/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.convert.AbstractPropertyValueConverter;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchDateConverter;
import org.springframework.data.mapping.PersistentProperty;

public class DatePropertyValueConverter
extends AbstractPropertyValueConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatePropertyValueConverter.class);
    private final List<ElasticsearchDateConverter> dateConverters;

    public DatePropertyValueConverter(PersistentProperty<?> property, List<ElasticsearchDateConverter> dateConverters) {
        super(property);
        this.dateConverters = dateConverters;
    }

    @Override
    public Object read(Object value) {
        String s = value.toString();
        for (ElasticsearchDateConverter dateConverter : this.dateConverters) {
            try {
                return dateConverter.parse(s);
            }
            catch (Exception e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
        }
        throw new ConversionException(String.format("Unable to convert value '%s' to %s for property '%s'", s, this.getProperty().getActualType().getTypeName(), this.getProperty().getName()));
    }

    @Override
    public Object write(Object value) {
        try {
            return this.dateConverters.get(0).format((Date)value);
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Unable to convert value '%s' of property '%s'", value, this.getProperty().getName()), e);
        }
    }
}

