/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.util.Arrays;
import org.springframework.util.Assert;

public class IndexCoordinates {
    public static final String TYPE = "_doc";
    private final String[] indexNames;

    public static IndexCoordinates of(String ... indexNames) {
        Assert.notNull((Object)indexNames, (String)"indexNames must not be null");
        return new IndexCoordinates(indexNames);
    }

    private IndexCoordinates(String[] indexNames) {
        Assert.notEmpty((Object[])indexNames, (String)"indexNames may not be null or empty");
        this.indexNames = indexNames;
    }

    public String getIndexName() {
        return this.indexNames[0];
    }

    public String[] getIndexNames() {
        return Arrays.copyOf(this.indexNames, this.indexNames.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexCoordinates that = (IndexCoordinates)o;
        return Arrays.equals(this.indexNames, that.indexNames);
    }

    public int hashCode() {
        return Arrays.hashCode(this.indexNames);
    }

    public String toString() {
        return "IndexCoordinates{indexNames=" + Arrays.toString(this.indexNames) + '}';
    }
}

