/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.DistanceUnit;
import co.elastic.clients.elasticsearch._types.GeoDistanceType;
import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SortMode;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch._types.mapping.FieldType;
import co.elastic.clients.elasticsearch.core.search.BoundaryScanner;
import co.elastic.clients.elasticsearch.core.search.BuiltinHighlighterType;
import co.elastic.clients.elasticsearch.core.search.HighlighterEncoder;
import co.elastic.clients.elasticsearch.core.search.HighlighterFragmenter;
import co.elastic.clients.elasticsearch.core.search.HighlighterOrder;
import co.elastic.clients.elasticsearch.core.search.HighlighterTagsSchema;
import co.elastic.clients.elasticsearch.core.search.HighlighterType;
import co.elastic.clients.elasticsearch.core.search.ScoreMode;
import java.time.Duration;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.query.GeoDistanceOrder;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.Order;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.lang.Nullable;

final class TypeUtils {
    TypeUtils() {
    }

    @Nullable
    static BoundaryScanner boundaryScanner(@Nullable String value) {
        if (value != null) {
            switch (value.toLowerCase()) {
                case "chars": {
                    return BoundaryScanner.Chars;
                }
                case "sentence": {
                    return BoundaryScanner.Sentence;
                }
                case "word": {
                    return BoundaryScanner.Word;
                }
            }
            return null;
        }
        return null;
    }

    static Conflicts conflicts(ReindexRequest.Conflicts conflicts) {
        switch (conflicts) {
            case ABORT: {
                return Conflicts.Abort;
            }
            case PROCEED: {
                return Conflicts.Proceed;
            }
        }
        throw new IllegalArgumentException("Cannot map conflicts value " + conflicts.name());
    }

    @Nullable
    static DistanceUnit distanceUnit(String unit) {
        switch (unit.toLowerCase()) {
            case "in": 
            case "inch": {
                return DistanceUnit.Inches;
            }
            case "yd": 
            case "yards": {
                return DistanceUnit.Yards;
            }
            case "ft": 
            case "feet": {
                return DistanceUnit.Feet;
            }
            case "km": 
            case "kilometers": {
                return DistanceUnit.Kilometers;
            }
            case "nm": 
            case "nmi": {
                return DistanceUnit.NauticMiles;
            }
            case "mm": 
            case "millimeters": {
                return DistanceUnit.Millimeters;
            }
            case "cm": 
            case "centimeters": {
                return DistanceUnit.Centimeters;
            }
            case "mi": 
            case "miles": {
                return DistanceUnit.Miles;
            }
            case "m": 
            case "meters": {
                return DistanceUnit.Meters;
            }
        }
        return null;
    }

    @Nullable
    static FieldType fieldType(String type) {
        for (FieldType fieldType : FieldType.values()) {
            if (!fieldType.jsonValue().equals(type)) continue;
            return fieldType;
        }
        return null;
    }

    @Nullable
    static GeoDistanceType geoDistanceType(GeoDistanceOrder.DistanceType distanceType) {
        switch (distanceType) {
            case arc: {
                return GeoDistanceType.Arc;
            }
            case plane: {
                return GeoDistanceType.Plane;
            }
        }
        return null;
    }

    @Nullable
    static HighlighterFragmenter highlighterFragmenter(@Nullable String value) {
        if (value != null) {
            switch (value.toLowerCase()) {
                case "simple": {
                    return HighlighterFragmenter.Simple;
                }
                case "span": {
                    return HighlighterFragmenter.Span;
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    static HighlighterOrder highlighterOrder(@Nullable String value) {
        if (value != null && "score".equals(value.toLowerCase())) {
            return HighlighterOrder.Score;
        }
        return null;
    }

    @Nullable
    static HighlighterType highlighterType(@Nullable String value) {
        if (value != null) {
            switch (value.toLowerCase()) {
                case "unified": {
                    return HighlighterType.of(b -> b.builtin(BuiltinHighlighterType.Unified));
                }
                case "plain": {
                    return HighlighterType.of(b -> b.builtin(BuiltinHighlighterType.Plain));
                }
                case "fvh": {
                    return HighlighterType.of(b -> b.builtin(BuiltinHighlighterType.FastVector));
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    static HighlighterEncoder highlighterEncoder(@Nullable String value) {
        if (value != null) {
            switch (value.toLowerCase()) {
                case "default": {
                    return HighlighterEncoder.Default;
                }
                case "html": {
                    return HighlighterEncoder.Html;
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    static HighlighterTagsSchema highlighterTagsSchema(@Nullable String value) {
        if (value != null && "styled".equals(value.toLowerCase())) {
            return HighlighterTagsSchema.Styled;
        }
        return null;
    }

    @Nullable
    static OpType opType(@Nullable IndexQuery.OpType opType) {
        if (opType != null) {
            switch (opType) {
                case INDEX: {
                    return OpType.Index;
                }
                case CREATE: {
                    return OpType.Create;
                }
            }
        }
        return null;
    }

    static Refresh refresh(@Nullable RefreshPolicy refreshPolicy) {
        if (refreshPolicy == null) {
            return Refresh.False;
        }
        switch (refreshPolicy) {
            case IMMEDIATE: {
                return Refresh.True;
            }
            case WAIT_UNTIL: {
                return Refresh.WaitFor;
            }
        }
        return Refresh.False;
    }

    @Nullable
    static UpdateResponse.Result result(@Nullable Result result) {
        if (result == null) {
            return null;
        }
        switch (result) {
            case Created: {
                return UpdateResponse.Result.CREATED;
            }
            case Updated: {
                return UpdateResponse.Result.UPDATED;
            }
            case Deleted: {
                return UpdateResponse.Result.DELETED;
            }
            case NotFound: {
                return UpdateResponse.Result.NOT_FOUND;
            }
            case NoOp: {
                return UpdateResponse.Result.NOOP;
            }
        }
        return null;
    }

    @Nullable
    static ScoreMode scoreMode(@Nullable RescorerQuery.ScoreMode scoreMode) {
        if (scoreMode == null) {
            return null;
        }
        switch (scoreMode) {
            case Default: {
                return null;
            }
            case Avg: {
                return ScoreMode.Avg;
            }
            case Max: {
                return ScoreMode.Max;
            }
            case Min: {
                return ScoreMode.Min;
            }
            case Total: {
                return ScoreMode.Total;
            }
            case Multiply: {
                return ScoreMode.Multiply;
            }
        }
        return null;
    }

    @Nullable
    static SearchType searchType(@Nullable Query.SearchType searchType) {
        if (searchType == null) {
            return null;
        }
        switch (searchType) {
            case QUERY_THEN_FETCH: {
                return SearchType.QueryThenFetch;
            }
            case DFS_QUERY_THEN_FETCH: {
                return SearchType.DfsQueryThenFetch;
            }
        }
        return null;
    }

    @Nullable
    static SortMode sortMode(Order.Mode mode) {
        switch (mode) {
            case min: {
                return SortMode.Min;
            }
            case max: {
                return SortMode.Max;
            }
            case median: {
                return SortMode.Median;
            }
            case avg: {
                return SortMode.Avg;
            }
        }
        return null;
    }

    @Nullable
    static Time time(@Nullable Duration duration) {
        if (duration == null) {
            return null;
        }
        return Time.of(t -> t.time(duration.toMillis() + "ms"));
    }

    @Nullable
    static String timeStringMs(@Nullable Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toMillis() + "ms";
    }

    @Nullable
    static VersionType versionType(@Nullable Document.VersionType versionType) {
        if (versionType != null) {
            switch (versionType) {
                case INTERNAL: {
                    return VersionType.Internal;
                }
                case EXTERNAL: {
                    return VersionType.External;
                }
                case EXTERNAL_GTE: {
                    return VersionType.ExternalGte;
                }
                case FORCE: {
                    return VersionType.Force;
                }
            }
        }
        return null;
    }

    static Integer waitForActiveShardsCount(@Nullable String value) {
        if (value == null) {
            return -2;
        }
        if ("all".equals(value.toUpperCase())) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegale value for waitForActiveShards" + value);
        }
    }
}

