/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.data.elasticsearch.core.reindex.ReindexResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveDocumentOperations {
    default public <T> Mono<T> save(Mono<? extends T> entityPublisher) {
        Assert.notNull(entityPublisher, (String)"EntityPublisher must not be null!");
        return entityPublisher.flatMap(this::save);
    }

    default public <T> Mono<T> save(Mono<? extends T> entityPublisher, IndexCoordinates index) {
        Assert.notNull(entityPublisher, (String)"EntityPublisher must not be null!");
        return entityPublisher.flatMap(it -> this.save(it, index));
    }

    public <T> Mono<T> save(T var1);

    public <T> Mono<T> save(T var1, IndexCoordinates var2);

    default public <T> Flux<T> saveAll(Iterable<T> entities, Class<T> clazz) {
        ArrayList entityList = new ArrayList();
        entities.forEach(entityList::add);
        return this.saveAll(Mono.just(entityList), clazz);
    }

    default public <T> Flux<T> saveAll(Iterable<T> entities, IndexCoordinates index) {
        ArrayList entityList = new ArrayList();
        entities.forEach(entityList::add);
        return this.saveAll(Mono.just(entityList), index);
    }

    public <T> Flux<T> saveAll(Mono<? extends Collection<? extends T>> var1, Class<T> var2);

    public <T> Flux<T> saveAll(Mono<? extends Collection<? extends T>> var1, IndexCoordinates var2);

    public <T> Flux<MultiGetItem<T>> multiGet(Query var1, Class<T> var2);

    public <T> Flux<MultiGetItem<T>> multiGet(Query var1, Class<T> var2, IndexCoordinates var3);

    default public Mono<Void> bulkUpdate(List<UpdateQuery> queries, IndexCoordinates index) {
        return this.bulkUpdate(queries, BulkOptions.defaultOptions(), index);
    }

    public Mono<Void> bulkUpdate(List<UpdateQuery> var1, BulkOptions var2, IndexCoordinates var3);

    public <T> Mono<T> get(String var1, Class<T> var2);

    public <T> Mono<T> get(String var1, Class<T> var2, IndexCoordinates var3);

    public Mono<Boolean> exists(String var1, Class<?> var2);

    public Mono<Boolean> exists(String var1, IndexCoordinates var2);

    public Mono<String> delete(Object var1);

    public Mono<String> delete(Object var1, IndexCoordinates var2);

    public Mono<String> delete(String var1, IndexCoordinates var2);

    public Mono<String> delete(String var1, Class<?> var2);

    public Mono<ByQueryResponse> delete(Query var1, Class<?> var2);

    public Mono<ByQueryResponse> delete(Query var1, Class<?> var2, IndexCoordinates var3);

    public Mono<UpdateResponse> update(UpdateQuery var1, IndexCoordinates var2);

    public Mono<ByQueryResponse> updateByQuery(UpdateQuery var1, IndexCoordinates var2);

    public Mono<ReindexResponse> reindex(ReindexRequest var1);

    public Mono<String> submitReindex(ReindexRequest var1);
}

