/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.TransportUtils;
import co.elastic.clients.transport.Version;
import co.elastic.clients.transport.rest_client.RestClientOptions;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.ClientLogger;
import org.springframework.data.elasticsearch.client.elc.AutoCloseableElasticsearchClient;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.support.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class ElasticsearchClients {
    private static final String LOG_ID_ATTRIBUTE = ElasticsearchClients.class.getName() + ".LOG_ID";
    private static final String X_SPRING_DATA_ELASTICSEARCH_CLIENT = "X-SpringDataElasticsearch-Client";
    private static final String IMPERATIVE_CLIENT = "imperative";
    private static final String REACTIVE_CLIENT = "reactive";

    public static ReactiveElasticsearchClient createReactive(ClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration, (String)"clientConfiguration must not be null");
        return ElasticsearchClients.createReactive(ElasticsearchClients.getRestClient(clientConfiguration), null);
    }

    public static ReactiveElasticsearchClient createReactive(ClientConfiguration clientConfiguration, @Nullable TransportOptions transportOptions) {
        Assert.notNull((Object)clientConfiguration, (String)"ClientConfiguration must not be null!");
        return ElasticsearchClients.createReactive(ElasticsearchClients.getRestClient(clientConfiguration), transportOptions);
    }

    public static ReactiveElasticsearchClient createReactive(RestClient restClient) {
        return ElasticsearchClients.createReactive(restClient, null);
    }

    public static ReactiveElasticsearchClient createReactive(RestClient restClient, @Nullable TransportOptions transportOptions) {
        return new ReactiveElasticsearchClient(ElasticsearchClients.getElasticsearchTransport(restClient, REACTIVE_CLIENT, transportOptions));
    }

    public static ElasticsearchClient createImperative(ClientConfiguration clientConfiguration) {
        return ElasticsearchClients.createImperative(ElasticsearchClients.getRestClient(clientConfiguration), null);
    }

    public static ElasticsearchClient createImperative(ClientConfiguration clientConfiguration, TransportOptions transportOptions) {
        return ElasticsearchClients.createImperative(ElasticsearchClients.getRestClient(clientConfiguration), transportOptions);
    }

    public static ElasticsearchClient createImperative(RestClient restClient) {
        return ElasticsearchClients.createImperative(restClient, null);
    }

    public static ElasticsearchClient createImperative(RestClient restClient, @Nullable TransportOptions transportOptions) {
        Assert.notNull((Object)restClient, (String)"restClient must not be null");
        ElasticsearchTransport transport = ElasticsearchClients.getElasticsearchTransport(restClient, IMPERATIVE_CLIENT, transportOptions);
        return new AutoCloseableElasticsearchClient(transport);
    }

    public static RestClient getRestClient(ClientConfiguration clientConfiguration) {
        return ElasticsearchClients.getRestClientBuilder(clientConfiguration).build();
    }

    private static RestClientBuilder getRestClientBuilder(ClientConfiguration clientConfiguration) {
        HttpHeaders headers;
        HttpHost[] httpHosts = (HttpHost[])ElasticsearchClients.formattedHosts(clientConfiguration.getEndpoints(), clientConfiguration.useSsl()).stream().map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        if (clientConfiguration.getPathPrefix() != null) {
            builder.setPathPrefix(clientConfiguration.getPathPrefix());
        }
        if (!(headers = clientConfiguration.getDefaultHeaders()).isEmpty()) {
            builder.setDefaultHeaders(ElasticsearchClients.toHeaderArray(headers));
        }
        builder.setHttpClientConfigCallback(clientBuilder -> {
            Duration socketTimeout;
            if (clientConfiguration.getCaFingerprint().isPresent()) {
                clientBuilder.setSSLContext(TransportUtils.sslContextFromCaFingerprint((String)clientConfiguration.getCaFingerprint().get()));
            }
            clientConfiguration.getSslContext().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLContext(arg_0));
            clientConfiguration.getHostNameVerifier().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLHostnameVerifier(arg_0));
            clientBuilder.addInterceptorLast((HttpRequestInterceptor)new CustomHeaderInjector(clientConfiguration.getHeadersSupplier()));
            if (ClientLogger.isEnabled()) {
                HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
                clientBuilder.addInterceptorLast((HttpRequestInterceptor)interceptor);
                clientBuilder.addInterceptorLast((HttpResponseInterceptor)interceptor);
            }
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            Duration connectTimeout = clientConfiguration.getConnectTimeout();
            if (!connectTimeout.isNegative()) {
                requestConfigBuilder.setConnectTimeout(Math.toIntExact(connectTimeout.toMillis()));
            }
            if (!(socketTimeout = clientConfiguration.getSocketTimeout()).isNegative()) {
                requestConfigBuilder.setSocketTimeout(Math.toIntExact(socketTimeout.toMillis()));
                requestConfigBuilder.setConnectionRequestTimeout(Math.toIntExact(socketTimeout.toMillis()));
            }
            clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            clientConfiguration.getProxy().map(HttpHost::create).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setProxy(arg_0));
            for (ClientConfiguration.ClientConfigurationCallback<?> clientConfigurer : clientConfiguration.getClientConfigurers()) {
                if (!(clientConfigurer instanceof ElasticsearchHttpClientConfigurationCallback)) continue;
                ElasticsearchHttpClientConfigurationCallback restClientConfigurationCallback = (ElasticsearchHttpClientConfigurationCallback)clientConfigurer;
                clientBuilder = restClientConfigurationCallback.configure(clientBuilder);
            }
            return clientBuilder;
        });
        for (ClientConfiguration.ClientConfigurationCallback<?> clientConfigurationCallback : clientConfiguration.getClientConfigurers()) {
            if (!(clientConfigurationCallback instanceof ElasticsearchRestClientConfigurationCallback)) continue;
            ElasticsearchRestClientConfigurationCallback configurationCallback = (ElasticsearchRestClientConfigurationCallback)clientConfigurationCallback;
            builder = configurationCallback.configure(builder);
        }
        return builder;
    }

    private static ElasticsearchTransport getElasticsearchTransport(RestClient restClient, String clientType, @Nullable TransportOptions transportOptions) {
        TransportOptions.Builder transportOptionsBuilder = transportOptions != null ? transportOptions.toBuilder() : new RestClientOptions(RequestOptions.DEFAULT).toBuilder();
        ContentType jsonContentType = Version.VERSION == null ? ContentType.APPLICATION_JSON : ContentType.create((String)"application/vnd.elasticsearch+json", (NameValuePair[])new NameValuePair[]{new BasicNameValuePair("compatible-with", String.valueOf(Version.VERSION.major()))});
        Consumer<String> setHeaderIfNotPresent = header -> {
            if (((TransportOptions)transportOptionsBuilder.build()).headers().stream().noneMatch(h -> ((String)h.getKey()).equalsIgnoreCase((String)header))) {
                transportOptionsBuilder.addHeader(header, jsonContentType.toString());
            }
        };
        setHeaderIfNotPresent.accept("Content-Type");
        setHeaderIfNotPresent.accept("Accept");
        TransportOptions transportOptionsWithHeader = (TransportOptions)transportOptionsBuilder.addHeader(X_SPRING_DATA_ELASTICSEARCH_CLIENT, clientType).build();
        return new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper(), transportOptionsWithHeader);
    }

    private static List<String> formattedHosts(List<InetSocketAddress> hosts, boolean useSsl) {
        return hosts.stream().map(it -> (useSsl ? "https" : "http") + "://" + it.getHostString() + ":" + it.getPort()).collect(Collectors.toList());
    }

    private static Header[] toHeaderArray(HttpHeaders headers) {
        return (Header[])headers.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> new BasicHeader((String)entry.getKey(), value))).toArray(Header[]::new);
    }

    public static interface ElasticsearchRestClientConfigurationCallback
    extends ClientConfiguration.ClientConfigurationCallback<RestClientBuilder> {
        public static ElasticsearchRestClientConfigurationCallback from(Function<RestClientBuilder, RestClientBuilder> restClientBuilderCallback) {
            Assert.notNull(restClientBuilderCallback, (String)"restClientBuilderCallback must not be null");
            return restClientBuilderCallback::apply;
        }
    }

    private static class CustomHeaderInjector
    implements HttpRequestInterceptor {
        private final Supplier<HttpHeaders> headersSupplier;

        public CustomHeaderInjector(Supplier<HttpHeaders> headersSupplier) {
            this.headersSupplier = headersSupplier;
        }

        public void process(HttpRequest request, HttpContext context) {
            HttpHeaders httpHeaders = this.headersSupplier.get();
            if (httpHeaders != null && !httpHeaders.isEmpty()) {
                Arrays.stream(ElasticsearchClients.toHeaderArray(httpHeaders)).forEach(arg_0 -> ((HttpRequest)request).addHeader(arg_0));
            }
        }
    }

    @Deprecated
    private static class HttpLoggingInterceptor
    implements HttpResponseInterceptor,
    HttpRequestInterceptor {
        private HttpLoggingInterceptor() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void process(HttpRequest request, HttpContext context) throws IOException {
            String logId = (String)context.getAttribute(LOG_ID_ATTRIBUTE);
            if (logId == null) {
                logId = ClientLogger.newLogId();
                context.setAttribute(LOG_ID_ATTRIBUTE, (Object)logId);
            }
            String headers = Arrays.stream(request.getAllHeaders()).map(header -> header.getName() + (String)(header.getName().equals("Authorization") ? ": *****" : ": " + header.getValue())).collect(Collectors.joining(", ", "[", "]"));
            if (request instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)request;
                if (((HttpEntityEnclosingRequest)request).getEntity() != null) {
                    HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    entity.writeTo((OutputStream)buffer);
                    if (!entity.isRepeatable()) {
                        entityRequest.setEntity((HttpEntity)new ByteArrayEntity(buffer.toByteArray()));
                    }
                    ClientLogger.logRequest(logId, request.getRequestLine().getMethod(), request.getRequestLine().getUri(), "", headers, buffer::toString);
                    return;
                }
            }
            ClientLogger.logRequest(logId, request.getRequestLine().getMethod(), request.getRequestLine().getUri(), (Object)"", headers);
        }

        public void process(HttpResponse response, HttpContext context) throws IOException {
            String logId = (String)context.getAttribute(LOG_ID_ATTRIBUTE);
            String headers = Arrays.stream(response.getAllHeaders()).map(header -> header.getName() + (String)(header.getName().equals("Authorization") ? ": *****" : ": " + header.getValue())).collect(Collectors.joining(", ", "[", "]"));
            ClientLogger.logRawResponse(logId, response.getStatusLine().getStatusCode(), headers);
        }
    }

    public static interface ElasticsearchHttpClientConfigurationCallback
    extends ClientConfiguration.ClientConfigurationCallback<HttpAsyncClientBuilder> {
        public static ElasticsearchHttpClientConfigurationCallback from(Function<HttpAsyncClientBuilder, HttpAsyncClientBuilder> httpClientBuilderCallback) {
            Assert.notNull(httpClientBuilderCallback, (String)"httpClientBuilderCallback must not be null");
            return httpClientBuilderCallback::apply;
        }
    }
}

