/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch.cluster.DeleteComponentTemplateRequest;
import co.elastic.clients.elasticsearch.cluster.GetComponentTemplateResponse;
import co.elastic.clients.elasticsearch.cluster.PutComponentTemplateRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexResponse;
import co.elastic.clients.elasticsearch.indices.DeleteTemplateRequest;
import co.elastic.clients.elasticsearch.indices.ElasticsearchIndicesClient;
import co.elastic.clients.elasticsearch.indices.ExistsIndexTemplateRequest;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.ExistsTemplateRequest;
import co.elastic.clients.elasticsearch.indices.GetAliasRequest;
import co.elastic.clients.elasticsearch.indices.GetAliasResponse;
import co.elastic.clients.elasticsearch.indices.GetIndexRequest;
import co.elastic.clients.elasticsearch.indices.GetIndexResponse;
import co.elastic.clients.elasticsearch.indices.GetIndexTemplateResponse;
import co.elastic.clients.elasticsearch.indices.GetIndicesSettingsRequest;
import co.elastic.clients.elasticsearch.indices.GetIndicesSettingsResponse;
import co.elastic.clients.elasticsearch.indices.GetMappingRequest;
import co.elastic.clients.elasticsearch.indices.GetMappingResponse;
import co.elastic.clients.elasticsearch.indices.GetTemplateRequest;
import co.elastic.clients.elasticsearch.indices.GetTemplateResponse;
import co.elastic.clients.elasticsearch.indices.PutMappingRequest;
import co.elastic.clients.elasticsearch.indices.PutMappingResponse;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.elasticsearch.indices.UpdateAliasesRequest;
import co.elastic.clients.elasticsearch.indices.UpdateAliasesResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.client.elc.ChildTemplate;
import org.springframework.data.elasticsearch.client.elc.ClusterTemplate;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.ResourceUtil;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.DeleteIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.MappingBuilder;
import org.springframework.data.elasticsearch.core.index.PutIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.index.TemplateResponse;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class IndicesTemplate
extends ChildTemplate<ElasticsearchTransport, ElasticsearchIndicesClient>
implements IndexOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndicesTemplate.class);
    private final ClusterTemplate clusterTemplate;
    protected final ElasticsearchConverter elasticsearchConverter;
    @Nullable
    protected final Class<?> boundClass;
    @Nullable
    protected final IndexCoordinates boundIndex;

    public IndicesTemplate(ElasticsearchIndicesClient client, ClusterTemplate clusterTemplate, ElasticsearchConverter elasticsearchConverter, Class<?> boundClass) {
        super(client, elasticsearchConverter);
        Assert.notNull((Object)clusterTemplate, (String)"cluster must not be null");
        Assert.notNull((Object)elasticsearchConverter, (String)"elasticsearchConverter must not be null");
        Assert.notNull(boundClass, (String)"boundClass may not be null");
        this.clusterTemplate = clusterTemplate;
        this.elasticsearchConverter = elasticsearchConverter;
        this.boundClass = boundClass;
        this.boundIndex = null;
    }

    public IndicesTemplate(ElasticsearchIndicesClient client, ClusterTemplate clusterTemplate, ElasticsearchConverter elasticsearchConverter, IndexCoordinates boundIndex) {
        super(client, elasticsearchConverter);
        Assert.notNull((Object)clusterTemplate, (String)"cluster must not be null");
        Assert.notNull((Object)elasticsearchConverter, (String)"elasticsearchConverter must not be null");
        Assert.notNull((Object)boundIndex, (String)"boundIndex must not be null");
        this.clusterTemplate = clusterTemplate;
        this.elasticsearchConverter = elasticsearchConverter;
        this.boundClass = null;
        this.boundIndex = boundIndex;
    }

    protected Class<?> checkForBoundClass() {
        if (this.boundClass == null) {
            throw new InvalidDataAccessApiUsageException("IndexOperations are not bound");
        }
        return this.boundClass;
    }

    @Override
    public boolean create() {
        Settings settings = this.boundClass != null ? this.createSettings(this.boundClass) : new Settings();
        return this.doCreate(this.getIndexCoordinates(), settings, null);
    }

    @Override
    public boolean create(Map<String, Object> settings) {
        Assert.notNull(settings, (String)"settings must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, null);
    }

    @Override
    public boolean create(Map<String, Object> settings, Document mapping) {
        Assert.notNull(settings, (String)"settings must not be null");
        Assert.notNull((Object)mapping, (String)"mapping must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, mapping);
    }

    @Override
    public boolean createWithMapping() {
        return this.doCreate(this.getIndexCoordinates(), this.createSettings(), this.createMapping());
    }

    protected boolean doCreate(IndexCoordinates indexCoordinates, Map<String, Object> settings, @Nullable Document mapping) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        Assert.notNull(settings, (String)"settings must not be null");
        CreateIndexRequest createIndexRequest = this.requestConverter.indicesCreateRequest(indexCoordinates, settings, mapping);
        CreateIndexResponse createIndexResponse = this.execute(client -> client.create(createIndexRequest));
        return Boolean.TRUE.equals(createIndexResponse.acknowledged());
    }

    @Override
    public boolean delete() {
        return this.doDelete(this.getIndexCoordinates());
    }

    private boolean doDelete(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        if (this.doExists(indexCoordinates)) {
            DeleteIndexRequest deleteIndexRequest = this.requestConverter.indicesDeleteRequest(indexCoordinates);
            DeleteIndexResponse deleteIndexResponse = this.execute(client -> client.delete(deleteIndexRequest));
            return deleteIndexResponse.acknowledged();
        }
        return false;
    }

    @Override
    public boolean exists() {
        return this.doExists(this.getIndexCoordinates());
    }

    private boolean doExists(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        ExistsRequest existsRequest = this.requestConverter.indicesExistsRequest(indexCoordinates);
        BooleanResponse existsResponse = this.execute(client -> client.exists(existsRequest));
        return existsResponse.value();
    }

    @Override
    public void refresh() {
        RefreshRequest refreshRequest = this.requestConverter.indicesRefreshRequest(this.getIndexCoordinates());
        this.execute(client -> client.refresh(refreshRequest));
    }

    @Override
    public Document createMapping() {
        return this.createMapping(this.checkForBoundClass());
    }

    @Override
    public Document createMapping(Class<?> clazz) {
        String mappings;
        String mappingPath;
        Assert.notNull(clazz, (String)"clazz must not be null");
        Mapping mappingAnnotation = (Mapping)AnnotatedElementUtils.findMergedAnnotation(clazz, Mapping.class);
        if (mappingAnnotation != null && StringUtils.hasText((String)(mappingPath = mappingAnnotation.mappingPath())) && StringUtils.hasText((String)(mappings = ResourceUtil.readFileFromClasspath(mappingPath)))) {
            return Document.parse(mappings);
        }
        try {
            String mapping = new MappingBuilder(this.elasticsearchConverter).buildPropertyMapping(clazz);
            return Document.parse(mapping);
        }
        catch (Exception e) {
            throw new UncategorizedElasticsearchException("Failed to build mapping for " + clazz.getSimpleName(), e);
        }
    }

    @Override
    public boolean putMapping(Document mapping) {
        Assert.notNull((Object)mapping, (String)"mapping must not be null");
        PutMappingRequest putMappingRequest = this.requestConverter.indicesPutMappingRequest(this.getIndexCoordinates(), mapping);
        PutMappingResponse putMappingResponse = this.execute(client -> client.putMapping(putMappingRequest));
        return putMappingResponse.acknowledged();
    }

    @Override
    public Map<String, Object> getMapping() {
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        GetMappingRequest getMappingRequest = this.requestConverter.indicesGetMappingRequest(indexCoordinates);
        GetMappingResponse getMappingResponse = this.execute(client -> client.getMapping(getMappingRequest));
        Document mappingResponse = this.responseConverter.indicesGetMapping(getMappingResponse, indexCoordinates);
        return mappingResponse;
    }

    @Override
    public Settings createSettings() {
        return this.createSettings(this.checkForBoundClass());
    }

    @Override
    public Settings createSettings(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        ElasticsearchPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(clazz);
        String settingPath = persistentEntity.settingPath();
        return StringUtils.hasText((String)settingPath) ? Settings.parse(ResourceUtil.readFileFromClasspath(settingPath)) : persistentEntity.getDefaultSettings();
    }

    @Override
    public Settings getSettings() {
        return this.getSettings(false);
    }

    @Override
    public Settings getSettings(boolean includeDefaults) {
        GetIndicesSettingsRequest getIndicesSettingsRequest = this.requestConverter.indicesGetSettingsRequest(this.getIndexCoordinates(), includeDefaults);
        GetIndicesSettingsResponse getIndicesSettingsResponse = this.execute(client -> client.getSettings(getIndicesSettingsRequest));
        return this.responseConverter.indicesGetSettings(getIndicesSettingsResponse, this.getIndexCoordinates().getIndexName());
    }

    @Override
    public boolean alias(AliasActions aliasActions) {
        Assert.notNull((Object)aliasActions, (String)"aliasActions must not be null");
        UpdateAliasesRequest updateAliasesRequest = this.requestConverter.indicesUpdateAliasesRequest(aliasActions);
        UpdateAliasesResponse updateAliasesResponse = this.execute(client -> client.updateAliases(updateAliasesRequest));
        return updateAliasesResponse.acknowledged();
    }

    @Override
    public Map<String, Set<AliasData>> getAliases(String ... aliasNames) {
        Assert.notNull((Object)aliasNames, (String)"aliasNames must not be null");
        GetAliasRequest getAliasRequest = this.requestConverter.indicesGetAliasRequest(aliasNames, null);
        GetAliasResponse getAliasResponse = this.execute(client -> client.getAlias(getAliasRequest));
        return this.responseConverter.indicesGetAliasData(getAliasResponse);
    }

    @Override
    public Map<String, Set<AliasData>> getAliasesForIndex(String ... indexNames) {
        Assert.notNull((Object)indexNames, (String)"indexNames must not be null");
        GetAliasRequest getAliasRequest = this.requestConverter.indicesGetAliasRequest(null, indexNames);
        GetAliasResponse getAliasResponse = this.execute(client -> client.getAlias(getAliasRequest));
        return this.responseConverter.indicesGetAliasData(getAliasResponse);
    }

    @Override
    public boolean putTemplate(PutTemplateRequest putTemplateRequest) {
        Assert.notNull((Object)putTemplateRequest, (String)"putTemplateRequest must not be null");
        co.elastic.clients.elasticsearch.indices.PutTemplateRequest putTemplateRequestES = this.requestConverter.indicesPutTemplateRequest(putTemplateRequest);
        return this.execute(client -> client.putTemplate(putTemplateRequestES)).acknowledged();
    }

    @Override
    public TemplateData getTemplate(org.springframework.data.elasticsearch.core.index.GetTemplateRequest getTemplateRequest) {
        Assert.notNull((Object)getTemplateRequest, (String)"getTemplateRequest must not be null");
        GetTemplateRequest getTemplateRequestES = this.requestConverter.indicesGetTemplateRequest(getTemplateRequest);
        GetTemplateResponse getTemplateResponse = this.execute(client -> client.getTemplate(getTemplateRequestES));
        return this.responseConverter.indicesGetTemplateData(getTemplateResponse, getTemplateRequest.getTemplateName());
    }

    @Override
    public boolean existsTemplate(org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest existsTemplateRequest) {
        Assert.notNull((Object)existsTemplateRequest, (String)"existsTemplateRequest must not be null");
        ExistsTemplateRequest existsTemplateRequestSO = this.requestConverter.indicesExistsTemplateRequest(existsTemplateRequest);
        return this.execute(client -> client.existsTemplate(existsTemplateRequestSO)).value();
    }

    @Override
    public boolean deleteTemplate(org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest deleteTemplateRequest) {
        Assert.notNull((Object)deleteTemplateRequest, (String)"deleteTemplateRequest must not be null");
        DeleteTemplateRequest deleteTemplateRequestES = this.requestConverter.indicesDeleteTemplateRequest(deleteTemplateRequest);
        return this.execute(client -> client.deleteTemplate(deleteTemplateRequestES)).acknowledged();
    }

    @Override
    public boolean putIndexTemplate(PutIndexTemplateRequest putIndexTemplateRequest) {
        co.elastic.clients.elasticsearch.indices.PutIndexTemplateRequest putIndexTemplateRequestES = this.requestConverter.indicesPutIndexTemplateRequest(putIndexTemplateRequest);
        return this.execute(client -> client.putIndexTemplate(putIndexTemplateRequestES)).acknowledged();
    }

    @Override
    public boolean existsIndexTemplate(org.springframework.data.elasticsearch.core.index.ExistsIndexTemplateRequest existsIndexTemplateRequest) {
        Assert.notNull((Object)existsIndexTemplateRequest, (String)"existsIndexTemplateRequest must not be null");
        ExistsIndexTemplateRequest existsTemplateRequestES = this.requestConverter.indicesExistsIndexTemplateRequest(existsIndexTemplateRequest);
        return this.execute(client -> client.existsIndexTemplate(existsTemplateRequestES)).value();
    }

    @Override
    public List<TemplateResponse> getIndexTemplate(GetIndexTemplateRequest getIndexTemplateRequest) {
        Assert.notNull((Object)getIndexTemplateRequest, (String)"getIndexTemplateRequest must not be null");
        co.elastic.clients.elasticsearch.indices.GetIndexTemplateRequest getIndexTemplateRequestES = this.requestConverter.indicesGetIndexTemplateRequest(getIndexTemplateRequest);
        GetIndexTemplateResponse getIndexTemplateResponse = this.execute(client -> client.getIndexTemplate(getIndexTemplateRequestES));
        return this.responseConverter.getIndexTemplates(getIndexTemplateResponse);
    }

    @Override
    public boolean deleteIndexTemplate(DeleteIndexTemplateRequest deleteIndexTemplateRequest) {
        Assert.notNull((Object)deleteIndexTemplateRequest, (String)"deleteIndexTemplateRequest must not be null");
        co.elastic.clients.elasticsearch.indices.DeleteIndexTemplateRequest deleteIndexTemplateRequestES = this.requestConverter.indicesDeleteIndexTemplateRequest(deleteIndexTemplateRequest);
        return this.execute(client -> client.deleteIndexTemplate(deleteIndexTemplateRequestES)).acknowledged();
    }

    @Override
    public boolean putComponentTemplate(org.springframework.data.elasticsearch.core.index.PutComponentTemplateRequest putComponentTemplateRequest) {
        Assert.notNull((Object)putComponentTemplateRequest, (String)"putComponentTemplateRequest must not be null");
        PutComponentTemplateRequest putComponentTemplateRequestES = this.requestConverter.clusterPutComponentTemplateRequest(putComponentTemplateRequest);
        return this.clusterTemplate.execute(client -> client.putComponentTemplate(putComponentTemplateRequestES)).acknowledged();
    }

    @Override
    public boolean existsComponentTemplate(ExistsComponentTemplateRequest existsComponentTemplateRequest) {
        Assert.notNull((Object)existsComponentTemplateRequest, (String)"existsComponentTemplateRequest must not be null");
        co.elastic.clients.elasticsearch.cluster.ExistsComponentTemplateRequest existsComponentTemplateRequestES = this.requestConverter.clusterExistsComponentTemplateRequest(existsComponentTemplateRequest);
        return this.clusterTemplate.execute(client -> client.existsComponentTemplate(existsComponentTemplateRequestES)).value();
    }

    @Override
    public List<TemplateResponse> getComponentTemplate(GetComponentTemplateRequest getComponentTemplateRequest) {
        co.elastic.clients.elasticsearch.cluster.GetComponentTemplateRequest getComponentTemplateRequestES = this.requestConverter.clusterGetComponentTemplateRequest(getComponentTemplateRequest);
        GetComponentTemplateResponse response = this.clusterTemplate.execute(client -> client.getComponentTemplate(getComponentTemplateRequestES));
        return this.responseConverter.clusterGetComponentTemplates(response);
    }

    @Override
    public boolean deleteComponentTemplate(org.springframework.data.elasticsearch.core.index.DeleteComponentTemplateRequest deleteComponentTemplateRequest) {
        Assert.notNull((Object)deleteComponentTemplateRequest, (String)"deleteComponentTemplateRequest must not be null");
        DeleteComponentTemplateRequest deleteComponentTemplateRequestES = this.requestConverter.clusterDeleteComponentTemplateRequest(deleteComponentTemplateRequest);
        return this.clusterTemplate.execute(client -> client.deleteComponentTemplate(deleteComponentTemplateRequestES)).acknowledged();
    }

    @Override
    public List<IndexInformation> getInformation(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        GetIndexRequest getIndexRequest = this.requestConverter.indicesGetIndexRequest(indexCoordinates);
        GetIndexResponse getIndexResponse = this.execute(client -> client.get(getIndexRequest));
        return this.responseConverter.indicesGetIndexInformations(getIndexResponse);
    }

    ElasticsearchPersistentEntity<?> getRequiredPersistentEntity(Class<?> clazz) {
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
    }

    @Override
    public IndexCoordinates getIndexCoordinates() {
        return this.boundClass != null ? this.getIndexCoordinatesFor(this.boundClass) : Objects.requireNonNull(this.boundIndex);
    }

    public IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        return this.getRequiredPersistentEntity(clazz).getIndexCoordinates();
    }
}

