/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch.core.search.Highlight;
import co.elastic.clients.elasticsearch.core.search.HighlightField;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.data.elasticsearch.client.elc.TypeUtils;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.highlight.Highlight;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightField;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightFieldParameters;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightParameters;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class HighlightQueryBuilder {
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    HighlightQueryBuilder(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }

    public co.elastic.clients.elasticsearch.core.search.Highlight getHighlight(Highlight highlight, @Nullable Class<?> type) {
        Highlight.Builder highlightBuilder = new Highlight.Builder();
        this.addParameters(highlight.getParameters(), highlightBuilder);
        for (HighlightField highlightField : highlight.getFields()) {
            String mappedName = this.mapFieldName(highlightField.getName(), type);
            highlightBuilder.fields(mappedName, hf -> {
                this.addParameters(highlightField.getParameters(), (HighlightField.Builder)hf, type);
                return hf;
            });
        }
        return highlightBuilder.build();
    }

    private void addParameters(HighlightParameters parameters, Highlight.Builder builder) {
        if (StringUtils.hasLength((String)parameters.getBoundaryChars())) {
            builder.boundaryChars(parameters.getBoundaryChars());
        }
        if (parameters.getBoundaryMaxScan() > -1) {
            builder.boundaryMaxScan(Integer.valueOf(parameters.getBoundaryMaxScan()));
        }
        if (StringUtils.hasLength((String)parameters.getBoundaryScanner())) {
            builder.boundaryScanner(TypeUtils.boundaryScanner(parameters.getBoundaryScanner()));
        }
        if (StringUtils.hasLength((String)parameters.getBoundaryScannerLocale())) {
            builder.boundaryScannerLocale(parameters.getBoundaryScannerLocale());
        }
        if (StringUtils.hasLength((String)parameters.getFragmenter())) {
            builder.fragmenter(TypeUtils.highlighterFragmenter(parameters.getFragmenter()));
        }
        if (parameters.getFragmentSize() > -1) {
            builder.fragmentSize(Integer.valueOf(parameters.getFragmentSize()));
        }
        if (parameters.getNoMatchSize() > -1) {
            builder.noMatchSize(Integer.valueOf(parameters.getNoMatchSize()));
        }
        if (parameters.getNumberOfFragments() > -1) {
            builder.numberOfFragments(Integer.valueOf(parameters.getNumberOfFragments()));
        }
        if (StringUtils.hasLength((String)parameters.getOrder())) {
            builder.order(TypeUtils.highlighterOrder(parameters.getOrder()));
        }
        if (parameters.getPreTags().length > 0) {
            builder.preTags(Arrays.asList(parameters.getPreTags()));
        }
        if (parameters.getPostTags().length > 0) {
            builder.postTags(Arrays.asList(parameters.getPostTags()));
        }
        if (!parameters.getRequireFieldMatch()) {
            builder.requireFieldMatch(Boolean.valueOf(false));
        }
        if (StringUtils.hasLength((String)parameters.getType())) {
            builder.type(TypeUtils.highlighterType(parameters.getType()));
        }
        if (StringUtils.hasLength((String)parameters.getEncoder())) {
            builder.encoder(TypeUtils.highlighterEncoder(parameters.getEncoder()));
        }
        if (StringUtils.hasLength((String)parameters.getTagsSchema())) {
            builder.tagsSchema(TypeUtils.highlighterTagsSchema(parameters.getTagsSchema()));
        }
    }

    private void addParameters(HighlightFieldParameters parameters, HighlightField.Builder builder, Class<?> type) {
        if (StringUtils.hasLength((String)parameters.getBoundaryChars())) {
            builder.boundaryChars(parameters.getBoundaryChars());
        }
        if (parameters.getBoundaryMaxScan() > -1) {
            builder.boundaryMaxScan(Integer.valueOf(parameters.getBoundaryMaxScan()));
        }
        if (StringUtils.hasLength((String)parameters.getBoundaryScanner())) {
            builder.boundaryScanner(TypeUtils.boundaryScanner(parameters.getBoundaryScanner()));
        }
        if (StringUtils.hasLength((String)parameters.getBoundaryScannerLocale())) {
            builder.boundaryScannerLocale(parameters.getBoundaryScannerLocale());
        }
        if (parameters.getForceSource()) {
            builder.forceSource(Boolean.valueOf(parameters.getForceSource()));
        }
        if (StringUtils.hasLength((String)parameters.getFragmenter())) {
            builder.fragmenter(TypeUtils.highlighterFragmenter(parameters.getFragmenter()));
        }
        if (parameters.getFragmentSize() > -1) {
            builder.fragmentSize(Integer.valueOf(parameters.getFragmentSize()));
        }
        if (parameters.getNoMatchSize() > -1) {
            builder.noMatchSize(Integer.valueOf(parameters.getNoMatchSize()));
        }
        if (parameters.getNumberOfFragments() > -1) {
            builder.numberOfFragments(Integer.valueOf(parameters.getNumberOfFragments()));
        }
        if (StringUtils.hasLength((String)parameters.getOrder())) {
            builder.order(TypeUtils.highlighterOrder(parameters.getOrder()));
        }
        if (parameters.getPhraseLimit() > -1) {
            builder.phraseLimit(Integer.valueOf(parameters.getPhraseLimit()));
        }
        if (parameters.getPreTags().length > 0) {
            builder.preTags(Arrays.asList(parameters.getPreTags()));
        }
        if (parameters.getPostTags().length > 0) {
            builder.postTags(Arrays.asList(parameters.getPostTags()));
        }
        if (!parameters.getRequireFieldMatch()) {
            builder.requireFieldMatch(Boolean.valueOf(false));
        }
        if (StringUtils.hasLength((String)parameters.getType())) {
            builder.type(TypeUtils.highlighterType(parameters.getType()));
        }
        if (parameters.getFragmentOffset() > -1) {
            builder.fragmentOffset(Integer.valueOf(parameters.getFragmentOffset()));
        }
        if (parameters.getMatchedFields().length > 0) {
            builder.matchedFields(Arrays.stream(parameters.getMatchedFields()).map(fieldName -> this.mapFieldName((String)fieldName, type)).collect(Collectors.toList()));
        }
    }

    private String mapFieldName(String fieldName, @Nullable Class<?> type) {
        ElasticsearchPersistentProperty persistentProperty;
        ElasticsearchPersistentEntity persistentEntity;
        if (type != null && (persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(type)) != null && (persistentProperty = (ElasticsearchPersistentProperty)persistentEntity.getPersistentProperty(fieldName)) != null) {
            return persistentProperty.getFieldName();
        }
        return fieldName;
    }
}

