/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import java.util.Map;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasAction;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public record ComponentTemplateRequestData(@Nullable Settings settings, @Nullable Document mapping, @Nullable AliasActions aliasActions, @Nullable Boolean allowAutoCreate) {
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Settings settings;
        @Nullable
        private Document mapping;
        @Nullable
        private AliasActions aliasActions;
        @Nullable
        private Boolean allowAutoCreate;

        public Builder withSettings(Map<String, Object> settings) {
            this.settings = new Settings(settings);
            return this;
        }

        public Builder withMapping(Document mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder withAliasActions(AliasActions aliasActions) {
            aliasActions.getActions().forEach(action -> Assert.isTrue((boolean)(action instanceof AliasAction.Add), (String)"only alias add actions are allowed in templates"));
            this.aliasActions = aliasActions;
            return this;
        }

        public Builder withAllowAutoCreate(@Nullable Boolean allowAutoCreate) {
            this.allowAutoCreate = allowAutoCreate;
            return this;
        }

        public ComponentTemplateRequestData build() {
            return new ComponentTemplateRequestData(this.settings, this.mapping, this.aliasActions, this.allowAutoCreate);
        }
    }
}

