/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.support.QueryStringPlaceholderReplacer;
import org.springframework.data.elasticsearch.repository.support.spel.QueryStringSpELEvaluator;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.util.Assert;

public class QueryStringProcessor {
    private final String query;
    private final QueryMethod queryMethod;
    private final ConversionService conversionService;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public QueryStringProcessor(String query, QueryMethod queryMethod, ConversionService conversionService, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)queryMethod, (String)"queryMethod must not be null");
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"evaluationContextProvider must not be null");
        this.query = query;
        this.queryMethod = queryMethod;
        this.conversionService = conversionService;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public String createQuery(ElasticsearchParametersParameterAccessor parameterAccessor) {
        String queryString = new QueryStringPlaceholderReplacer(this.conversionService).replacePlaceholders(this.query, parameterAccessor);
        QueryStringSpELEvaluator evaluator = new QueryStringSpELEvaluator(queryString, parameterAccessor, this.queryMethod, this.evaluationContextProvider, this.conversionService);
        return evaluator.evaluate();
    }
}

