/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractReactiveElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.support.QueryStringProcessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.util.Assert;

public class ReactiveElasticsearchStringQuery
extends AbstractReactiveElasticsearchRepositoryQuery {
    private final String query;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public ReactiveElasticsearchStringQuery(ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations operations, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getAnnotatedQuery(), queryMethod, operations, evaluationContextProvider);
    }

    public ReactiveElasticsearchStringQuery(String query, ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations operations, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, operations, evaluationContextProvider);
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"evaluationContextProvider must not be null");
        this.query = query;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    @Override
    protected BaseQuery createQuery(ElasticsearchParametersParameterAccessor parameterAccessor) {
        ConversionService conversionService = this.getElasticsearchOperations().getElasticsearchConverter().getConversionService();
        String processed = new QueryStringProcessor(this.query, this.queryMethod, conversionService, this.evaluationContextProvider).createQuery(parameterAccessor);
        return new StringQuery(processed);
    }

    @Override
    boolean isCountQuery() {
        return this.queryMethod.hasCountQueryAnnotation();
    }

    @Override
    boolean isDeleteQuery() {
        return false;
    }

    @Override
    boolean isExistsQuery() {
        return false;
    }

    @Override
    boolean isLimiting() {
        return false;
    }
}

