/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RegionLookupFactoryBean<K, V>
implements FactoryBean<Region<K, V>>,
InitializingBean,
BeanNameAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Boolean lookupEnabled = Boolean.TRUE;
    private GemFireCache cache;
    private Region<?, ?> parent;
    private Region<K, V> region;
    private String beanName;
    private String name;
    private String regionName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"The 'cache' property must be set.");
        String regionName = StringUtils.hasText((String)this.regionName) ? this.regionName : (StringUtils.hasText((String)this.name) ? this.name : this.beanName);
        Assert.hasText((String)regionName, (String)"The 'regionName', 'name' or 'beanName' property must be set.");
        GemFireCache gemFireCache = this.cache;
        synchronized (gemFireCache) {
            if (this.isLookupEnabled()) {
                this.region = this.getParent() != null ? this.getParent().getSubregion(regionName) : this.cache.getRegion(regionName);
            }
            if (this.region != null) {
                this.log.info((Object)String.format("Retrieved Region [%1$s] from Cache [%2$s].", regionName, this.cache.getName()));
            } else {
                this.region = this.lookupFallback(this.cache, regionName);
            }
        }
    }

    protected Region<K, V> lookupFallback(GemFireCache cache, String regionName) throws Exception {
        throw new BeanInitializationException(String.format("Cannot find Region [%1$s] in Cache [%2$s].", regionName, cache));
    }

    public Region<K, V> getObject() throws Exception {
        return this.region;
    }

    public Class<?> getObjectType() {
        return this.region != null ? this.region.getClass() : Region.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setCache(GemFireCache cache) {
        this.cache = cache;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(Region<?, ?> parent) {
        this.parent = parent;
    }

    protected Region<?, ?> getParent() {
        return this.parent;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    private boolean isLookupEnabled() {
        return Boolean.TRUE.equals(this.getLookupEnabled());
    }

    public Boolean getLookupEnabled() {
        return this.lookupEnabled;
    }

    public void setLookupEnabled(Boolean lookupEnabled) {
        this.lookupEnabled = lookupEnabled;
    }

    protected Region<K, V> getRegion() {
        return this.region;
    }
}

