/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.pdx.PdxSerializer;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClientCacheFactoryBean
extends CacheFactoryBean {
    protected Boolean readyForEvents = false;
    private Pool pool;
    private String poolName;

    @Override
    protected void postProcessPropertiesBeforeInitialization(Properties gemfireProperties) {
    }

    @Override
    protected GemFireCache createCache(Object factory) {
        ClientCacheFactory clientCacheFactory = (ClientCacheFactory)factory;
        this.initializePool(clientCacheFactory);
        ClientCache cache = clientCacheFactory.create();
        this.readyForEvents();
        return cache;
    }

    @Override
    protected Object createFactory(Properties gemfireProperties) {
        return new ClientCacheFactory(gemfireProperties);
    }

    @Override
    protected GemFireCache fetchCache() {
        return ClientCacheFactory.getAnyInstance();
    }

    private void initializePool(ClientCacheFactory clientCacheFactory) {
        this.initializeClientCacheFactoryPoolSettings(clientCacheFactory, this.resolvePool(this.pool));
    }

    private Pool resolvePool(Pool pool) {
        Pool localPool = pool;
        if (localPool == null && (localPool = PoolManager.find((String)this.poolName)) == null) {
            try {
                if (StringUtils.hasText((String)this.poolName) && this.getBeanFactory().isTypeMatch(this.poolName, Pool.class)) {
                    localPool = (Pool)this.getBeanFactory().getBean(this.poolName, Pool.class);
                } else {
                    localPool = (Pool)this.getBeanFactory().getBean(Pool.class);
                    this.poolName = localPool.getName();
                }
            }
            catch (Exception e) {
                throw new BeanInitializationException(String.format("No bean of type '%1$s' having name '%2$s' was found.%3$s", Pool.class.getName(), this.poolName, "DEFAULT".equals(this.poolName) ? " A client cache requires a pool." : ""), (Throwable)e);
            }
        }
        return localPool;
    }

    private void initializeClientCacheFactoryPoolSettings(ClientCacheFactory clientCacheFactory, Pool pool) {
        if (pool != null) {
            clientCacheFactory.setPoolFreeConnectionTimeout(pool.getFreeConnectionTimeout());
            clientCacheFactory.setPoolIdleTimeout(pool.getIdleTimeout());
            clientCacheFactory.setPoolLoadConditioningInterval(pool.getLoadConditioningInterval());
            clientCacheFactory.setPoolMaxConnections(pool.getMaxConnections());
            clientCacheFactory.setPoolMinConnections(pool.getMinConnections());
            clientCacheFactory.setPoolMultiuserAuthentication(pool.getMultiuserAuthentication());
            clientCacheFactory.setPoolPingInterval(pool.getPingInterval());
            clientCacheFactory.setPoolPRSingleHopEnabled(pool.getPRSingleHopEnabled());
            clientCacheFactory.setPoolReadTimeout(pool.getReadTimeout());
            clientCacheFactory.setPoolRetryAttempts(pool.getRetryAttempts());
            clientCacheFactory.setPoolServerGroup(pool.getServerGroup());
            clientCacheFactory.setPoolSocketBufferSize(pool.getSocketBufferSize());
            clientCacheFactory.setPoolStatisticInterval(pool.getStatisticInterval());
            clientCacheFactory.setPoolSubscriptionAckInterval(pool.getSubscriptionAckInterval());
            clientCacheFactory.setPoolSubscriptionEnabled(pool.getSubscriptionEnabled());
            clientCacheFactory.setPoolSubscriptionMessageTrackingTimeout(pool.getSubscriptionMessageTrackingTimeout());
            clientCacheFactory.setPoolSubscriptionRedundancy(pool.getSubscriptionRedundancy());
            clientCacheFactory.setPoolThreadLocalConnections(pool.getThreadLocalConnections());
            for (InetSocketAddress socketAddress : this.nullSafeCollection(pool.getLocators())) {
                clientCacheFactory.addPoolLocator(socketAddress.getHostName(), socketAddress.getPort());
            }
            for (InetSocketAddress socketAddress : this.nullSafeCollection(pool.getServers())) {
                clientCacheFactory.addPoolServer(socketAddress.getHostName(), socketAddress.getPort());
            }
        }
    }

    @Override
    protected void setPdxOptions(Object factory) {
        if (factory instanceof ClientCacheFactory) {
            new PdxOptions((ClientCacheFactory)factory).run();
        }
    }

    private void readyForEvents() {
        ClientCache clientCache = ClientCacheFactory.getAnyInstance();
        if (Boolean.TRUE.equals(this.readyForEvents) && !clientCache.isClosed()) {
            try {
                clientCache.readyForEvents();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void setPool(Pool pool) {
        Assert.notNull((Object)pool, (String)"pool cannot be null");
        this.pool = pool;
    }

    public void setPoolName(String poolName) {
        Assert.hasText((String)poolName, (String)"pool name is required");
        this.poolName = poolName;
    }

    public void setReadyForEvents(Boolean readyForEvents) {
        this.readyForEvents = readyForEvents;
    }

    public Boolean getReadyForEvents() {
        return this.readyForEvents;
    }

    private class PdxOptions
    implements Runnable {
        private ClientCacheFactory factory;

        private PdxOptions(ClientCacheFactory factory) {
            this.factory = factory;
        }

        @Override
        public void run() {
            if (ClientCacheFactoryBean.this.pdxSerializer != null) {
                Assert.isAssignable(PdxSerializer.class, ClientCacheFactoryBean.this.pdxSerializer.getClass(), (String)"Invalid pdx serializer used");
                this.factory.setPdxSerializer((PdxSerializer)ClientCacheFactoryBean.this.pdxSerializer);
            }
            if (ClientCacheFactoryBean.this.pdxDiskStoreName != null) {
                this.factory.setPdxDiskStore(ClientCacheFactoryBean.this.pdxDiskStoreName);
            }
            if (ClientCacheFactoryBean.this.pdxIgnoreUnreadFields != null) {
                this.factory.setPdxIgnoreUnreadFields(ClientCacheFactoryBean.this.pdxIgnoreUnreadFields.booleanValue());
            }
            if (ClientCacheFactoryBean.this.pdxPersistent != null) {
                this.factory.setPdxPersistent(ClientCacheFactoryBean.this.pdxPersistent.booleanValue());
            }
            if (ClientCacheFactoryBean.this.pdxReadSerialized != null) {
                this.factory.setPdxReadSerialized(ClientCacheFactoryBean.this.pdxReadSerialized.booleanValue());
            }
        }
    }
}

