/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.util.Arrays;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionConfigurationSource;
import org.springframework.data.gemfire.function.config.TypeFilterParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class XmlFunctionExecutionConfigurationSource
extends AbstractFunctionExecutionConfigurationSource {
    private static final String BASE_PACKAGE = "base-package";
    private Element element;
    private ParserContext context;
    private Iterable<TypeFilter> includeFilters;
    private Iterable<TypeFilter> excludeFilters;

    XmlFunctionExecutionConfigurationSource(Element element, ParserContext context) {
        Assert.notNull((Object)element);
        Assert.notNull((Object)context);
        this.element = element;
        this.context = context;
        TypeFilterParser parser = new TypeFilterParser(context.getReaderContext());
        this.includeFilters = parser.parseTypeFilters(element, TypeFilterParser.Type.INCLUDE);
        this.excludeFilters = parser.parseTypeFilters(element, TypeFilterParser.Type.EXCLUDE);
    }

    @Override
    public Object getSource() {
        return this.context.extractSource((Object)this.element);
    }

    @Override
    public Iterable<String> getBasePackages() {
        String attribute = this.element.getAttribute(BASE_PACKAGE);
        return Arrays.asList(StringUtils.delimitedListToStringArray((String)attribute, (String)",", (String)" "));
    }

    @Override
    public Iterable<TypeFilter> getIncludeFilters() {
        return this.includeFilters;
    }

    @Override
    public Iterable<TypeFilter> getExcludeFilters() {
        return this.excludeFilters;
    }
}

