/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import com.gemstone.gemfire.cache.RegionShortcut;
import org.springframework.util.ObjectUtils;

public enum RegionShortcutWrapper {
    LOCAL(RegionShortcut.LOCAL),
    LOCAL_HEAP_LRU(RegionShortcut.LOCAL_HEAP_LRU),
    LOCAL_OVERFLOW(RegionShortcut.LOCAL_OVERFLOW),
    LOCAL_PERSISTENT(RegionShortcut.LOCAL_PERSISTENT),
    LOCAL_PERSISTENT_OVERFLOW(RegionShortcut.LOCAL_PERSISTENT_OVERFLOW),
    PARTITION(RegionShortcut.PARTITION),
    PARTITION_HEAP_LRU(RegionShortcut.PARTITION_HEAP_LRU),
    PARTITION_OVERFLOW(RegionShortcut.PARTITION_OVERFLOW),
    PARTITION_PERSISTENT(RegionShortcut.PARTITION_PERSISTENT),
    PARTITION_PERSISTENT_OVERFLOW(RegionShortcut.PARTITION_PERSISTENT_OVERFLOW),
    PARTITION_PROXY(RegionShortcut.PARTITION_PROXY),
    PARTITION_PROXY_REDUNDANT(RegionShortcut.PARTITION_PROXY_REDUNDANT),
    PARTITION_REDUNDANT(RegionShortcut.PARTITION_REDUNDANT),
    PARTITION_REDUNDANT_HEAP_LRU(RegionShortcut.PARTITION_REDUNDANT_HEAP_LRU),
    PARTITION_REDUNDANT_OVERFLOW(RegionShortcut.PARTITION_REDUNDANT_OVERFLOW),
    PARTITION_REDUNDANT_PERSISTENT(RegionShortcut.PARTITION_REDUNDANT_PERSISTENT),
    PARTITION_REDUNDANT_PERSISTENT_OVERFLOW(RegionShortcut.PARTITION_REDUNDANT_PERSISTENT_OVERFLOW),
    REPLICATE(RegionShortcut.REPLICATE),
    REPLICATE_HEAP_LRU(RegionShortcut.REPLICATE_HEAP_LRU),
    REPLICATE_OVERFLOW(RegionShortcut.REPLICATE_OVERFLOW),
    REPLICATE_PERSISTENT(RegionShortcut.REPLICATE_PERSISTENT),
    REPLICATE_PERSISTENT_OVERFLOW(RegionShortcut.REPLICATE_PERSISTENT_OVERFLOW),
    REPLICATE_PROXY(RegionShortcut.REPLICATE_PROXY),
    UNSPECIFIED(null);

    private final RegionShortcut regionShortcut;

    private RegionShortcutWrapper(RegionShortcut regionShortcut) {
        this.regionShortcut = regionShortcut;
    }

    public static RegionShortcutWrapper valueOf(RegionShortcut regionShortcut) {
        for (RegionShortcutWrapper wrapper : RegionShortcutWrapper.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)wrapper.getRegionShortcut(), (Object)regionShortcut)) continue;
            return wrapper;
        }
        return UNSPECIFIED;
    }

    public boolean isHeapLru() {
        return this.name().contains("HEAP_LRU");
    }

    public boolean isLocal() {
        return this.name().contains("LOCAL");
    }

    public boolean isOverflow() {
        return this.name().contains("OVERFLOW");
    }

    public boolean isPartition() {
        return this.name().contains("PARTITION");
    }

    public boolean isPersistent() {
        return this.name().contains("PERSISTENT");
    }

    public boolean isPersistentOverflow() {
        return this.isOverflow() && this.isPersistent();
    }

    public boolean isProxy() {
        return this.name().contains("PROXY");
    }

    public boolean isRedundant() {
        return this.name().contains("REDUNDANT");
    }

    public boolean isReplicate() {
        return this.name().contains("REPLICATE");
    }

    public RegionShortcut getRegionShortcut() {
        return this.regionShortcut;
    }
}

