/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import com.gemstone.gemfire.cache.Declarable;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SpringContextBootstrappingInitializer
implements Declarable,
ApplicationListener<ApplicationContextEvent> {
    public static final String BASE_PACKAGES_PARAMETER = "basePackages";
    public static final String CONTEXT_CONFIG_LOCATIONS_PARAMETER = "contextConfigLocations";
    protected static final String CHARS_TO_DELETE = " \n\t";
    protected static final String COMMA_DELIMITER = ",";
    private static final ApplicationEventMulticaster applicationEventNotifier = new SimpleApplicationEventMulticaster();
    static volatile ConfigurableApplicationContext applicationContext;
    static volatile ContextRefreshedEvent contextRefreshedEvent;
    protected final Log logger = this.initLogger();

    public static synchronized ConfigurableApplicationContext getApplicationContext() {
        Assert.state((applicationContext != null ? 1 : 0) != 0, (String)"The Spring ApplicationContext has not been properly configured and initialized!");
        return applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyOnExistingContextRefreshedEvent(ApplicationListener<ContextRefreshedEvent> listener) {
        ApplicationEventMulticaster applicationEventMulticaster = applicationEventNotifier;
        synchronized (applicationEventMulticaster) {
            if (contextRefreshedEvent != null) {
                listener.onApplicationEvent((ApplicationEvent)contextRefreshedEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ApplicationListener<ContextRefreshedEvent>> T register(T listener) {
        ApplicationEventMulticaster applicationEventMulticaster = applicationEventNotifier;
        synchronized (applicationEventMulticaster) {
            applicationEventNotifier.addApplicationListener(listener);
            SpringContextBootstrappingInitializer.notifyOnExistingContextRefreshedEvent(listener);
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ApplicationListener<ContextRefreshedEvent>> T unregister(T listener) {
        ApplicationEventMulticaster applicationEventMulticaster = applicationEventNotifier;
        synchronized (applicationEventMulticaster) {
            applicationEventNotifier.removeApplicationListener(listener);
        }
        return listener;
    }

    protected Log initLogger() {
        return LogFactory.getLog(this.getClass());
    }

    protected ConfigurableApplicationContext createApplicationContext(String[] configLocations) {
        Assert.notEmpty((Object[])configLocations, (String)"'configLocations' must be specified to construct and configure an instance of the ClassPathXmlApplicationContext.");
        return this.createApplicationContext(null, configLocations);
    }

    protected ConfigurableApplicationContext createApplicationContext(String[] basePackages, String[] configLocations) {
        if (!ObjectUtils.isEmpty((Object[])configLocations)) {
            return new ClassPathXmlApplicationContext(configLocations, false);
        }
        Assert.notEmpty((Object[])basePackages, (String)"'basePackages' or 'configLocations' must be specified to construct and configure an instance of the ConfigurableApplicationContext.");
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();
        applicationContext.scan(basePackages);
        return applicationContext;
    }

    protected ConfigurableApplicationContext initApplicationContext(ConfigurableApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"The ConfigurableApplicationContext reference must not be null!");
        applicationContext.addApplicationListener((ApplicationListener)this);
        applicationContext.registerShutdownHook();
        return applicationContext;
    }

    protected ConfigurableApplicationContext refreshApplicationContext(ConfigurableApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"The ConfigurableApplicationContext reference must not be null!");
        applicationContext.refresh();
        return applicationContext;
    }

    protected String nullSafeGetApplicationContextId(ApplicationContext applicationContext) {
        return applicationContext != null ? applicationContext.getId() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties parameters) {
        try {
            Class<SpringContextBootstrappingInitializer> clazz = SpringContextBootstrappingInitializer.class;
            synchronized (SpringContextBootstrappingInitializer.class) {
                if (applicationContext == null || !applicationContext.isActive()) {
                    String basePackages = parameters.getProperty(BASE_PACKAGES_PARAMETER);
                    String contextConfigLocations = parameters.getProperty(CONTEXT_CONFIG_LOCATIONS_PARAMETER);
                    Assert.isTrue((StringUtils.hasText((String)basePackages) || StringUtils.hasText((String)contextConfigLocations) ? 1 : 0) != 0, (String)"Either 'basePackages' or the 'contextConfigLocations' parameter must be specified.");
                    Object[] basePackagesArray = StringUtils.delimitedListToStringArray((String)basePackages, (String)COMMA_DELIMITER, (String)CHARS_TO_DELETE);
                    Object[] contextConfigLocationsArray = StringUtils.delimitedListToStringArray((String)contextConfigLocations, (String)COMMA_DELIMITER, (String)CHARS_TO_DELETE);
                    ConfigurableApplicationContext localApplicationContext = this.refreshApplicationContext(this.initApplicationContext(this.createApplicationContext((String[])basePackagesArray, (String[])contextConfigLocationsArray)));
                    Assert.state((boolean)localApplicationContext.isRunning(), (String)String.format("The Spring ApplicationContext (%1$s) failed to be properly initialized with the context config files (%2$s) or base packages (%3$s)!", this.nullSafeGetApplicationContextId((ApplicationContext)localApplicationContext), Arrays.toString(contextConfigLocationsArray), Arrays.toString(basePackagesArray)));
                    applicationContext = localApplicationContext;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Throwable cause) {
            String message = "Failed to bootstrap the Spring ApplicationContext!";
            this.logger.error((Object)message, cause);
            throw new ApplicationContextException(message, cause);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ApplicationEventMulticaster applicationEventMulticaster = applicationEventNotifier;
            synchronized (applicationEventMulticaster) {
                contextRefreshedEvent = (ContextRefreshedEvent)event;
                applicationEventNotifier.multicastEvent((ApplicationEvent)event);
            }
        }
        if (event instanceof ContextClosedEvent) {
            ApplicationEventMulticaster applicationEventMulticaster = applicationEventNotifier;
            synchronized (applicationEventMulticaster) {
                contextRefreshedEvent = null;
            }
        }
    }
}

