/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.CopyException;
import com.gemstone.gemfire.GemFireCacheException;
import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.IncompatibleSystemException;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.InvalidValueException;
import com.gemstone.gemfire.LicenseException;
import com.gemstone.gemfire.NoSystemException;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.SystemIsRunningException;
import com.gemstone.gemfire.UnmodifiableException;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.RegionNotFoundException;
import com.gemstone.gemfire.admin.RuntimeAdminException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheExistsException;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheRuntimeException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.CacheXmlException;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.CommitIncompleteException;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EntryNotFoundInRegion;
import com.gemstone.gemfire.cache.FailedSynchronizationException;
import com.gemstone.gemfire.cache.OperationAbortedException;
import com.gemstone.gemfire.cache.PartitionedRegionDistributionException;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.ResourceException;
import com.gemstone.gemfire.cache.RoleException;
import com.gemstone.gemfire.cache.StatisticsDisabledException;
import com.gemstone.gemfire.cache.SynchronizationCommitConflictException;
import com.gemstone.gemfire.cache.VersionException;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexMaintenanceException;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryExecutionTimeoutException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.distributed.LeaseExpiredException;
import com.gemstone.gemfire.security.GemFireSecurityException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.data.gemfire.GemfireCancellationException;
import org.springframework.data.gemfire.GemfireIndexException;
import org.springframework.data.gemfire.GemfireQueryException;
import org.springframework.data.gemfire.GemfireSystemException;
import org.springframework.util.ClassUtils;

public abstract class GemfireCacheUtils {
    private static Class<?> CQ_EXCEPTION_CLASS;

    public static DataAccessException convertGemfireAccessException(GemFireException ex) {
        if (ex instanceof CacheException) {
            if (ex instanceof CacheExistsException) {
                return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof CommitConflictException) {
                return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof CommitIncompleteException) {
                return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof EntryExistsException) {
                return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof EntryNotFoundException) {
                return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof RegionExistsException) {
                return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
            }
        }
        if (ex instanceof CacheRuntimeException) {
            if (ex instanceof CacheXmlException) {
                return new GemfireSystemException(ex);
            }
            if (ex instanceof CancelException) {
                return new GemfireCancellationException((CancelException)ex);
            }
            if (ex instanceof CqClosedException) {
                return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof DiskAccessException) {
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof EntryDestroyedException) {
                return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof FailedSynchronizationException) {
                return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof IndexMaintenanceException) {
                return new GemfireIndexException((IndexMaintenanceException)ex);
            }
            if (ex instanceof OperationAbortedException) {
                if (ex instanceof CacheLoaderException) {
                    return new GemfireSystemException(ex);
                }
                if (ex instanceof CacheWriterException) {
                    return new GemfireSystemException(ex);
                }
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof PartitionedRegionDistributionException) {
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof PartitionedRegionStorageException) {
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof QueryExecutionTimeoutException) {
                return new GemfireQueryException((QueryExecutionTimeoutException)ex);
            }
            if (ex instanceof RegionDestroyedException) {
                return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof RegionNotFoundException) {
                return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof ResourceException) {
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof RoleException) {
                return new GemfireSystemException(ex);
            }
            if (ex instanceof StatisticsDisabledException) {
                return new GemfireSystemException(ex);
            }
            if (ex instanceof SynchronizationCommitConflictException) {
                return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
            }
        }
        if (ex instanceof CopyException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof EntryNotFoundInRegion) {
            return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof FunctionException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof GemFireCacheException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)((GemFireCacheException)ex).getCacheException());
        }
        if (ex instanceof GemFireConfigException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof GemFireIOException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof GemFireSecurityException) {
            return new PermissionDeniedDataAccessException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof IncompatibleSystemException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof InternalGemFireException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof InvalidValueException) {
            return new TypeMismatchDataAccessException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof LeaseExpiredException) {
            return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof LicenseException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof NoSystemException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof RuntimeAdminException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof ServerConnectivityException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof SystemConnectException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof SystemIsRunningException) {
            return new GemfireSystemException(ex);
        }
        if (ex instanceof UnmodifiableException) {
            return new GemfireSystemException(ex);
        }
        DataAccessException dae = GemfireCacheUtils.convertQueryExceptions((RuntimeException)ex);
        if (dae != null) {
            return dae;
        }
        return new GemfireSystemException(ex);
    }

    static DataAccessException convertQueryExceptions(RuntimeException ex) {
        if (ex instanceof IndexInvalidException) {
            return GemfireCacheUtils.convertGemfireAccessException((IndexInvalidException)ex);
        }
        if (ex instanceof QueryInvalidException) {
            return GemfireCacheUtils.convertGemfireAccessException((QueryInvalidException)ex);
        }
        if (GemfireCacheUtils.isCqInvalidException(ex)) {
            return GemfireCacheUtils.convertCqInvalidException(ex);
        }
        return new GemfireSystemException(ex);
    }

    public static DataAccessException convertGemfireAccessException(GemFireCheckedException ex) {
        if (ex instanceof QueryException) {
            return new GemfireQueryException((QueryException)ex);
        }
        if (ex instanceof VersionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof com.gemstone.gemfire.cache.util.VersionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof AdminException) {
            return new GemfireSystemException(ex);
        }
        return new GemfireSystemException(ex);
    }

    public static DataAccessException convertGemfireAccessException(IndexInvalidException ex) {
        return new GemfireIndexException(ex);
    }

    public static DataAccessException convertGemfireAccessException(QueryInvalidException ex) {
        return new GemfireQueryException(ex);
    }

    static boolean isCqInvalidException(RuntimeException ex) {
        return CQ_EXCEPTION_CLASS != null && CQ_EXCEPTION_CLASS.isAssignableFrom(ex.getClass());
    }

    static DataAccessException convertCqInvalidException(RuntimeException ex) {
        return new GemfireQueryException(ex);
    }

    static {
        Class type = null;
        try {
            type = ClassUtils.resolveClassName((String)"com.gemstone.gemfire.cache.query.CqInvalidException", (ClassLoader)GemfireCacheUtils.class.getClassLoader());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CQ_EXCEPTION_CLASS = type;
    }
}

