/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.EnableAutoRegionLookup;
import org.springframework.data.gemfire.config.support.AutoRegionLookupBeanPostProcessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AutoRegionLookupConfiguration
implements BeanFactoryAware,
EnvironmentAware,
ImportBeanDefinitionRegistrar {
    private static final AtomicBoolean AUTO_REGION_LOOKUP_BEAN_POST_PROCESSOR_REGISTERED = new AtomicBoolean(false);
    private Environment environment;
    private ExpressionParser spelParser = new SpelExpressionParser();
    private StandardEvaluationContext evaluationContext = new StandardEvaluationContext();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
            this.evaluationContext.setTypeLocator((TypeLocator)new StandardTypeLocator(configurableBeanFactory.getBeanClassLoader()));
            ConversionService conversionService = configurableBeanFactory.getConversionService();
            if (conversionService != null) {
                this.evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
            }
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected Environment getEnvironment() {
        Assert.state((this.environment != null ? 1 : 0) != 0, (String)"The Environment was not properly configured");
        return this.environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map enableAutoRegionLookupAttributes = importingClassMetadata.getAnnotationAttributes(EnableAutoRegionLookup.class.getName());
        String enabled = (String)enableAutoRegionLookupAttributes.get("enabled");
        if (this.isEnabled(enabled)) {
            this.registerAutoRegionLookupBeanPostProcessor(registry);
        }
    }

    private boolean isEnabled(String enabled) {
        if (!Boolean.parseBoolean(enabled = StringUtils.trimWhitespace((String)enabled))) {
            try {
                return (Boolean)this.spelParser.parseExpression(enabled).getValue((EvaluationContext)this.evaluationContext, Boolean.TYPE);
            }
            catch (EvaluationException ignore) {
                return false;
            }
            catch (ParseException ignore) {
                return (Boolean)this.getEnvironment().getProperty(enabled, Boolean.TYPE, (Object)false);
            }
        }
        return true;
    }

    private void registerAutoRegionLookupBeanPostProcessor(BeanDefinitionRegistry registry) {
        if (AUTO_REGION_LOOKUP_BEAN_POST_PROCESSOR_REGISTERED.compareAndSet(false, true)) {
            AbstractBeanDefinition autoRegionLookupBeanPostProcessor = BeanDefinitionBuilder.rootBeanDefinition(AutoRegionLookupBeanPostProcessor.class).setRole(2).getBeanDefinition();
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)autoRegionLookupBeanPostProcessor, (BeanDefinitionRegistry)registry);
        }
    }
}

