/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.ExpirationActionType;
import org.springframework.data.gemfire.config.annotation.EnableExpiration;
import org.springframework.data.gemfire.support.AnnotationBasedExpiration;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;

@Configuration
public class ExpirationConfiguration
implements ImportAware {
    protected static final int DEFAULT_TIMEOUT = 0;
    protected static final ExpirationActionType DEFAULT_ACTION = ExpirationActionType.DEFAULT;
    protected static final EnableExpiration.ExpirationType[] DEFAULT_EXPIRATION_TYPES = new EnableExpiration.ExpirationType[]{EnableExpiration.ExpirationType.IDLE_TIMEOUT};
    private ExpirationPolicyConfigurer expirationPolicyConfigurer;

    protected Class<? extends Annotation> getAnnotationType() {
        return EnableExpiration.class;
    }

    protected String getAnnotationTypeName() {
        return this.getAnnotationType().getName();
    }

    protected String getAnnotationTypeSimpleName() {
        return this.getAnnotationType().getSimpleName();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (importMetadata.hasAnnotation(this.getAnnotationTypeName())) {
            Map enableExpirationAttributes = importMetadata.getAnnotationAttributes(this.getAnnotationTypeName());
            AnnotationAttributes[] policies = (AnnotationAttributes[])enableExpirationAttributes.get("policies");
            for (AnnotationAttributes expirationPolicyAttributes : ArrayUtils.nullSafeArray(policies, AnnotationAttributes.class)) {
                this.expirationPolicyConfigurer = ComposableExpirationPolicyConfigurer.compose(this.expirationPolicyConfigurer, ExpirationPolicyMetaData.from(expirationPolicyAttributes));
            }
            this.expirationPolicyConfigurer = this.expirationPolicyConfigurer != null ? this.expirationPolicyConfigurer : ExpirationPolicyMetaData.fromDefaults();
        }
    }

    protected boolean isRegion(Object bean) {
        return bean instanceof Region;
    }

    protected ExpirationPolicyConfigurer getExpirationPolicyConfigurer() {
        Assert.state((this.expirationPolicyConfigurer != null ? 1 : 0) != 0, (String)"ExpirationPolicyConfigurer was not properly configured and initialized");
        return this.expirationPolicyConfigurer;
    }

    @Bean
    public BeanPostProcessor expirationBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                return ExpirationConfiguration.this.isRegion(bean) ? ExpirationConfiguration.this.getExpirationPolicyConfigurer().configure((Region)bean) : bean;
            }
        };
    }

    protected static class ExpirationPolicyMetaData
    implements ExpirationPolicyConfigurer {
        protected static final String[] ALL_REGIONS = new String[0];
        private final ExpirationAttributes defaultExpirationAttributes;
        private final Set<String> regionNames = new HashSet<String>();
        private final Set<EnableExpiration.ExpirationType> types = new HashSet<EnableExpiration.ExpirationType>();

        protected static ExpirationPolicyMetaData from(AnnotationAttributes expirationPolicyAttributes) {
            Assert.isAssignable(EnableExpiration.ExpirationPolicy.class, (Class)expirationPolicyAttributes.annotationType());
            return ExpirationPolicyMetaData.newExpirationPolicyMetaData((Integer)expirationPolicyAttributes.get((Object)"timeout"), (ExpirationActionType)expirationPolicyAttributes.getEnum("action"), expirationPolicyAttributes.getStringArray("regionNames"), (EnableExpiration.ExpirationType[])expirationPolicyAttributes.get((Object)"types"));
        }

        protected static ExpirationPolicyMetaData from(EnableExpiration.ExpirationPolicy expirationPolicy) {
            return ExpirationPolicyMetaData.newExpirationPolicyMetaData(expirationPolicy.timeout(), expirationPolicy.action(), expirationPolicy.regionNames(), expirationPolicy.types());
        }

        protected static ExpirationPolicyMetaData fromDefaults() {
            return ExpirationPolicyMetaData.newExpirationPolicyMetaData(0, DEFAULT_ACTION, ALL_REGIONS, DEFAULT_EXPIRATION_TYPES);
        }

        protected static ExpirationAttributes newExpirationAttributes(int timeout, ExpirationActionType action) {
            return ExpirationPolicyMetaData.newExpirationAttributes(timeout, action.getExpirationAction());
        }

        protected static ExpirationAttributes newExpirationAttributes(int timeout, ExpirationAction action) {
            return new ExpirationAttributes(timeout, action);
        }

        protected static ExpirationPolicyMetaData newExpirationPolicyMetaData(int timeout, ExpirationActionType action, String[] regionNames, EnableExpiration.ExpirationType[] types) {
            return new ExpirationPolicyMetaData(ExpirationPolicyMetaData.newExpirationAttributes(timeout, action), CollectionUtils.asSet(ArrayUtils.nullSafeArray(regionNames, String.class)), CollectionUtils.asSet(ArrayUtils.nullSafeArray(types, EnableExpiration.ExpirationType.class)));
        }

        protected static ExpirationActionType resolveAction(ExpirationActionType action) {
            return SpringUtils.defaultIfNull(action, DEFAULT_ACTION);
        }

        protected static int resolveTimeout(int timeout) {
            return Math.max(timeout, 0);
        }

        protected ExpirationPolicyMetaData(int timeout, ExpirationActionType action, Set<String> regionNames, Set<EnableExpiration.ExpirationType> types) {
            this(ExpirationPolicyMetaData.newExpirationAttributes(ExpirationPolicyMetaData.resolveTimeout(timeout), ExpirationPolicyMetaData.resolveAction(action)), regionNames, types);
        }

        protected ExpirationPolicyMetaData(ExpirationAttributes expirationAttributes, Set<String> regionNames, Set<EnableExpiration.ExpirationType> types) {
            Assert.notEmpty(types, (String)"At least one ExpirationPolicy type [TTI, TTL] must be specified");
            this.defaultExpirationAttributes = expirationAttributes;
            this.regionNames.addAll(CollectionUtils.nullSafeSet(regionNames));
            this.types.addAll(CollectionUtils.nullSafeSet(types));
        }

        protected boolean accepts(Region region) {
            return region != null && this.accepts(region.getName());
        }

        protected boolean accepts(String regionName) {
            return this.regionNames.isEmpty() || this.regionNames.contains(regionName);
        }

        protected boolean isIdleTimeout() {
            return this.types.contains((Object)EnableExpiration.ExpirationType.IDLE_TIMEOUT);
        }

        protected boolean isTimeToLive() {
            return this.types.contains((Object)EnableExpiration.ExpirationType.TIME_TO_LIVE);
        }

        @Override
        public <K, V> Region<K, V> configure(Region<K, V> region) {
            if (this.accepts(region)) {
                AttributesMutator regionAttributesMutator = region.getAttributesMutator();
                ExpirationAttributes defaultExpirationAttributes = this.defaultExpirationAttributes();
                if (this.isIdleTimeout()) {
                    regionAttributesMutator.setCustomEntryIdleTimeout(AnnotationBasedExpiration.forIdleTimeout(defaultExpirationAttributes));
                }
                if (this.isTimeToLive()) {
                    regionAttributesMutator.setCustomEntryTimeToLive(AnnotationBasedExpiration.forTimeToLive(defaultExpirationAttributes));
                }
            }
            return region;
        }

        protected ExpirationAttributes defaultExpirationAttributes() {
            return this.defaultExpirationAttributes;
        }
    }

    protected static class ComposableExpirationPolicyConfigurer
    implements ExpirationPolicyConfigurer {
        private final ExpirationPolicyConfigurer one;
        private final ExpirationPolicyConfigurer two;

        protected static ExpirationPolicyConfigurer compose(ExpirationPolicyConfigurer[] array) {
            return ComposableExpirationPolicyConfigurer.compose(Arrays.asList(ArrayUtils.nullSafeArray(array, ExpirationPolicyConfigurer.class)));
        }

        protected static ExpirationPolicyConfigurer compose(Iterable<ExpirationPolicyConfigurer> iterable) {
            ExpirationPolicyConfigurer current = null;
            for (ExpirationPolicyConfigurer configurer : CollectionUtils.nullSafeIterable(iterable)) {
                current = ComposableExpirationPolicyConfigurer.compose(current, configurer);
            }
            return current;
        }

        protected static ExpirationPolicyConfigurer compose(ExpirationPolicyConfigurer one, ExpirationPolicyConfigurer two) {
            return one == null ? two : (two == null ? one : new ComposableExpirationPolicyConfigurer(one, two));
        }

        private ComposableExpirationPolicyConfigurer(ExpirationPolicyConfigurer one, ExpirationPolicyConfigurer two) {
            this.one = one;
            this.two = two;
        }

        @Override
        public <K, V> Region<K, V> configure(Region<K, V> region) {
            return this.two.configure(this.one.configure(region));
        }
    }

    protected static interface ExpirationPolicyConfigurer {
        public <K, V> Region<K, V> configure(Region<K, V> var1);
    }
}

