/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableMcast;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class McastConfiguration
extends EmbeddedServiceConfigurationSupport {
    public static final int DEFAULT_MCAST_PORT = 10334;
    public static final int DEFAULT_MCAST_RECEIVE_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_MCAST_SEND_BUFFER_SIZE = 65535;
    public static final String DEFAULT_MCAST_ADDRESS = "239.192.81.1";
    public static final String DEFAULT_MCAST_FLOW_CONTROL = "1048576,0.25,5000";

    @Override
    protected Class getAnnotationType() {
        return EnableMcast.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
        gemfireProperties.unsetProperty("locators");
        gemfireProperties.setPropertyIfNotDefault("mcast-address", annotationAttributes.get("address"), DEFAULT_MCAST_ADDRESS);
        gemfireProperties.setPropertyIfNotDefault("mcast-flow-control", annotationAttributes.get("flowControl"), DEFAULT_MCAST_FLOW_CONTROL);
        gemfireProperties.setPropertyIfNotDefault("mcast-port", annotationAttributes.get("port"), 10334);
        gemfireProperties.setPropertyIfNotDefault("mcast-recv-buffer-size", annotationAttributes.get("receiveBufferSize"), 0x100000);
        gemfireProperties.setPropertyIfNotDefault("mcast-send-buffer-size", annotationAttributes.get("sendBufferSize"), 65535);
        return gemfireProperties.build();
    }
}

