/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.Gateway;
import java.beans.PropertyEditorSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.gemfire.EvictionActionConverter;
import org.springframework.data.gemfire.EvictionPolicyConverter;
import org.springframework.data.gemfire.EvictionPolicyType;
import org.springframework.data.gemfire.ExpirationActionConverter;
import org.springframework.data.gemfire.IndexMaintenancePolicyConverter;
import org.springframework.data.gemfire.IndexMaintenancePolicyType;
import org.springframework.data.gemfire.IndexType;
import org.springframework.data.gemfire.IndexTypeConverter;
import org.springframework.data.gemfire.InterestPolicyConverter;
import org.springframework.data.gemfire.ScopeConverter;
import org.springframework.data.gemfire.client.InterestResultPolicyConverter;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicy;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicyConverter;
import org.springframework.data.gemfire.support.AbstractPropertyEditorConverterSupport;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.wan.OrderPolicyConverter;
import org.springframework.data.gemfire.wan.StartupPolicyConverter;
import org.springframework.data.gemfire.wan.StartupPolicyType;

public class CustomEditorBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerCustomEditor(ConnectionEndpoint.class, StringToConnectionEndpointConverter.class);
        beanFactory.registerCustomEditor(ConnectionEndpointList.class, StringToConnectionEndpointListConverter.class);
        beanFactory.registerCustomEditor(EvictionAction.class, EvictionActionConverter.class);
        beanFactory.registerCustomEditor(EvictionPolicyType.class, EvictionPolicyConverter.class);
        beanFactory.registerCustomEditor(ExpirationAction.class, ExpirationActionConverter.class);
        beanFactory.registerCustomEditor(IndexMaintenancePolicyType.class, IndexMaintenancePolicyConverter.class);
        beanFactory.registerCustomEditor(IndexType.class, IndexTypeConverter.class);
        beanFactory.registerCustomEditor(InterestPolicy.class, InterestPolicyConverter.class);
        beanFactory.registerCustomEditor(InterestResultPolicy.class, InterestResultPolicyConverter.class);
        beanFactory.registerCustomEditor(Gateway.OrderPolicy.class, OrderPolicyConverter.class);
        beanFactory.registerCustomEditor(Scope.class, ScopeConverter.class);
        beanFactory.registerCustomEditor(StartupPolicyType.class, StartupPolicyConverter.class);
        beanFactory.registerCustomEditor(SubscriptionEvictionPolicy.class, SubscriptionEvictionPolicyConverter.class);
    }

    public static class StringToConnectionEndpointListConverter
    extends AbstractPropertyEditorConverterSupport<ConnectionEndpointList> {
        public ConnectionEndpointList convert(String source) {
            return this.assertConverted(source, ConnectionEndpointList.parse(0, source.split(",")), ConnectionEndpointList.class);
        }
    }

    public static class StringToConnectionEndpointConverter
    extends AbstractPropertyEditorConverterSupport<ConnectionEndpoint> {
        public ConnectionEndpoint convert(String source) {
            return this.assertConverted(source, ConnectionEndpoint.parse(source), ConnectionEndpoint.class);
        }
    }

    public static class ConnectionEndpointArrayToIterableConverter
    extends PropertyEditorSupport
    implements Converter<ConnectionEndpoint[], Iterable> {
        public Iterable convert(ConnectionEndpoint[] source) {
            return ConnectionEndpointList.from(source);
        }
    }
}

