/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.repository.query.Predicate;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.gemfire.repository.query.support.OqlKeyword;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

class QueryBuilder {
    static final String DEFAULT_ALIAS = "x";
    static final String SELECT_OQL_TEMPLATE = "SELECT %1$s * FROM /%2$s %3$s";
    static final String WHERE_CLAUSE_TEMPLATE = "%1$s WHERE %2$s";
    private final String query;

    static String asQuery(GemfirePersistentEntity<?> entity, PartTree tree) {
        return String.format(SELECT_OQL_TEMPLATE, tree.isDistinct() ? OqlKeyword.DISTINCT : "", entity.getRegionName(), DEFAULT_ALIAS).replaceAll("\\s{2,}", " ");
    }

    static String validateQuery(String query) {
        Assert.hasText((String)query, (String)"An OQL Query must be specified");
        return query;
    }

    public QueryBuilder(String query) {
        this.query = QueryBuilder.validateQuery(query);
    }

    public QueryBuilder(GemfirePersistentEntity<?> entity, PartTree tree) {
        this(QueryBuilder.asQuery(entity, tree));
    }

    public QueryString create(Predicate predicate) {
        return new QueryString(this.withPredicate(this.query, predicate));
    }

    protected String withPredicate(String query, Predicate predicate) {
        return predicate == null ? query : String.format(WHERE_CLAUSE_TEMPLATE, query, predicate.toString(DEFAULT_ALIAS));
    }

    public String toString() {
        return this.query;
    }
}

