/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.EvictionAttributesMutator;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class LookupRegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V> {
    private Boolean cloningEnabled;
    private Boolean enableStatistics;
    private AsyncEventQueue[] asyncEventQueues;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private CustomExpiry<K, V> customEntryIdleTimeout;
    private CustomExpiry<K, V> customEntryTimeToLive;
    private ExpirationAttributes entryIdleTimeout;
    private ExpirationAttributes entryTimeToLive;
    private ExpirationAttributes regionIdleTimeout;
    private ExpirationAttributes regionTimeToLive;
    private GatewaySender[] gatewaySenders;
    private Integer evictionMaximum;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        AttributesMutator attributesMutator = this.getRegion().getAttributesMutator();
        if (!ObjectUtils.isEmpty((Object[])this.asyncEventQueues)) {
            for (AsyncEventQueue asyncEventQueue : this.asyncEventQueues) {
                attributesMutator.addAsyncEventQueueId(asyncEventQueue.getId());
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.cacheListeners)) {
            for (AsyncEventQueue asyncEventQueue : this.cacheListeners) {
                attributesMutator.addCacheListener((CacheListener)asyncEventQueue);
            }
        }
        if (this.cacheLoader != null) {
            attributesMutator.setCacheLoader(this.cacheLoader);
        }
        if (this.cacheWriter != null) {
            attributesMutator.setCacheWriter(this.cacheWriter);
        }
        if (this.cloningEnabled != null) {
            attributesMutator.setCloningEnabled(this.cloningEnabled.booleanValue());
        }
        if (this.isStatisticsEnabled()) {
            this.assertStatisticsEnabled();
            if (this.customEntryIdleTimeout != null) {
                attributesMutator.setCustomEntryIdleTimeout(this.customEntryIdleTimeout);
            }
            if (this.customEntryTimeToLive != null) {
                attributesMutator.setCustomEntryTimeToLive(this.customEntryTimeToLive);
            }
            if (this.entryIdleTimeout != null) {
                attributesMutator.setEntryIdleTimeout(this.entryIdleTimeout);
            }
            if (this.entryTimeToLive != null) {
                attributesMutator.setEntryTimeToLive(this.entryTimeToLive);
            }
            if (this.regionIdleTimeout != null) {
                attributesMutator.setRegionIdleTimeout(this.regionIdleTimeout);
            }
            if (this.regionTimeToLive != null) {
                attributesMutator.setRegionTimeToLive(this.regionTimeToLive);
            }
        }
        if (this.evictionMaximum != null) {
            EvictionAttributesMutator evictionAttributesMutator = attributesMutator.getEvictionAttributesMutator();
            evictionAttributesMutator.setMaximum(this.evictionMaximum.intValue());
        }
        if (!ObjectUtils.isEmpty((Object[])this.gatewaySenders)) {
            for (AsyncEventQueue asyncEventQueue : this.gatewaySenders) {
                attributesMutator.addGatewaySenderId(asyncEventQueue.getId());
            }
        }
    }

    @Override
    final boolean isLookupEnabled() {
        return true;
    }

    public void setAsyncEventQueues(AsyncEventQueue[] asyncEventQueues) {
        this.asyncEventQueues = asyncEventQueues;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setCloningEnabled(Boolean cloningEnabled) {
        this.cloningEnabled = cloningEnabled;
    }

    public void setCustomEntryIdleTimeout(CustomExpiry<K, V> customEntryIdleTimeout) {
        this.setStatisticsEnabled(customEntryIdleTimeout != null);
        this.customEntryIdleTimeout = customEntryIdleTimeout;
    }

    public void setCustomEntryTimeToLive(CustomExpiry<K, V> customEntryTimeToLive) {
        this.setStatisticsEnabled(customEntryTimeToLive != null);
        this.customEntryTimeToLive = customEntryTimeToLive;
    }

    public void setEntryIdleTimeout(ExpirationAttributes entryIdleTimeout) {
        this.setStatisticsEnabled(entryIdleTimeout != null);
        this.entryIdleTimeout = entryIdleTimeout;
    }

    public void setEntryTimeToLive(ExpirationAttributes entryTimeToLive) {
        this.setStatisticsEnabled(entryTimeToLive != null);
        this.entryTimeToLive = entryTimeToLive;
    }

    public void setEvictionMaximum(Integer evictionMaximum) {
        this.evictionMaximum = evictionMaximum;
    }

    public void setGatewaySenders(GatewaySender[] gatewaySenders) {
        this.gatewaySenders = gatewaySenders;
    }

    public void setRegionIdleTimeout(ExpirationAttributes regionIdleTimeout) {
        this.setStatisticsEnabled(regionIdleTimeout != null);
        this.regionIdleTimeout = regionIdleTimeout;
    }

    public void setRegionTimeToLive(ExpirationAttributes regionTimeToLive) {
        this.setStatisticsEnabled(regionTimeToLive != null);
        this.regionTimeToLive = regionTimeToLive;
    }

    public void setStatisticsEnabled(Boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    protected boolean isStatisticsEnabled() {
        return Boolean.TRUE.equals(this.enableStatistics);
    }

    private void assertStatisticsEnabled() {
        Region localRegion = this.getRegion();
        Assert.state((boolean)localRegion.getAttributes().getStatisticsEnabled(), (String)String.format("Statistics for Region '%1$s' must be enabled to change Entry & Region TTL/TTI Expiration settings", localRegion.getFullPath()));
    }
}

