/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.QueryService;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.client.PoolAdapter;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PoolFactoryBean
implements FactoryBean<Pool>,
InitializingBean,
DisposableBean,
BeanNameAware,
BeanFactoryAware {
    protected static final int DEFAULT_LOCATOR_PORT = 10334;
    protected static final int DEFAULT_SERVER_PORT = 40404;
    private static final Log log = LogFactory.getLog(PoolFactoryBean.class);
    volatile boolean springBasedPool = true;
    private BeanFactory beanFactory;
    private ConnectionEndpointList locators = new ConnectionEndpointList();
    private ConnectionEndpointList servers = new ConnectionEndpointList();
    private volatile Pool pool;
    private String beanName;
    private String name;
    private boolean keepAlive = false;
    private boolean multiUserAuthentication = false;
    private boolean prSingleHopEnabled = true;
    private boolean subscriptionEnabled = false;
    private boolean threadLocalConnections = false;
    private int freeConnectionTimeout = 10000;
    private int loadConditioningInterval = 300000;
    private int maxConnections = -1;
    private int minConnections = 1;
    private int readTimeout = 10000;
    private int retryAttempts = -1;
    private int socketBufferSize = 32768;
    private int statisticInterval = -1;
    private int subscriptionAckInterval = 100;
    private int subscriptionMessageTrackingTimeout = 900000;
    private int subscriptionRedundancy = 0;
    private long idleTimeout = 5000L;
    private long pingInterval = 10000L;
    private String serverGroup = "";

    public void afterPropertiesSet() throws Exception {
        Pool existingPool;
        if (!StringUtils.hasText((String)this.name)) {
            Assert.hasText((String)this.beanName, (String)"Pool 'name' is required");
            this.name = this.beanName;
        }
        if ((existingPool = PoolManager.find((String)this.name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("A Pool with name [%1$s] already exists; using existing Pool.", this.name));
            }
            this.springBasedPool = false;
            this.pool = existingPool;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("No Pool with name [%1$s] was found. Creating new Pool.", this.name));
            }
            this.springBasedPool = true;
        }
    }

    public void destroy() throws Exception {
        if (this.springBasedPool && this.pool != null && !this.pool.isDestroyed()) {
            this.pool.releaseThreadLocalConnection();
            this.pool.destroy(this.keepAlive);
            this.pool = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Destroyed Pool [%1$s]", this.name));
            }
        }
    }

    public Pool getObject() throws Exception {
        if (this.pool == null) {
            this.eagerlyInitializeClientCacheIfNotPresent();
            PoolFactory poolFactory = this.createPoolFactory();
            poolFactory.setFreeConnectionTimeout(this.freeConnectionTimeout);
            poolFactory.setIdleTimeout(this.idleTimeout);
            poolFactory.setLoadConditioningInterval(this.loadConditioningInterval);
            poolFactory.setMaxConnections(this.maxConnections);
            poolFactory.setMinConnections(this.minConnections);
            poolFactory.setMultiuserAuthentication(this.multiUserAuthentication);
            poolFactory.setPingInterval(this.pingInterval);
            poolFactory.setPRSingleHopEnabled(this.prSingleHopEnabled);
            poolFactory.setReadTimeout(this.readTimeout);
            poolFactory.setRetryAttempts(this.retryAttempts);
            poolFactory.setServerGroup(this.serverGroup);
            poolFactory.setSocketBufferSize(this.socketBufferSize);
            poolFactory.setStatisticInterval(this.statisticInterval);
            poolFactory.setSubscriptionAckInterval(this.subscriptionAckInterval);
            poolFactory.setSubscriptionEnabled(this.subscriptionEnabled);
            poolFactory.setSubscriptionMessageTrackingTimeout(this.subscriptionMessageTrackingTimeout);
            poolFactory.setSubscriptionRedundancy(this.subscriptionRedundancy);
            poolFactory.setThreadLocalConnections(this.threadLocalConnections);
            for (ConnectionEndpoint locator : this.locators) {
                poolFactory.addLocator(locator.getHost(), locator.getPort());
            }
            for (ConnectionEndpoint server : this.servers) {
                poolFactory.addServer(server.getHost(), server.getPort());
            }
            this.pool = poolFactory.create(this.name);
        }
        return this.pool;
    }

    boolean isDistributedSystemPresent() {
        return GemfireUtils.isConnected(GemfireUtils.getDistributedSystem());
    }

    void eagerlyInitializeClientCacheIfNotPresent() {
        if (!this.isDistributedSystemPresent()) {
            this.getBeanFactory().getBean(ClientCache.class);
        }
    }

    protected PoolFactory createPoolFactory() {
        return PoolManager.createFactory();
    }

    public Class<?> getObjectType() {
        return this.pool != null ? this.pool.getClass() : Pool.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void addLocators(ConnectionEndpoint ... locators) {
        this.locators.add(locators);
    }

    public void addLocators(Iterable<ConnectionEndpoint> locators) {
        this.locators.add(locators);
    }

    public void addServers(ConnectionEndpoint ... servers) {
        this.servers.add(servers);
    }

    public void addServers(Iterable<ConnectionEndpoint> servers) {
        this.servers.add(servers);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public Pool getPool() {
        return this.pool != null ? this.pool : new PoolAdapter(){

            @Override
            public boolean isDestroyed() {
                Pool pool = PoolFactoryBean.this.pool;
                return pool != null && pool.isDestroyed();
            }

            @Override
            public int getFreeConnectionTimeout() {
                return PoolFactoryBean.this.freeConnectionTimeout;
            }

            @Override
            public long getIdleTimeout() {
                return PoolFactoryBean.this.idleTimeout;
            }

            @Override
            public int getLoadConditioningInterval() {
                return PoolFactoryBean.this.loadConditioningInterval;
            }

            @Override
            public List<InetSocketAddress> getLocators() {
                return PoolFactoryBean.this.locators.toInetSocketAddresses();
            }

            @Override
            public int getMaxConnections() {
                return PoolFactoryBean.this.maxConnections;
            }

            @Override
            public int getMinConnections() {
                return PoolFactoryBean.this.minConnections;
            }

            @Override
            public boolean getMultiuserAuthentication() {
                return PoolFactoryBean.this.multiUserAuthentication;
            }

            @Override
            public String getName() {
                String name = PoolFactoryBean.this.name;
                name = StringUtils.hasText((String)name) ? name : PoolFactoryBean.this.beanName;
                return name;
            }

            @Override
            public int getPendingEventCount() {
                Pool pool = PoolFactoryBean.this.pool;
                if (pool != null) {
                    return pool.getPendingEventCount();
                }
                throw new IllegalStateException("The Pool is not initialized");
            }

            @Override
            public long getPingInterval() {
                return PoolFactoryBean.this.pingInterval;
            }

            @Override
            public boolean getPRSingleHopEnabled() {
                return PoolFactoryBean.this.prSingleHopEnabled;
            }

            @Override
            public QueryService getQueryService() {
                Pool pool = PoolFactoryBean.this.pool;
                if (pool != null) {
                    return pool.getQueryService();
                }
                throw new IllegalStateException("The Pool is not initialized");
            }

            @Override
            public int getReadTimeout() {
                return PoolFactoryBean.this.readTimeout;
            }

            @Override
            public int getRetryAttempts() {
                return PoolFactoryBean.this.retryAttempts;
            }

            @Override
            public String getServerGroup() {
                return PoolFactoryBean.this.serverGroup;
            }

            @Override
            public List<InetSocketAddress> getServers() {
                return PoolFactoryBean.this.servers.toInetSocketAddresses();
            }

            @Override
            public int getSocketBufferSize() {
                return PoolFactoryBean.this.socketBufferSize;
            }

            @Override
            public int getStatisticInterval() {
                return PoolFactoryBean.this.statisticInterval;
            }

            @Override
            public int getSubscriptionAckInterval() {
                return PoolFactoryBean.this.subscriptionAckInterval;
            }

            @Override
            public boolean getSubscriptionEnabled() {
                return PoolFactoryBean.this.subscriptionEnabled;
            }

            @Override
            public int getSubscriptionMessageTrackingTimeout() {
                return PoolFactoryBean.this.subscriptionMessageTrackingTimeout;
            }

            @Override
            public int getSubscriptionRedundancy() {
                return PoolFactoryBean.this.subscriptionRedundancy;
            }

            @Override
            public boolean getThreadLocalConnections() {
                return PoolFactoryBean.this.threadLocalConnections;
            }

            @Override
            public void destroy() {
                this.destroy(false);
            }

            @Override
            public void destroy(boolean keepAlive) {
                block2: {
                    try {
                        PoolFactoryBean.this.destroy();
                    }
                    catch (Exception ignore) {
                        Pool pool = PoolFactoryBean.this.pool;
                        if (pool == null) break block2;
                        pool.destroy(keepAlive);
                    }
                }
            }

            @Override
            public void releaseThreadLocalConnection() {
                Pool pool = PoolFactoryBean.this.pool;
                if (pool == null) {
                    throw new IllegalStateException("The Pool is not initialized");
                }
                pool.releaseThreadLocalConnection();
            }
        };
    }

    public void setFreeConnectionTimeout(int freeConnectionTimeout) {
        this.freeConnectionTimeout = freeConnectionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setLoadConditioningInterval(int loadConditioningInterval) {
        this.loadConditioningInterval = loadConditioningInterval;
    }

    public void setLocators(ConnectionEndpoint[] connectionEndpoints) {
        this.setLocators(ConnectionEndpointList.from(connectionEndpoints));
    }

    public void setLocators(Iterable<ConnectionEndpoint> connectionEndpoints) {
        this.getLocators().clear();
        this.getLocators().add(connectionEndpoints);
    }

    ConnectionEndpointList getLocators() {
        return this.locators;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public void setMultiUserAuthentication(boolean multiUserAuthentication) {
        this.multiUserAuthentication = multiUserAuthentication;
    }

    public void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public void setPrSingleHopEnabled(boolean prSingleHopEnabled) {
        this.prSingleHopEnabled = prSingleHopEnabled;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    public void setServers(ConnectionEndpoint[] connectionEndpoints) {
        this.setServers(ConnectionEndpointList.from(connectionEndpoints));
    }

    public void setServers(Iterable<ConnectionEndpoint> connectionEndpoints) {
        this.getServers().clear();
        this.getServers().add(connectionEndpoints);
    }

    ConnectionEndpointList getServers() {
        return this.servers;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setStatisticInterval(int statisticInterval) {
        this.statisticInterval = statisticInterval;
    }

    public void setSubscriptionAckInterval(int subscriptionAckInterval) {
        this.subscriptionAckInterval = subscriptionAckInterval;
    }

    public void setSubscriptionEnabled(boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    public void setSubscriptionMessageTrackingTimeout(int subscriptionMessageTrackingTimeout) {
        this.subscriptionMessageTrackingTimeout = subscriptionMessageTrackingTimeout;
    }

    public void setSubscriptionRedundancy(int subscriptionRedundancy) {
        this.subscriptionRedundancy = subscriptionRedundancy;
    }

    public void setThreadLocalConnections(boolean threadLocalConnections) {
        this.threadLocalConnections = threadLocalConnections;
    }

    public final void setLocatorsConfiguration(Object locatorsConfiguration) {
    }

    public final void setServersConfiguration(Object serversConfiguration) {
    }
}

