/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionConfigurationSource;
import org.springframework.data.gemfire.function.config.AnnotationFunctionExecutionConfigurationSource;
import org.springframework.data.gemfire.function.config.FunctionExecutionBeanDefinitionBuilderFactory;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class FunctionExecutionBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    FunctionExecutionBeanDefinitionRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        AnnotationFunctionExecutionConfigurationSource configurationSource = new AnnotationFunctionExecutionConfigurationSource(annotationMetadata);
        this.registerBeanDefinitions(configurationSource, registry);
    }

    void registerBeanDefinitions(AbstractFunctionExecutionConfigurationSource functionExecutionConfigurationSource, BeanDefinitionRegistry registry) {
        for (ScannedGenericBeanDefinition beanDefinition : functionExecutionConfigurationSource.getCandidates((ResourceLoader)new DefaultResourceLoader())) {
            String functionExecutionAnnotation = this.getFunctionExecutionAnnotation(beanDefinition, AnnotationFunctionExecutionConfigurationSource.getFunctionExecutionAnnotationTypeNames());
            Assert.notNull((Object)functionExecutionAnnotation);
            String beanName = (String)beanDefinition.getMetadata().getAnnotationAttributes(functionExecutionAnnotation).get("id");
            if (!StringUtils.hasText((String)beanName)) {
                beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
            }
            AbstractFunctionExecutionBeanDefinitionBuilder builder = FunctionExecutionBeanDefinitionBuilderFactory.newInstance(new FunctionExecutionConfiguration(beanDefinition, functionExecutionAnnotation));
            registry.registerBeanDefinition(beanName, builder.build(registry));
        }
    }

    private String getFunctionExecutionAnnotation(ScannedGenericBeanDefinition beanDefinition, Set<String> functionExecutionAnnotationTypeNames) {
        Set annotationTypes = beanDefinition.getMetadata().getAnnotationTypes();
        String functionExecutionAnnotation = null;
        for (String annotationType : annotationTypes) {
            if (!functionExecutionAnnotationTypeNames.contains(annotationType)) continue;
            Assert.isNull(functionExecutionAnnotation, (String)String.format("interface %1$s contains multiple Function Execution Annotations: %2$s, %3$s", beanDefinition.getBeanClassName(), functionExecutionAnnotation, annotationType));
            functionExecutionAnnotation = annotationType;
        }
        return functionExecutionAnnotation;
    }
}

