/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.serialization;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.Instantiator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.serialization.AsmInstantiatorGenerator;
import org.springframework.data.gemfire.serialization.InstantiatorGenerator;
import org.springframework.util.Assert;

public class InstantiatorFactoryBean
implements BeanClassLoaderAware,
FactoryBean<Collection<Instantiator>>,
InitializingBean {
    private InstantiatorGenerator generator;
    private Collection<Instantiator> list;
    private ClassLoader classLoader;
    private boolean autoRegister = true;
    private boolean distribute = false;
    private Map<Class<? extends DataSerializable>, Integer> types;

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty(this.types, (String)"no custom types for generating the Instantiators");
        if (this.generator == null) {
            this.generator = new AsmInstantiatorGenerator(this.classLoader);
        }
        this.list = new ArrayList<Instantiator>(this.types.size());
        for (Map.Entry<Class<? extends DataSerializable>, Integer> entry : this.types.entrySet()) {
            Assert.notNull(entry.getKey(), (String)"Invalid/Null class given as custom type");
            Assert.notNull((Object)entry.getValue(), (String)"Invalid/Null int given as user id");
            this.list.add(this.generator.getInstantiator(entry.getKey(), entry.getValue()));
        }
        if (this.autoRegister) {
            for (Instantiator instantiator : this.list) {
                Instantiator.register((Instantiator)instantiator, (boolean)this.distribute);
            }
        }
    }

    public Collection<Instantiator> getObject() throws Exception {
        return this.list;
    }

    public Class<?> getObjectType() {
        return this.list != null ? this.list.getClass() : Collection.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setCustomTypes(Map<Class<? extends DataSerializable>, Integer> types) {
        this.types = types;
    }

    public void setGenerator(InstantiatorGenerator generator) {
        this.generator = generator;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public void setDistribute(boolean distribute) {
        this.distribute = distribute;
    }
}

