/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.StringUtils;

public abstract class SpringUtils {
    public static BeanDefinition addDependsOn(BeanDefinition bean, String beanName) {
        String[] dependsOn = bean.getDependsOn();
        ArrayList<String> dependsOnList = new ArrayList<String>();
        Collections.addAll(dependsOnList, ArrayUtils.nullSafeArray(dependsOn, String.class));
        dependsOnList.add(beanName);
        bean.setDependsOn(dependsOnList.toArray(new String[dependsOnList.size()]));
        return bean;
    }

    public static String defaultIfEmpty(String value, String defaultValue) {
        return StringUtils.hasText((String)value) ? value : defaultValue;
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean equalsIgnoreNull(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static String dereferenceBean(String beanName) {
        return String.format("%1$s%2$s", "&", beanName);
    }
}

