/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.Cache;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractWANComponentFactoryBean<T>
extends AbstractFactoryBeanSupport<T>
implements DisposableBean,
InitializingBean {
    protected final Cache cache;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Object factory;
    private String beanName;
    private String name;

    protected AbstractWANComponentFactoryBean(Cache cache) {
        this.cache = cache;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setFactory(Object factory) {
        this.factory = factory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return StringUtils.hasText((String)this.name) ? this.name : this.beanName;
    }

    public final void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"Cache must not be null");
        Assert.notNull((Object)this.getName(), (String)"Name must not be null");
        this.doInit();
    }

    protected abstract void doInit() throws Exception;

    public void destroy() throws Exception {
    }
}

