/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.Arrays;
import java.util.Optional;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.EvictionAttributesMutator;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.wan.GatewaySender;
import org.springframework.data.gemfire.ResolvableRegionFactoryBean;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.Assert;

public class LookupRegionFactoryBean<K, V>
extends ResolvableRegionFactoryBean<K, V> {
    private AsyncEventQueue[] asyncEventQueues;
    private Boolean cloningEnabled;
    private Boolean enableStatistics;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private CustomExpiry<K, V> customEntryIdleTimeout;
    private CustomExpiry<K, V> customEntryTimeToLive;
    private ExpirationAttributes entryIdleTimeout;
    private ExpirationAttributes entryTimeToLive;
    private ExpirationAttributes regionIdleTimeout;
    private ExpirationAttributes regionTimeToLive;
    private GatewaySender[] gatewaySenders;
    private Integer evictionMaximum;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Optional.ofNullable(this.getRegion().getAttributesMutator()).ifPresent(attributesMutator -> {
            Arrays.stream(ArrayUtils.nullSafeArray(this.asyncEventQueues, AsyncEventQueue.class)).map(AsyncEventQueue::getId).forEach(arg_0 -> ((AttributesMutator)attributesMutator).addAsyncEventQueueId(arg_0));
            Arrays.stream(ArrayUtils.nullSafeArray(this.cacheListeners, CacheListener.class)).forEach(arg_0 -> ((AttributesMutator)attributesMutator).addCacheListener(arg_0));
            Optional.ofNullable(this.cacheLoader).ifPresent(arg_0 -> ((AttributesMutator)attributesMutator).setCacheLoader(arg_0));
            Optional.ofNullable(this.cacheWriter).ifPresent(arg_0 -> ((AttributesMutator)attributesMutator).setCacheWriter(arg_0));
            Optional.ofNullable(this.cloningEnabled).ifPresent(arg_0 -> ((AttributesMutator)attributesMutator).setCloningEnabled(arg_0));
            Optional.ofNullable(attributesMutator.getEvictionAttributesMutator()).ifPresent(evictionAttributesMutator -> Optional.ofNullable(this.evictionMaximum).ifPresent(arg_0 -> ((EvictionAttributesMutator)evictionAttributesMutator).setMaximum(arg_0)));
            if (this.isStatisticsEnabled()) {
                this.assertStatisticsEnabled();
                Optional.ofNullable(this.customEntryIdleTimeout).ifPresent(arg_0 -> ((AttributesMutator)attributesMutator).setCustomEntryIdleTimeout(arg_0));
                Optional.ofNullable(this.customEntryTimeToLive).ifPresent(arg_0 -> ((AttributesMutator)attributesMutator).setCustomEntryTimeToLive(arg_0));
                Optional.ofNullable(this.entryIdleTimeout).ifPresent(arg_0 -> ((AttributesMutator)attributesMutator).setEntryIdleTimeout(arg_0));
                Optional.ofNullable(this.entryTimeToLive).ifPresent(arg_0 -> ((AttributesMutator)attributesMutator).setEntryTimeToLive(arg_0));
                Optional.ofNullable(this.regionIdleTimeout).ifPresent(arg_0 -> ((AttributesMutator)attributesMutator).setRegionIdleTimeout(arg_0));
                Optional.ofNullable(this.regionTimeToLive).ifPresent(arg_0 -> ((AttributesMutator)attributesMutator).setRegionTimeToLive(arg_0));
            }
            Arrays.stream(ArrayUtils.nullSafeArray(this.gatewaySenders, GatewaySender.class)).map(GatewaySender::getId).forEach(arg_0 -> ((AttributesMutator)attributesMutator).addGatewaySenderId(arg_0));
        });
    }

    @Override
    public final boolean isLookupEnabled() {
        return true;
    }

    public void setAsyncEventQueues(AsyncEventQueue[] asyncEventQueues) {
        this.asyncEventQueues = asyncEventQueues;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setCloningEnabled(Boolean cloningEnabled) {
        this.cloningEnabled = cloningEnabled;
    }

    public void setCustomEntryIdleTimeout(CustomExpiry<K, V> customEntryIdleTimeout) {
        this.setStatisticsEnabled(customEntryIdleTimeout != null);
        this.customEntryIdleTimeout = customEntryIdleTimeout;
    }

    public void setCustomEntryTimeToLive(CustomExpiry<K, V> customEntryTimeToLive) {
        this.setStatisticsEnabled(customEntryTimeToLive != null);
        this.customEntryTimeToLive = customEntryTimeToLive;
    }

    public void setEntryIdleTimeout(ExpirationAttributes entryIdleTimeout) {
        this.setStatisticsEnabled(entryIdleTimeout != null);
        this.entryIdleTimeout = entryIdleTimeout;
    }

    public void setEntryTimeToLive(ExpirationAttributes entryTimeToLive) {
        this.setStatisticsEnabled(entryTimeToLive != null);
        this.entryTimeToLive = entryTimeToLive;
    }

    public void setEvictionMaximum(Integer evictionMaximum) {
        this.evictionMaximum = evictionMaximum;
    }

    public void setGatewaySenders(GatewaySender[] gatewaySenders) {
        this.gatewaySenders = gatewaySenders;
    }

    public void setRegionIdleTimeout(ExpirationAttributes regionIdleTimeout) {
        this.setStatisticsEnabled(regionIdleTimeout != null);
        this.regionIdleTimeout = regionIdleTimeout;
    }

    public void setRegionTimeToLive(ExpirationAttributes regionTimeToLive) {
        this.setStatisticsEnabled(regionTimeToLive != null);
        this.regionTimeToLive = regionTimeToLive;
    }

    public void setStatisticsEnabled(Boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    protected boolean isStatisticsEnabled() {
        return Boolean.TRUE.equals(this.enableStatistics);
    }

    private void assertStatisticsEnabled() {
        Region localRegion = this.getRegion();
        Assert.state((boolean)localRegion.getAttributes().getStatisticsEnabled(), (String)String.format("Statistics for Region [%s] must be enabled to change Entry & Region TTL/TTI Expiration settings", localRegion.getFullPath()));
    }
}

