/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.admin.remote;

import java.net.URI;
import org.apache.geode.cache.client.ClientCache;
import org.springframework.data.gemfire.config.admin.remote.FunctionGemfireAdminTemplate;
import org.springframework.data.gemfire.config.schema.definitions.IndexDefinition;
import org.springframework.data.gemfire.config.schema.definitions.RegionDefinition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class RestHttpGemfireAdminTemplate
extends FunctionGemfireAdminTemplate {
    protected static final boolean CREATE_REGION_SKIP_IF_EXISTS_DEFAULT = true;
    protected static final int DEFAULT_PORT = 7070;
    protected static final String DEFAULT_HOST = "localhost";
    protected static final String MANAGEMENT_REST_API_URL_TEMPLATE = "http://%1$s:%2$d/gemfire/v1/";
    private final RestOperations restTemplate = this.newRestOperations();
    private final String managementRestApiUrl;

    public RestHttpGemfireAdminTemplate(ClientCache clientCache) {
        this(clientCache, DEFAULT_HOST, 7070);
    }

    public RestHttpGemfireAdminTemplate(ClientCache clientCache, String host, int port) {
        super(clientCache);
        this.managementRestApiUrl = this.resolveManagementRestApiUrl(host, port);
    }

    RestOperations newRestOperations() {
        return new RestTemplate((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory());
    }

    private String resolveManagementRestApiUrl(String host, int port) {
        return String.format(MANAGEMENT_REST_API_URL_TEMPLATE, host, port);
    }

    protected String getManagementRestApiUrl() {
        return this.managementRestApiUrl;
    }

    protected RestOperations getRestOperations() {
        return this.restTemplate;
    }

    @Override
    public void createIndex(IndexDefinition indexDefinition) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap requestParameters = new LinkedMultiValueMap();
        requestParameters.add((Object)"name", (Object)indexDefinition.getName());
        requestParameters.add((Object)"expression", (Object)indexDefinition.getExpression());
        requestParameters.add((Object)"region", (Object)indexDefinition.getFromClause());
        requestParameters.add((Object)"type", (Object)indexDefinition.getIndexType().toString());
        RequestEntity requestEntity = new RequestEntity((Object)requestParameters, (MultiValueMap)httpHeaders, HttpMethod.POST, this.resolveCreateIndexUri());
        ResponseEntity response = this.getRestOperations().exchange(requestEntity, String.class);
        HttpStatus.OK.equals((Object)response.getStatusCode());
    }

    protected URI resolveCreateIndexUri() {
        return URI.create(this.getManagementRestApiUrl().concat("indexes"));
    }

    @Override
    public void createRegion(RegionDefinition regionDefinition) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap requestParameters = new LinkedMultiValueMap();
        requestParameters.add((Object)"name", (Object)regionDefinition.getName());
        requestParameters.add((Object)"type", (Object)regionDefinition.getRegionShortcut().toString());
        requestParameters.add((Object)"skip-if-exists", (Object)String.valueOf(true));
        RequestEntity requestEntity = new RequestEntity((Object)requestParameters, (MultiValueMap)httpHeaders, HttpMethod.POST, this.resolveCreateRegionUri());
        ResponseEntity response = this.getRestOperations().exchange(requestEntity, String.class);
        HttpStatus.OK.equals((Object)response.getStatusCode());
    }

    protected URI resolveCreateRegionUri() {
        return URI.create(this.getManagementRestApiUrl().concat("regions"));
    }
}

